/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.entity;

import games.stendhal.client.entity.AudibleEntity;
import games.stendhal.client.entity.Property;
import games.stendhal.common.constants.SoundLayer;
import marauroa.common.game.RPObject;

public abstract class Food
extends AudibleEntity {
    public static final Property PROP_AMOUNT = new Property();
    private static final String AMOUNT = "amount";
    private int amount;

    public int getAmount() {
        return this.amount;
    }

    @Override
    public void initialize(RPObject rPObject) {
        super.initialize(rPObject);
        this.addSounds(SoundLayer.CREATURE_NOISE.groupName, "food", "click-1");
        this.amount = rPObject.has(AMOUNT) ? rPObject.getInt(AMOUNT) : 0;
    }

    @Override
    public void onChangedAdded(RPObject rPObject, RPObject rPObject2) {
        super.onChangedAdded(rPObject, rPObject2);
        if (rPObject2.has(AMOUNT)) {
            int n = this.amount;
            this.amount = rPObject2.getInt(AMOUNT);
            if (this.amount > n) {
                this.playRandomSoundFromCategory(SoundLayer.AMBIENT_SOUND.groupName, "food");
            }
            this.fireChange(PROP_AMOUNT);
        }
    }
}

