/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.entity;

import games.stendhal.client.StendhalClient;
import games.stendhal.client.entity.Entity;
import games.stendhal.client.entity.Property;
import games.stendhal.client.entity.User;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;

public class GoldenCauldron
extends Entity {
    private static final long BREW_TIME_MILLIS = 300000L;
    public static final Property PROP_OPEN = new Property();
    public static final Property PROP_STATE = new Property();
    public static final Property PROP_STATUS = new Property();
    public static final Property PROP_BREWER = new Property();
    public static final Property PROP_READY_AT = new Property();
    private boolean open;
    private int state;
    private String status = "";
    private String brewer;
    private RPSlot content;
    private long readyAt;
    private int readyInSeconds;
    private long readyStartedAt;
    private String cacheKey;
    private static final Map<String, Long> READY_AT_CACHE = new ConcurrentHashMap<String, Long>();
    private static final Map<String, Long> READY_STARTED_CACHE = new ConcurrentHashMap<String, Long>();

    public RPSlot getContent() {
        return this.content;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isActive() {
        return this.state > 0;
    }

    public String getStatusText() {
        return this.status;
    }

    public long getReadyAt() {
        return this.readyAt;
    }

    public boolean isControlledByUser() {
        User user = User.get();
        if (user == null) {
            return false;
        }
        return this.brewer != null && this.brewer.equalsIgnoreCase(StendhalClient.get().getCharacter());
    }

    @Override
    public void initialize(RPObject rPObject) {
        super.initialize(rPObject);
        this.cacheKey = this.buildCacheKey(rPObject);
        this.content = rPObject.hasSlot("content") ? rPObject.getSlot("content") : null;
        this.open = rPObject.has("open");
        this.state = rPObject.has("state") ? rPObject.getInt("state") : 0;
        this.status = rPObject.has("status") ? rPObject.get("status") : "";
        this.brewer = rPObject.has("brewer") ? rPObject.get("brewer") : null;
        this.readyAt = rPObject.has("ready_at") ? rPObject.getLong("ready_at") : 0L;
        this.readyStartedAt = rPObject.has("ready_started_at") ? rPObject.getLong("ready_started_at") : 0L;
        this.readyInSeconds = rPObject.has("ready_in") ? rPObject.getInt("ready_in") : 0;
        this.restoreCachedTimes();
        this.ensureReadyAtFromStart();
        this.applyReadyInSeconds();
        this.cacheReadyTimes();
    }

    @Override
    public void onChangedAdded(RPObject rPObject, RPObject rPObject2) {
        super.onChangedAdded(rPObject, rPObject2);
        if (rPObject2.has("open")) {
            this.open = true;
            this.fireChange(PROP_OPEN);
        }
        if (rPObject2.has("state")) {
            this.state = rPObject2.getInt("state");
            this.fireChange(PROP_STATE);
        }
        if (rPObject2.has("status")) {
            this.status = rPObject2.get("status");
            this.fireChange(PROP_STATUS);
        }
        if (rPObject2.has("brewer")) {
            this.brewer = rPObject2.get("brewer");
            this.fireChange(PROP_BREWER);
        }
        if (rPObject2.has("ready_at")) {
            this.readyAt = rPObject2.getLong("ready_at");
            this.cacheReadyTimes();
            if (this.readyInSeconds <= 0) {
                this.fireChange(PROP_READY_AT);
            }
        }
        if (rPObject2.has("ready_started_at")) {
            this.readyStartedAt = rPObject2.getLong("ready_started_at");
            this.cacheReadyTimes();
            this.ensureReadyAtFromStart();
            if (!rPObject2.has("ready_at") && !rPObject2.has("ready_in")) {
                this.fireChange(PROP_READY_AT);
            }
        }
        if (rPObject2.has("ready_in")) {
            this.readyInSeconds = rPObject2.getInt("ready_in");
            this.applyReadyInSeconds();
            this.cacheReadyTimes();
            this.fireChange(PROP_READY_AT);
        }
    }

    @Override
    public void onChangedRemoved(RPObject rPObject, RPObject rPObject2) {
        super.onChangedRemoved(rPObject, rPObject2);
        if (rPObject2.has("open")) {
            this.open = false;
            this.fireChange(PROP_OPEN);
        }
        if (rPObject2.has("state")) {
            this.state = 0;
            this.fireChange(PROP_STATE);
        }
        if (rPObject2.has("status")) {
            this.status = "";
            this.fireChange(PROP_STATUS);
        }
        if (rPObject2.has("brewer")) {
            this.brewer = null;
            this.fireChange(PROP_BREWER);
        }
        if (rPObject2.has("ready_at")) {
            this.readyAt = 0L;
            if (!rPObject2.has("ready_in")) {
                this.readyInSeconds = 0;
            }
            this.cacheReadyTimes();
            this.fireChange(PROP_READY_AT);
        }
        if (rPObject2.has("ready_in")) {
            this.readyInSeconds = 0;
            if (!rPObject2.has("ready_at")) {
                this.fireChange(PROP_READY_AT);
            }
        }
        if (rPObject2.has("ready_started_at")) {
            this.readyStartedAt = 0L;
            this.cacheReadyTimes();
            if (!rPObject2.has("ready_at") && !rPObject2.has("ready_in")) {
                this.fireChange(PROP_READY_AT);
            }
        }
    }

    private void restoreCachedTimes() {
        Long l;
        if (this.readyAt <= 0L && (l = READY_AT_CACHE.get(this.getCacheKey())) != null && l > System.currentTimeMillis()) {
            this.readyAt = l;
        }
        if (this.readyStartedAt <= 0L) {
            l = READY_STARTED_CACHE.get(this.getCacheKey());
            if (l != null) {
                this.readyStartedAt = l;
            } else if (this.readyAt > 0L) {
                this.readyStartedAt = this.readyAt - 300000L;
            }
        }
    }

    private void cacheReadyTimes() {
        Long l;
        String string = this.getCacheKey();
        if (this.readyAt > 0L) {
            READY_AT_CACHE.put(string, this.readyAt);
        } else {
            l = READY_AT_CACHE.get(string);
            if (l != null && l <= System.currentTimeMillis()) {
                READY_AT_CACHE.remove(string);
            }
        }
        if (this.readyStartedAt > 0L) {
            READY_STARTED_CACHE.put(string, this.readyStartedAt);
        } else {
            long l2;
            l = READY_STARTED_CACHE.get(string);
            if (l != null && (l2 = l + 300000L) <= System.currentTimeMillis()) {
                READY_STARTED_CACHE.remove(string);
            }
        }
    }

    private String getCacheKey() {
        if (this.cacheKey == null) {
            RPObject.ID iD = this.getID();
            String string = iD != null ? iD.getZoneID() : "";
            int n = (int)Math.round(this.getX());
            int n2 = (int)Math.round(this.getY());
            this.cacheKey = string + ':' + n + ':' + n2;
        }
        return this.cacheKey;
    }

    private String buildCacheKey(RPObject rPObject) {
        RPObject.ID iD = rPObject.getID();
        String string = iD != null ? iD.getZoneID() : "";
        int n = rPObject.has("x") ? rPObject.getInt("x") : (int)Math.round(this.getX());
        int n2 = rPObject.has("y") ? rPObject.getInt("y") : (int)Math.round(this.getY());
        String string2 = rPObject.has("name") ? rPObject.get("name") : "";
        return string + ':' + string2 + ':' + n + ':' + n2;
    }

    private void applyReadyInSeconds() {
        long l;
        if (this.readyInSeconds <= 0) {
            this.ensureReadyAtFromStart();
            return;
        }
        long l2 = System.currentTimeMillis() + (long)this.readyInSeconds * 1000L;
        this.readyAt = this.readyAt > 0L ? Math.min(this.readyAt, l2) : (this.readyStartedAt > 0L ? ((l = this.readyStartedAt + 300000L) > System.currentTimeMillis() ? Math.min(l, l2) : l2) : l2);
    }

    private void ensureReadyAtFromStart() {
        if (this.readyStartedAt <= 0L) {
            return;
        }
        long l = this.readyStartedAt + 300000L;
        if (l <= 0L) {
            return;
        }
        if (this.readyAt <= 0L || this.readyAt > l) {
            this.readyAt = l;
        }
    }
}

