/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.entity.factory;

import games.stendhal.client.Triple;
import games.stendhal.client.entity.Block;
import games.stendhal.client.entity.Blood;
import games.stendhal.client.entity.BossCreature;
import games.stendhal.client.entity.Box;
import games.stendhal.client.entity.BreakableRing;
import games.stendhal.client.entity.CarrotGrower;
import games.stendhal.client.entity.Chest;
import games.stendhal.client.entity.Corpse;
import games.stendhal.client.entity.Creature;
import games.stendhal.client.entity.Door;
import games.stendhal.client.entity.Entity;
import games.stendhal.client.entity.Fire;
import games.stendhal.client.entity.FlyOverArea;
import games.stendhal.client.entity.GameBoard;
import games.stendhal.client.entity.Gate;
import games.stendhal.client.entity.Goat;
import games.stendhal.client.entity.GoldenCauldron;
import games.stendhal.client.entity.GrainField;
import games.stendhal.client.entity.HousePortal;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.InvisibleEntity;
import games.stendhal.client.entity.Item;
import games.stendhal.client.entity.LoopedSoundSource;
import games.stendhal.client.entity.NPC;
import games.stendhal.client.entity.Pet;
import games.stendhal.client.entity.PlantGrower;
import games.stendhal.client.entity.Player;
import games.stendhal.client.entity.Portal;
import games.stendhal.client.entity.Sheep;
import games.stendhal.client.entity.SheepFood;
import games.stendhal.client.entity.Sign;
import games.stendhal.client.entity.Spell;
import games.stendhal.client.entity.StatefulEntity;
import games.stendhal.client.entity.UseableItem;
import games.stendhal.client.entity.UseableRing;
import games.stendhal.client.entity.WalkBlocker;
import games.stendhal.client.entity.Wall;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public final class EntityMap {
    private static Map<Triple<String, String, String>, Class<? extends IEntity>> entityMap = new HashMap<Triple<String, String, String>, Class<? extends IEntity>>();

    private static void register() {
        EntityMap.register("item", null, null, Item.class);
        EntityMap.register("item", "box", null, Box.class);
        EntityMap.register("item", "club", "wizard_staff", UseableItem.class);
        EntityMap.register("item", "drink", null, UseableItem.class);
        EntityMap.register("item", "food", null, UseableItem.class);
        EntityMap.register("item", "misc", "bulb", UseableItem.class);
        EntityMap.register("item", "misc", "seed", UseableItem.class);
        EntityMap.register("item", "ring", null, UseableRing.class);
        EntityMap.register("item", "ring", "ametyst-ring", BreakableRing.class);
        EntityMap.register("item", "ring", "emerald-ring", BreakableRing.class);
        EntityMap.register("item", "scroll", null, UseableItem.class);
        EntityMap.register("item", "special", "mithril clasp", Item.class);
        EntityMap.register("item", "token", null, Item.class);
        EntityMap.register("item", "tool", "foodmill", UseableItem.class);
        EntityMap.register("item", "tool", "scrolleraser", UseableItem.class);
        EntityMap.register("item", "tool", "sugarmill", UseableItem.class);
        EntityMap.register("growing_entity_spawner", null, null, GrainField.class);
        EntityMap.register("growing_entity_spawner", "items/grower/carrot_grower", null, CarrotGrower.class);
        EntityMap.register("growing_entity_spawner", "items/grower/wood_grower", null, CarrotGrower.class);
        EntityMap.register("plant_grower", null, null, PlantGrower.class);
        EntityMap.register("rented_sign", null, null, Sign.class);
        EntityMap.register("shop_sign", null, null, Sign.class);
        EntityMap.register("sign", null, null, Sign.class);
        EntityMap.register("door", null, null, Door.class);
        EntityMap.register("gate", null, null, Gate.class);
        EntityMap.register("house_portal", null, null, HousePortal.class);
        EntityMap.register("portal", null, null, Portal.class);
        EntityMap.register("baby_dragon", null, null, Pet.class);
        EntityMap.register("cat", null, null, Pet.class);
        EntityMap.register("npc", null, null, NPC.class);
        EntityMap.register("pet", null, null, Pet.class);
        EntityMap.register("purple_dragon", null, null, Pet.class);
        EntityMap.register("owczarek", null, null, Pet.class);
        EntityMap.register("owczarek_podhalanski", null, null, Pet.class);
        EntityMap.register("sheep", null, null, Sheep.class);
        EntityMap.register("goat", null, null, Goat.class);
        EntityMap.register("training_dummy", null, null, NPC.class);
        EntityMap.register("creature", null, null, Creature.class);
        EntityMap.register("creature", "ent", "ent", BossCreature.class);
        EntityMap.register("creature", "ent", "entwife", BossCreature.class);
        EntityMap.register("creature", "ent", "old_ent", BossCreature.class);
        EntityMap.register("area", null, null, InvisibleEntity.class);
        EntityMap.register("blackboard", null, null, Sign.class);
        EntityMap.register("block", null, null, Block.class);
        EntityMap.register("blood", null, null, Blood.class);
        EntityMap.register("chest", null, null, Chest.class);
        EntityMap.register("corpse", null, null, Corpse.class);
        EntityMap.register("entity", null, null, Entity.class);
        EntityMap.register("fire", null, null, Fire.class);
        EntityMap.register("flyover", null, null, FlyOverArea.class);
        EntityMap.register("food", null, null, SheepFood.class);
        EntityMap.register("game_board", null, null, GameBoard.class);
        EntityMap.register("looped_sound_source", null, null, LoopedSoundSource.class);
        EntityMap.register("player", null, null, Player.class);
        EntityMap.register("spell", null, null, Spell.class);
        EntityMap.register("golden_cauldron", null, null, GoldenCauldron.class);
        EntityMap.register("useable_entity", "golden_cauldron", null, GoldenCauldron.class);
        EntityMap.register("useable_entity", null, null, StatefulEntity.class);
        EntityMap.register("walkblocker", null, null, WalkBlocker.class);
        EntityMap.register("wall", null, null, Wall.class);
        EntityMap.register("weather_entity", null, null, InvisibleEntity.class);
        EntityMap.register("fish_source", null, null, StatefulEntity.class);
        EntityMap.register("gold_source", null, null, StatefulEntity.class);
        EntityMap.register("well_source", null, null, StatefulEntity.class);
        EntityMap.register("wood_source", null, null, StatefulEntity.class);
    }

    private static void register(String string, String string2, String string3, Class<? extends IEntity> clazz) {
        entityMap.put(new Triple<String, String, String>(string, string2, string3), clazz);
    }

    public static Class<? extends IEntity> getClass(String string, String string2, String string3) {
        Class<? extends IEntity> clazz = entityMap.get(new Triple<String, String, String>(string, string2, string3));
        if (clazz == null) {
            clazz = entityMap.get(new Triple<String, String, Object>(string, string2, null));
        }
        if (clazz == null) {
            clazz = entityMap.get(new Triple<String, Object, Object>(string, null, null));
        }
        if (clazz == null) {
            Logger.getLogger(EntityMap.class).error((Object)("no class for " + string + "," + string2 + "," + string3));
        }
        return clazz;
    }

    static {
        EntityMap.register();
    }
}

