/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.events;

import games.stendhal.client.GameScreen;
import games.stendhal.client.entity.RPEntity;
import games.stendhal.client.events.Event;
import games.stendhal.client.gui.imageviewer.ImageViewWindow;
import games.stendhal.client.gui.imageviewer.ItemListImageViewerEvent;
import games.stendhal.client.gui.imageviewer.ViewPanel;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import games.stendhal.client.update.ClientGameConfiguration;
import games.stendhal.common.grammar.Grammar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.Logger;

public class ItemLogEvent
extends Event<RPEntity> {
    private static Logger logger = Logger.getLogger(ItemLogEvent.class);
    private static ArrayList<String> itemClassList = new ArrayList();

    @Override
    public void execute() {
        if (!this.event.has("dropped_items")) {
            logger.warn((Object)"Could not create item log: Event does not have \"dropped_items\" attribute");
            return;
        }
        ViewPanel viewPanel = new ViewPanel(){
            private static final int PAD = 5;
            private final Map<String, String> ITEM_CLASS_MAP = new HashMap<String, String>(){
                {
                    this.put("belts", "pasy");
                    this.put("ring", "pier\u015bcionki");
                    this.put("ranged", "zasi\u0119gowe");
                    this.put("necklace", "naszyjniki");
                    this.put("missile", "pociski");
                    this.put("magia", "magia");
                    this.put("money", "monety");
                    this.put("misc", "r\u00f3\u017cne");
                    this.put("wand", "r\u00f3\u017cd\u017cki");
                    this.put("resource", "zasoby");
                    this.put("boots", "buty");
                    this.put("club", "m\u0142oty");
                    this.put("sword", "miecze");
                    this.put("cloak", "p\u0142aszcze");
                    this.put("armor", "zbroje");
                    this.put("shield", "tarcze");
                    this.put("glove", "r\u0119kawice");
                    this.put("legs", "spodnie");
                    this.put("helmet", "he\u0142my");
                    this.put("jewellery", "klejnoty");
                    this.put("drink", "napoje");
                    this.put("dagger", "sztylety");
                    this.put("herb", "zio\u0142a");
                    this.put("scroll", "zwoje");
                    this.put("food", "jedzenie");
                    this.put("axe", "topory");
                    this.put("ammunition", "amunicja");
                }
            };

            @Override
            public void prepareView(Dimension dimension) {
                String[] stringArray;
                Dimension dimension2 = GameScreen.get().getSize();
                int n = dimension2.width - 180;
                JTabbedPane jTabbedPane = new JTabbedPane();
                this.addItemClassToList();
                for (String string : stringArray = this.getItemsClassList()) {
                    List<String> list = this.getItemsListForCategory(string);
                    JTable jTable = this.createTableForCategory(list);
                    JScrollPane jScrollPane = new JScrollPane(jTable);
                    jTabbedPane.addTab(string, jScrollPane);
                }
                jTabbedPane.setPreferredSize(new Dimension(n, Math.min(dimension2.height - 200, jTabbedPane.getPreferredSize().height + 20)));
                this.add((Component)jTabbedPane, "Center");
                this.setVisible(true);
            }

            private List<String> getItemsListForCategory(String string) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string2 : this.getItemsList()) {
                    String[] stringArray = string2.split(",");
                    if (!string.equals(this.getTranslatedClass(stringArray[3]))) continue;
                    arrayList.add(string2);
                }
                return arrayList;
            }

            private JTable createTableForCategory(List<String> list) {
                Object object;
                Object[] objectArray = new String[]{"#", "Nazwa przedmiotu", "Ile sztuk", "Zdobyto"};
                Object[][] objectArray2 = new Object[list.size()][];
                int n = 0;
                for (String object22 : list) {
                    object = object22.split(",");
                    objectArray2[n] = this.createDataRow((String[])object);
                    ++n;
                }
                final JTable jTable = new JTable(objectArray2, objectArray);
                jTable.setEnabled(true);
                jTable.setSelectionBackground(new Color(0, 0, 0, 50));
                jTable.setSelectionForeground(Color.WHITE);
                jTable.setFillsViewportHeight(true);
                jTable.setAutoResizeMode(3);
                TableColumn tableColumn = jTable.getColumnModel().getColumn(1);
                tableColumn.setCellRenderer(new DefaultTableCellRenderer());
                object = new DefaultTableCellRenderer();
                ((JLabel)object).setHorizontalAlignment(0);
                TableColumn tableColumn2 = jTable.getColumnModel().getColumn(0);
                tableColumn2.setCellRenderer(new SpriteCellRenderer());
                TableColumn tableColumn3 = jTable.getColumnModel().getColumn(2);
                tableColumn3.setCellRenderer((TableCellRenderer)object);
                TableColumn tableColumn4 = jTable.getColumnModel().getColumn(3);
                tableColumn4.setCellRenderer((TableCellRenderer)object);
                ItemListImageViewerEvent.HeaderRenderer headerRenderer = new ItemListImageViewerEvent.HeaderRenderer();
                Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
                while (enumeration.hasMoreElements()) {
                    TableColumn tableColumn5 = enumeration.nextElement();
                    tableColumn5.setHeaderRenderer(headerRenderer);
                }
                this.adjustColumnWidths(jTable);
                this.adjustRowHeights(jTable);
                jTable.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        try {
                            int n = jTable.getSelectedRow();
                            String string = jTable.getValueAt(n, 1).toString();
                            String string2 = this.getItemClass(string);
                            String string3 = ClientGameConfiguration.get((String)"DEFAULT_SERVER_WEB") + "/przedmioty/" + string2 + "/" + string.replace(" ", "_") + ".html";
                            Desktop.getDesktop().browse(new URI(string3));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                return jTable;
            }

            private List<String> getItemsList() {
                return Arrays.asList(ItemLogEvent.this.event.get("dropped_items").split(";"));
            }

            private String[] getItemsClassList() {
                if (itemClassList.isEmpty()) {
                    return new String[0];
                }
                return itemClassList.toArray(new String[0]);
            }

            private String getTranslatedClass(String string) {
                if (this.ITEM_CLASS_MAP.containsKey(string)) {
                    string = this.ITEM_CLASS_MAP.get(string);
                }
                return Grammar.capitalize(string);
            }

            private void addItemClassToList() {
                HashSet<String> hashSet = new HashSet<String>();
                for (int i = 0; i < this.getItemsList().size(); ++i) {
                    String[] stringArray = this.getItemsList().get(i).split(",");
                    hashSet.add(this.getTranslatedClass(stringArray[3]));
                }
                ArrayList arrayList = new ArrayList(hashSet);
                Collections.sort(arrayList);
                itemClassList = arrayList;
            }

            private String getItemClass(String string) {
                for (int i = 0; i < this.getItemsList().size(); ++i) {
                    String[] stringArray = this.getItemsList().get(i).split(",");
                    if (!Arrays.stream(stringArray).anyMatch(string::equals)) continue;
                    return stringArray[3];
                }
                return "";
            }

            private Object[] createDataRow(String[] stringArray) {
                Object[] objectArray = new Object[4];
                String string = stringArray[0];
                String string2 = stringArray[2];
                String string3 = stringArray[3];
                String string4 = stringArray[4];
                boolean bl = stringArray[1].equals("true");
                objectArray[0] = this.getItemImage(string3, string4, bl);
                objectArray[1] = string;
                objectArray[2] = "";
                objectArray[3] = "";
                if (bl) {
                    objectArray[2] = string2;
                    objectArray[3] = "\u2714";
                }
                return objectArray;
            }

            private Sprite getItemImage(String string, String string2, boolean bl) {
                String string3 = "/data/sprites/items/" + string + "/" + string2 + ".png";
                Sprite sprite = SpriteStore.get().getColoredSprite("/data/gui/bag.png", Color.LIGHT_GRAY);
                if (bl) {
                    sprite = SpriteStore.get().getSprite(string3);
                }
                if (sprite.getWidth() > sprite.getHeight()) {
                    sprite = SpriteStore.get().getAnimatedSprite(sprite, 100);
                }
                return sprite;
            }

            private void adjustColumnWidths(JTable jTable) {
                TableColumnModel tableColumnModel = jTable.getColumnModel();
                for (int i = 0; i < jTable.getColumnCount(); ++i) {
                    TableColumn tableColumn = tableColumnModel.getColumn(i);
                    int n = tableColumn.getWidth();
                    for (int j = 0; j < jTable.getRowCount(); ++j) {
                        Component component = jTable.prepareRenderer(jTable.getCellRenderer(j, i), j, i);
                        n = Math.max(n, component.getPreferredSize().width);
                    }
                    tableColumn.setPreferredWidth(n);
                }
            }

            private void adjustRowHeights(JTable jTable) {
                for (int i = 0; i < jTable.getRowCount(); ++i) {
                    int n = jTable.getRowHeight();
                    for (int j = 0; j < jTable.getColumnCount(); ++j) {
                        Component component = jTable.prepareRenderer(jTable.getCellRenderer(i, j), i, j);
                        n = Math.max(n, component.getPreferredSize().height);
                    }
                    jTable.setRowHeight(i, n);
                }
            }

            class SpriteCellRenderer
            extends JComponent
            implements TableCellRenderer {
                private Sprite sprite;

                SpriteCellRenderer() {
                }

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Object object2 = jTable.getValueAt(n, n2);
                    this.sprite = object2 instanceof Sprite ? (Sprite)object2 : null;
                    return this;
                }

                @Override
                public Dimension getPreferredSize() {
                    Dimension dimension = new Dimension();
                    if (this.sprite != null) {
                        dimension.width = this.sprite.getWidth() + 10;
                        dimension.height = this.sprite.getHeight() + 10;
                    }
                    return dimension;
                }

                @Override
                protected void paintComponent(Graphics graphics) {
                    if (this.sprite != null) {
                        this.sprite.draw(graphics, (this.getWidth() - this.sprite.getWidth()) / 2, (this.getHeight() - this.sprite.getHeight()) / 2);
                    }
                }
            }
        };
        new ImageViewWindow("Spis Przedmiot\u00f3w", viewPanel);
    }
}

