/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.gui.j2d.Blend;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteCache;
import games.stendhal.client.sprite.SpriteStore;
import games.stendhal.common.MathHelper;
import games.stendhal.common.color.ARGB;
import games.stendhal.common.color.HSL;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractColorSelector<T extends ColorSelectionModel>
extends JPanel {
    private final T model;

    AbstractColorSelector(T t) {
        this.model = t;
        this.setBorder(null);
        this.setLayout(new SBoxLayout(false, 5));
    }

    T getSelectionModel() {
        return this.model;
    }

    static class LightnessSelector
    extends AbstractSelector<HSLSelectionModel> {
        private static final int BAR_HEIGHT = 10;

        LightnessSelector(HSLSelectionModel hSLSelectionModel) {
            super(hSLSelectionModel);
        }

        @Override
        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            int n = 10 + insets.left + insets.right;
            int n2 = 10 + insets.top + insets.bottom;
            return new Dimension(n, n2);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Object object;
            Insets insets = this.getInsets();
            int n = this.getWidth() - insets.left - insets.right;
            int n2 = this.getWidth() - insets.left - insets.right;
            if (this.isEnabled()) {
                object = new float[3];
                int[] nArray = new int[4];
                nArray[0] = 255;
                object[0] = ((HSLSelectionModel)this.model).getHue();
                object[1] = ((HSLSelectionModel)this.model).getSaturation();
                Color[] colorArray = new Color[3];
                object[2] = 0.08f;
                HSL.hsl2rgb((float[])object, nArray);
                colorArray[0] = new Color(ARGB.mergeRgb(nArray));
                object[2] = 0.5f;
                HSL.hsl2rgb((float[])object, nArray);
                colorArray[1] = new Color(ARGB.mergeRgb(nArray));
                object[2] = 0.92f;
                HSL.hsl2rgb((float[])object, nArray);
                colorArray[2] = new Color(ARGB.mergeRgb(nArray));
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(insets.left, 0.0f, n, 0.0f, new float[]{0.0f, 0.5f, 1.0f}, colorArray);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fillRect(insets.left, insets.top, n, n2);
            } else {
                object = Color.BLACK;
                Color color = Color.WHITE;
                Graphics2D graphics2D = (Graphics2D)graphics;
                GradientPaint gradientPaint = new GradientPaint(insets.left, insets.top, (Color)object, n, insets.top, color);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(insets.left, insets.top, n, n2);
            }
            graphics.setColor(Color.BLACK);
            int n3 = (int)(((HSLSelectionModel)this.model).getLightness() * (float)n) + insets.left;
            graphics.drawLine(n3, 0, n3, this.getHeight());
            graphics.setColor(Color.WHITE);
            graphics.drawLine(++n3, 0, n3, this.getHeight());
        }

        @Override
        void select(Point point) {
            Insets insets = this.getInsets();
            int n = this.getWidth() - insets.left - insets.right;
            int n2 = point.x - insets.left;
            n2 = MathHelper.clamp(n2, 0, n);
            float f = (float)n2 / (float)n;
            f = MathHelper.clamp(f, 0.01f, 0.99f);
            ((HSLSelectionModel)this.model).setL(f);
        }

        @Override
        public void setEnabled(boolean bl) {
            boolean bl2 = this.isEnabled();
            super.setEnabled(bl);
            if (bl2 != bl) {
                this.repaint();
            }
        }
    }

    static class HSLSelectionModel
    extends DefaultColorSelectionModel {
        private float[] hsl = new float[3];

        HSLSelectionModel() {
        }

        @Override
        public void setSelectedColor(Color color) {
            if (color == null) {
                color = Color.GRAY;
            }
            int[] nArray = new int[4];
            ARGB.splitRgb(color.getRGB(), nArray);
            HSL.rgb2hsl(nArray, this.hsl);
            super.setSelectedColor(color);
        }

        void setHS(float f, float f2) {
            this.hsl[0] = f;
            this.hsl[1] = f2;
            this.updateColor();
        }

        void setL(float f) {
            this.hsl[2] = f;
            this.updateColor();
        }

        float getHue() {
            return this.hsl[0];
        }

        float getSaturation() {
            return this.hsl[1];
        }

        float getLightness() {
            return this.hsl[2];
        }

        private void updateColor() {
            int[] nArray = new int[4];
            HSL.hsl2rgb(this.hsl, nArray);
            nArray[0] = 255;
            super.setSelectedColor(new Color(ARGB.mergeRgb(nArray)));
        }
    }

    static abstract class AbstractSpriteColorSelector<T extends ColorSelectionModel>
    extends AbstractSelector<T> {
        static final int SPRITE_WIDTH = 80;
        static final int SPRITE_HEIGHT = 52;
        private Sprite normalSprite;
        private Sprite disabledSprite;

        AbstractSpriteColorSelector(T t) {
            super(t);
        }

        abstract Sprite createNormalSprite();

        private Sprite getNormalSprite() {
            if (this.normalSprite == null) {
                this.normalSprite = this.createNormalSprite();
            }
            return this.normalSprite;
        }

        Sprite getBackgroundSprite() {
            if (this.isEnabled()) {
                return this.getNormalSprite();
            }
            if (this.disabledSprite == null) {
                Sprite sprite = this.getNormalSprite();
                if (sprite.getReference() != null) {
                    SpriteCache.get().add(sprite.getReference(), sprite);
                    this.disabledSprite = SpriteStore.get().getColoredSprite(sprite.getReference().toString(), Color.GRAY);
                } else {
                    this.disabledSprite = SpriteStore.get().modifySprite(sprite, Color.GRAY, Blend.TrueColor, null);
                }
            }
            return this.disabledSprite;
        }

        @Override
        public Dimension getPreferredSize() {
            Sprite sprite = this.getBackgroundSprite();
            int n = sprite.getWidth();
            int n2 = sprite.getHeight();
            Insets insets = this.getInsets();
            return new Dimension(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Insets insets = this.getInsets();
            Sprite sprite = this.getBackgroundSprite();
            sprite.draw(graphics, insets.left, insets.right);
        }

        @Override
        public void setEnabled(boolean bl) {
            boolean bl2 = this.isEnabled();
            super.setEnabled(bl);
            if (bl2 != bl) {
                this.repaint();
            }
        }
    }

    static abstract class AbstractSelector<T extends ColorSelectionModel>
    extends JComponent
    implements ChangeListener {
        final T model;

        AbstractSelector(T t) {
            this.model = t;
            t.addChangeListener(this);
            this.setOpaque(true);
            this.applyStyle();
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    if (this.isEnabled()) {
                        this.select(mouseEvent.getPoint());
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (this.isEnabled()) {
                        this.select(mouseEvent.getPoint());
                    }
                }
            });
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.repaint();
        }

        private void applyStyle() {
            Style style = StyleUtil.getStyle();
            if (style != null) {
                this.setBorder(style.getBorderDown());
            }
        }

        abstract void select(Point var1);
    }
}

