/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.GameObjects;
import games.stendhal.client.StendhalClient;
import games.stendhal.client.entity.ContentChangeListener;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Inspector;
import games.stendhal.client.entity.User;
import games.stendhal.client.entity.factory.EntityMap;
import games.stendhal.client.gui.FeatureEnabledItemPanel;
import games.stendhal.client.gui.Inspectable;
import games.stendhal.client.gui.InternalManagedWindow;
import games.stendhal.client.gui.ItemPanel;
import games.stendhal.client.gui.ReserveSetWindow;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.listener.FeatureChangeListener;
import games.stendhal.client.sprite.SpriteStore;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import marauroa.common.game.RPAction;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;
import org.apache.log4j.Logger;

class Character
extends InternalManagedWindow
implements ContentChangeListener,
Inspectable {
    private static final long serialVersionUID = -5585214190674481472L;
    private static final int PADDING = 1;
    private static final int HAND_YSHIFT = 2;
    private static final Logger logger = Logger.getLogger(Character.class);
    private final Map<String, ItemPanel> slotPanels = new HashMap<String, ItemPanel>();
    private User player;
    private JComponent specialSlots;
    private JComponent setToggleRow;
    private JButton reserveToggleButton;
    private JButton setSwapButton;
    private JComponent setSlotsContainer;
    private JComponent equipmentRow;
    private ReserveSetWindow reserveWindow;
    private boolean reserveWindowVisible;
    private boolean pendingSetDrawerRefresh;
    private static final List<FeatureChangeListener> featureChangeListeners = new ArrayList<FeatureChangeListener>();
    private static FeatureEnabledItemPanel pouch;

    public Character() {
        super("character", "Character");
        this.createLayout();
        this.setCloseable(false);
    }

    public void setPlayer(User user) {
        this.player = user;
        user.addContentChangeListener(this);
        RPObject rPObject = user.getRPObject();
        this.updateSetToggleVisibility(rPObject);
        if (rPObject.hasSlot("belt")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Character.this.specialSlots.setVisible(true);
                }
            });
        }
        this.refreshContents();
    }

    private void createLayout() {
        JComponent jComponent = SBoxLayout.createContainer(false, 1);
        JComponent jComponent2 = SBoxLayout.createContainer(true, 1);
        JComponent jComponent3 = SBoxLayout.createContainer(false, 1);
        JComponent jComponent4 = SBoxLayout.createContainer(false, 1);
        JComponent jComponent5 = SBoxLayout.createContainer(false, 1);
        jComponent3.setAlignmentY(0.5f);
        jComponent5.setAlignmentY(0.5f);
        jComponent2.add(jComponent3);
        jComponent2.add(jComponent4);
        jComponent2.add(jComponent5);
        Class<? extends IEntity> clazz = EntityMap.getClass("item", null, null);
        SpriteStore spriteStore = SpriteStore.get();
        jComponent3.add(Box.createVerticalStrut(4));
        ItemPanel itemPanel = this.createItemPanel(clazz, spriteStore, "neck", "data/gui/slot-neck.png");
        jComponent3.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "rhand", "data/gui/slot-weapon.png");
        jComponent3.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "finger", "data/gui/slot-ring.png");
        jComponent3.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "fingerb", "data/gui/slot-ringb.png");
        jComponent3.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "head", "data/gui/slot-helmet.png");
        jComponent4.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "armor", "data/gui/slot-armor.png");
        jComponent4.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "pas", "data/gui/slot-belt.png");
        jComponent4.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "legs", "data/gui/slot-legs.png");
        jComponent4.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "feet", "data/gui/slot-boots.png");
        jComponent4.add(itemPanel);
        jComponent5.add(Box.createVerticalStrut(4));
        itemPanel = this.createItemPanel(clazz, spriteStore, "cloak", "data/gui/slot-cloak.png");
        jComponent5.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "lhand", "data/gui/slot-shield.png");
        jComponent5.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "glove", "data/gui/slot-gloves.png");
        jComponent5.add(itemPanel);
        pouch = new FeatureEnabledItemPanel("pouch", SpriteStore.get().getSprite("data/gui/slot-pouch.png"));
        this.slotPanels.put("pouch", pouch);
        pouch.setAcceptedTypes(clazz);
        jComponent5.add(pouch);
        featureChangeListeners.add(pouch);
        this.setToggleRow = SBoxLayout.createContainer(false, 0);
        this.setToggleRow.setAlignmentY(0.0f);
        this.reserveToggleButton = new JButton("<");
        this.reserveToggleButton.setMargin(new Insets(1, 0, 1, 0));
        this.reserveToggleButton.setFocusPainted(false);
        int n = 16;
        Dimension dimension = this.reserveToggleButton.getPreferredSize();
        dimension.height = Math.min(dimension.height, n);
        dimension.width = Math.max(dimension.width, 12);
        Dimension dimension2 = new Dimension(dimension.width, dimension.height);
        this.reserveToggleButton.setPreferredSize(dimension2);
        this.reserveToggleButton.setMinimumSize(dimension2);
        this.reserveToggleButton.setMaximumSize(new Dimension(dimension.width, Integer.MAX_VALUE));
        this.setToggleRow.setMinimumSize(new Dimension(dimension.width, 0));
        this.setToggleRow.setPreferredSize(dimension2);
        this.setToggleRow.setMaximumSize(new Dimension(dimension.width, Integer.MAX_VALUE));
        this.reserveToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Character.this.toggleReserveWindow();
            }
        });
        this.setToggleRow.add((Component)this.reserveToggleButton, SBoxLayout.constraint(SLayout.EXPAND_AXIAL));
        this.setToggleRow.setVisible(false);
        this.equipmentRow = SBoxLayout.createContainer(true, 1);
        this.equipmentRow.add((Component)this.setToggleRow, SBoxLayout.constraint(SLayout.EXPAND_PERPENDICULAR));
        this.equipmentRow.add(jComponent2);
        this.equipmentRow.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Character.this.updateToggleButtonHeight();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                Character.this.updateToggleButtonHeight();
            }
        });
        this.setSlotsContainer = this.createSetSlotLayout(clazz, spriteStore);
        this.setSlotsContainer.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Character.this.handleSetDrawerSizeChange();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                Character.this.handleSetDrawerSizeChange();
            }
        });
        this.reserveWindow = new ReserveSetWindow(this, this.setSlotsContainer);
        this.reserveWindow.attach();
        jComponent.add(this.equipmentRow);
        this.specialSlots = SBoxLayout.createContainer(true, 1);
        this.specialSlots.setAlignmentX(0.5f);
        this.specialSlots.setVisible(false);
        jComponent.add(this.specialSlots);
        itemPanel = this.createItemPanel(clazz, spriteStore, "belt", "data/gui/slot-key.png");
        this.specialSlots.add(itemPanel);
        this.setContent(jComponent);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Character.this.updateToggleButtonHeight();
            }
        });
    }

    private ItemPanel createItemPanel(Class<? extends IEntity> clazz, SpriteStore spriteStore, String string, String string2) {
        ItemPanel itemPanel = new ItemPanel(string, spriteStore.getSprite(string2));
        this.slotPanels.put(string, itemPanel);
        itemPanel.setAcceptedTypes(clazz);
        return itemPanel;
    }

    private JComponent createSetSlotLayout(Class<? extends IEntity> clazz, SpriteStore spriteStore) {
        JComponent jComponent = SBoxLayout.createContainer(false, 1);
        jComponent.setAlignmentY(0.0f);
        this.setSwapButton = new JButton("Zamie\u0144 zestawy");
        this.setSwapButton.setMargin(new Insets(1, 0, 1, 0));
        this.setSwapButton.setFocusPainted(false);
        int n = 16;
        Dimension dimension = this.setSwapButton.getPreferredSize();
        dimension.height = Math.min(dimension.height, n);
        Dimension dimension2 = new Dimension(dimension.width, dimension.height);
        this.setSwapButton.setPreferredSize(dimension2);
        this.setSwapButton.setMinimumSize(new Dimension(0, dimension.height));
        this.setSwapButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, dimension.height));
        this.setSwapButton.setAlignmentX(0.0f);
        this.setSwapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Character.this.swapSets();
            }
        });
        JComponent jComponent2 = SBoxLayout.createContainer(true, 1);
        JComponent jComponent3 = SBoxLayout.createContainer(false, 1);
        JComponent jComponent4 = SBoxLayout.createContainer(false, 1);
        JComponent jComponent5 = SBoxLayout.createContainer(false, 1);
        jComponent3.setAlignmentY(0.5f);
        jComponent5.setAlignmentY(0.5f);
        jComponent2.add(jComponent3);
        jComponent2.add(jComponent4);
        jComponent2.add(jComponent5);
        jComponent3.add(Box.createVerticalStrut(4));
        ItemPanel itemPanel = this.createItemPanel(clazz, spriteStore, "neck_set", "data/gui/slot-neck.png");
        jComponent3.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "rhand_set", "data/gui/slot-weapon.png");
        jComponent3.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "finger_set", "data/gui/slot-ring.png");
        jComponent3.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "fingerb_set", "data/gui/slot-ringb.png");
        jComponent3.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "head_set", "data/gui/slot-helmet.png");
        jComponent4.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "armor_set", "data/gui/slot-armor.png");
        jComponent4.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "pas_set", "data/gui/slot-belt.png");
        jComponent4.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "legs_set", "data/gui/slot-legs.png");
        jComponent4.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "feet_set", "data/gui/slot-boots.png");
        jComponent4.add(itemPanel);
        jComponent5.add(Box.createVerticalStrut(4));
        itemPanel = this.createItemPanel(clazz, spriteStore, "cloak_set", "data/gui/slot-cloak.png");
        jComponent5.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "lhand_set", "data/gui/slot-shield.png");
        jComponent5.add(itemPanel);
        itemPanel = this.createItemPanel(clazz, spriteStore, "glove_set", "data/gui/slot-gloves.png");
        jComponent5.add(itemPanel);
        FeatureEnabledItemPanel featureEnabledItemPanel = new FeatureEnabledItemPanel("pouch_set", spriteStore.getSprite("data/gui/slot-pouch.png"));
        this.slotPanels.put("pouch_set", featureEnabledItemPanel);
        featureEnabledItemPanel.setAcceptedTypes(clazz);
        jComponent5.add(featureEnabledItemPanel);
        featureChangeListeners.add(featureEnabledItemPanel);
        jComponent.add((Component)jComponent2, SBoxLayout.constraint(SLayout.EXPAND_AXIAL));
        jComponent.add(Box.createVerticalStrut(1));
        jComponent.add((Component)this.setSwapButton, SBoxLayout.constraint(SLayout.EXPAND_PERPENDICULAR));
        return jComponent;
    }

    private void updateToggleButtonHeight() {
        if (this.reserveToggleButton == null || this.setToggleRow == null || this.equipmentRow == null) {
            return;
        }
        int n = this.equipmentRow.getHeight();
        if (n <= 0) {
            n = this.equipmentRow.getPreferredSize().height;
        }
        if (n <= 0) {
            return;
        }
        Dimension dimension = this.reserveToggleButton.getPreferredSize();
        Dimension dimension2 = new Dimension(dimension.width, n);
        this.reserveToggleButton.setPreferredSize(dimension2);
        this.reserveToggleButton.setMinimumSize(new Dimension(dimension.width, n));
        this.reserveToggleButton.setMaximumSize(new Dimension(dimension.width, n));
        this.setToggleRow.setPreferredSize(dimension2);
        this.setToggleRow.setMinimumSize(new Dimension(dimension.width, n));
        this.setToggleRow.setMaximumSize(new Dimension(dimension.width, n));
        this.setToggleRow.revalidate();
    }

    private void toggleReserveWindow() {
        this.setReserveWindowVisible(!this.reserveWindowVisible);
    }

    private void updateSetToggleVisibility(RPObject rPObject) {
        if (rPObject == null) {
            return;
        }
        boolean bl = false;
        for (String string : this.slotPanels.keySet()) {
            if (!string.endsWith("_set") || !rPObject.hasSlot(string)) continue;
            bl = true;
            break;
        }
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Character.this.setToggleRow.setVisible(bl2);
                if (Character.this.reserveToggleButton != null) {
                    Character.this.reserveToggleButton.setEnabled(bl2);
                }
                if (!bl2) {
                    Character.this.setReserveWindowVisible(false);
                }
            }
        });
    }

    private void setReserveWindowVisible(boolean bl) {
        if (this.reserveWindowVisible == bl) {
            return;
        }
        this.reserveWindowVisible = bl;
        if (this.reserveWindow == null) {
            return;
        }
        if (bl) {
            this.reserveWindow.showBeside(this);
        } else {
            this.reserveWindow.hideWindow();
        }
    }

    void onReserveWindowVisibilityChange(final boolean bl) {
        this.reserveWindowVisible = bl;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Character.this.refreshSetDrawerLayout();
                if (Character.this.reserveToggleButton != null) {
                    Character.this.reserveToggleButton.setText(bl ? ">" : "<");
                }
                if (bl && Character.this.player != null) {
                    Character.this.refreshContents();
                    Character.this.refreshSetPanels();
                    Character.this.pendingSetDrawerRefresh = true;
                    Character.this.handleSetDrawerSizeChange();
                } else {
                    Character.this.pendingSetDrawerRefresh = false;
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void refreshSetDrawerLayout() {
        if (this.setSlotsContainer != null) {
            this.setSlotsContainer.invalidate();
            this.setSlotsContainer.revalidate();
            this.setSlotsContainer.repaint();
        }
        if (this.reserveWindow != null) {
            this.reserveWindow.invalidate();
            this.reserveWindow.revalidate();
            this.reserveWindow.repaint();
        }
        if (this.equipmentRow != null) {
            this.equipmentRow.invalidate();
            this.equipmentRow.revalidate();
            this.equipmentRow.doLayout();
            this.equipmentRow.repaint();
        }
        this.revalidate();
        this.repaint();
    }

    private void refreshSetPanels() {
        for (Map.Entry<String, ItemPanel> entry : this.slotPanels.entrySet()) {
            ItemPanel itemPanel;
            String string = entry.getKey();
            if (!string.endsWith("_set") || (itemPanel = entry.getValue()) == null) continue;
            itemPanel.invalidate();
            itemPanel.revalidate();
            itemPanel.repaint();
        }
    }

    private void handleSetDrawerSizeChange() {
        if (!this.pendingSetDrawerRefresh || !this.reserveWindowVisible) {
            return;
        }
        if (this.setSlotsContainer != null && this.setSlotsContainer.isShowing() && this.setSlotsContainer.getWidth() > 0) {
            this.pendingSetDrawerRefresh = false;
            this.refreshSetDrawerAfterReveal();
        }
    }

    private void refreshSetDrawerAfterReveal() {
        this.refreshSetDrawerLayout();
        if (this.player != null) {
            this.refreshContents();
        }
        this.refreshSetPanels();
    }

    private void swapSets() {
        if (this.player == null) {
            return;
        }
        RPAction rPAction = new RPAction();
        rPAction.put("type", "setchange");
        RPObject rPObject = this.player.getRPObject();
        if (rPObject != null && rPObject.has("zone")) {
            rPAction.put("zone", rPObject.get("zone"));
        }
        StendhalClient.get().send(rPAction);
    }

    private void refreshContents() {
        for (Map.Entry<String, ItemPanel> entry : this.slotPanels.entrySet()) {
            ItemPanel itemPanel = entry.getValue();
            if (itemPanel == null) continue;
            itemPanel.setParent(this.player);
            RPSlot rPSlot = this.player.getSlot(entry.getKey());
            if (rPSlot == null) continue;
            Iterator iterator = rPSlot.iterator();
            if (iterator.hasNext()) {
                RPObject rPObject = (RPObject)iterator.next();
                IEntity iEntity = GameObjects.getInstance().get(rPObject);
                itemPanel.setEntity(iEntity);
                continue;
            }
            itemPanel.setEntity(null);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Character.this.setTitle(Character.this.player.getName());
            }
        });
    }

    @Override
    public void contentAdded(RPSlot rPSlot) {
        ItemPanel itemPanel = this.slotPanels.get(rPSlot.getName());
        if (itemPanel == null) {
            return;
        }
        String string = rPSlot.getName();
        if (string.endsWith("_set")) {
            this.updateSetToggleVisibility(this.player.getRPObject());
        }
        if (("belt".equals(string) || "back".equals(string)) && !this.player.getRPObject().hasSlot(string)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Character.this.specialSlots.setVisible(true);
                }
            });
        }
        for (RPObject rPObject : rPSlot) {
            RPObject.ID iD = rPObject.getID();
            IEntity iEntity = itemPanel.getEntity();
            if (iEntity != null && iD.equals((Object)iEntity.getRPObject().getID())) {
                return;
            }
            iEntity = GameObjects.getInstance().get(rPObject);
            if (iEntity == null) {
                logger.error((Object)("Unable to find entity for: " + rPObject), new Throwable("here"));
                return;
            }
            itemPanel.setEntity(iEntity);
        }
    }

    @Override
    public void contentRemoved(RPSlot rPSlot) {
        ItemPanel itemPanel = this.slotPanels.get(rPSlot.getName());
        if (itemPanel == null) {
            return;
        }
        String string = rPSlot.getName();
        if (string.endsWith("_set")) {
            this.updateSetToggleVisibility(this.player.getRPObject());
        }
        for (RPObject rPObject : rPSlot) {
            RPObject.ID iD = rPObject.getID();
            IEntity iEntity = itemPanel.getEntity();
            if (iEntity != null && iD.equals((Object)iEntity.getRPObject().getID())) {
                if (rPObject.size() != 1) continue;
                itemPanel.setEntity(null);
                continue;
            }
            logger.error((Object)("Tried removing wrong object from a panel. removing: " + rPObject + " , but panel contains: " + itemPanel.getEntity()), new Throwable());
        }
    }

    @Override
    public void setInspector(Inspector inspector) {
        for (ItemPanel itemPanel : this.slotPanels.values()) {
            itemPanel.setInspector(inspector);
        }
    }

    public List<FeatureChangeListener> getFeatureChangeListeners() {
        return featureChangeListeners;
    }
}

