/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Inspector;
import games.stendhal.client.entity.factory.EntityMap;
import games.stendhal.client.gui.Inspectable;
import games.stendhal.client.gui.InternalManagedWindow;
import games.stendhal.client.gui.ManagedWindow;
import games.stendhal.client.gui.SlotWindow;
import games.stendhal.client.gui.TransparencyMode;
import games.stendhal.client.gui.layout.AnimatedLayout;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import marauroa.common.game.RPSlot;

class ContainerPanel
extends JScrollPane
implements Inspector,
InternalManagedWindow.WindowDragListener {
    private static final String WINDOW_ORDER_PROPERTY = "ui.window_order";
    private final List<String> windowOrder;
    private final PhantomLayoutPanel panel = new PhantomLayoutPanel();
    private int draggedPosition;

    public ContainerPanel() {
        if (TransparencyMode.TRANSPARENCY == 3) {
            this.panel.setLayout(new AnimatedLayout(new SBoxLayout(false)));
        } else {
            this.panel.setLayout(new SBoxLayout(false));
        }
        this.setViewportView(this.panel);
        this.setBorder(null);
        String string = WtWindowManager.getInstance().getProperty(WINDOW_ORDER_PROPERTY, "character;bag;keyring;magicbag;runicaltar");
        this.windowOrder = new ArrayList<String>(Arrays.asList(string.split(";")));
        this.getVerticalScrollBar().setUnitIncrement(16);
    }

    public void setAnimated(boolean bl) {
        LayoutManager layoutManager = this.panel.getLayout();
        if (layoutManager instanceof AnimatedLayout) {
            ((AnimatedLayout)layoutManager).setAnimated(bl);
        }
    }

    void addRepaintable(JComponent jComponent) {
        int n = this.panel.getComponentCount();
        if (jComponent instanceof InternalManagedWindow) {
            InternalManagedWindow internalManagedWindow = (InternalManagedWindow)jComponent;
            internalManagedWindow.addWindowDragListener(this);
            n = this.findWindowPosition(internalManagedWindow.getName());
        }
        if (jComponent instanceof Inspectable) {
            ((Inspectable)((Object)jComponent)).setInspector(this);
        }
        jComponent.setIgnoreRepaint(true);
        jComponent.setAlignmentX(0.0f);
        this.panel.add((Component)jComponent, n);
        this.panel.revalidate();
    }

    private int findWindowPosition(String string) {
        int n = this.windowOrder.indexOf(string);
        if (n != -1) {
            int n2 = 0;
            for (Component component : this.panel.getComponents()) {
                String string2;
                if (component instanceof ManagedWindow && n < this.windowOrder.indexOf(string2 = component.getName())) {
                    return n2;
                }
                ++n2;
            }
        } else {
            this.windowOrder.add(string);
            this.fireWindowOrderChanged();
        }
        return this.panel.getComponentCount();
    }

    private void fireWindowOrderChanged() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = this.windowOrder.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(';');
        }
        WtWindowManager.getInstance().setProperty(WINDOW_ORDER_PROPERTY, stringBuilder.toString());
    }

    private void checkWindowOrder(String string) {
        String string2 = null;
        for (Component component : this.panel.getComponents()) {
            if (!component.isVisible() || !(component instanceof ManagedWindow)) continue;
            String string3 = ((ManagedWindow)((Object)component)).getName();
            if (string.equals(string3)) {
                int n;
                int n2 = string2 == null ? 0 : this.windowOrder.indexOf(string2) + 1;
                if (n2 > (n = this.windowOrder.indexOf(string3))) {
                    this.windowOrder.add(n2, string3);
                    this.windowOrder.remove(string3);
                    this.fireWindowOrderChanged();
                } else if (n2 < n) {
                    this.windowOrder.remove(string3);
                    this.windowOrder.add(n2, string3);
                    this.fireWindowOrderChanged();
                }
                return;
            }
            string2 = string3;
        }
    }

    void repaintChildren() {
        for (Component component : this.panel.getComponents()) {
            component.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.panel.getPreferredSize();
        JScrollBar jScrollBar = this.getVerticalScrollBar();
        if (jScrollBar.isVisible()) {
            dimension.width += jScrollBar.getWidth();
        }
        return dimension;
    }

    @Override
    public SlotWindow inspectMe(IEntity iEntity, RPSlot rPSlot, SlotWindow slotWindow, int n, int n2) {
        if (slotWindow != null && slotWindow.isVisible()) {
            return slotWindow;
        }
        SlotWindow slotWindow2 = new SlotWindow(iEntity.getName(), n, n2);
        slotWindow2.setSlot(iEntity, rPSlot.getName());
        slotWindow2.setAcceptedTypes(EntityMap.getClass("item", null, null));
        slotWindow2.setVisible(true);
        this.addRepaintable(slotWindow2);
        return slotWindow2;
    }

    private int componentYCenter(Component component) {
        return component.getY() + component.getHeight() / 2;
    }

    @Override
    public void windowDragged(Component component, Point point) {
        int n = point.y + component.getHeight() / 2;
        for (int i = 0; i < this.panel.getComponentCount(); ++i) {
            Component component2 = this.panel.getComponent(i);
            if (component2 == component || component2 == this.panel.getPhantom()) continue;
            if (this.draggedPosition < i && n > this.componentYCenter(component2)) {
                this.draggedPosition = i;
                this.panel.setComponentZOrder(this.panel.getPhantom(), this.draggedPosition);
                this.panel.revalidate();
                break;
            }
            if (this.draggedPosition < i || n >= this.componentYCenter(component2)) continue;
            this.draggedPosition = i;
            this.panel.setComponentZOrder(this.panel.getPhantom(), this.draggedPosition);
            this.panel.revalidate();
            break;
        }
    }

    @Override
    public void startDrag(Component component) {
        this.draggedPosition = this.panel.getComponentZOrder(component);
        this.panel.hideComponent(component);
        this.panel.setComponentZOrder(component, 0);
    }

    @Override
    public void endDrag(Component component) {
        this.panel.setComponentZOrder(component, this.draggedPosition);
        this.panel.revealComponent();
        this.panel.revalidate();
        if (component instanceof ManagedWindow) {
            this.checkWindowOrder(((ManagedWindow)((Object)component)).getName());
        }
    }

    private static class PhantomComponent
    extends JComponent {
        private final Component component;

        PhantomComponent(Component component) {
            this.component = component;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.component.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.component.getMinimumSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.component.getMinimumSize();
        }
    }

    private static class PhantomLayoutPanel
    extends JPanel {
        Component hidden;
        PhantomComponent phantom;

        private PhantomLayoutPanel() {
        }

        void hideComponent(Component component) {
            this.hidden = component;
            this.phantom = new PhantomComponent(this.hidden);
            this.add((Component)this.phantom, this.getComponentZOrder(this.hidden));
        }

        void revealComponent() {
            this.remove(this.phantom);
            this.hidden = null;
            this.phantom = null;
        }

        Component getPhantom() {
            return this.phantom;
        }

        @Override
        public Component[] getComponents() {
            Component[] componentArray = super.getComponents();
            if (this.phantom == null) {
                return componentArray;
            }
            ArrayList<Component> arrayList = new ArrayList<Component>(Arrays.asList(componentArray));
            arrayList.remove(this.hidden);
            return arrayList.toArray(new Component[arrayList.size()]);
        }
    }
}

