/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.gui.ScrollerPanel;
import games.stendhal.client.gui.WindowUtils;
import games.stendhal.client.sprite.DataLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

class CreditsDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(CreditsDialog.class);
    private ScrollerPanel sp;
    private final JButton closeButton = new JButton("Zamknij");

    CreditsDialog(Frame frame) {
        super(frame, true);
        this.initGUI(frame);
        LOGGER.debug((Object)"about dialog initialized");
        this.eventHandling();
        LOGGER.debug((Object)"about dialog event handling ready");
        this.setTitle("Wyr\u00f3\u017cnieni przez PolanieOnLine");
        this.pack();
        Dimension dimension = frame.getSize();
        dimension.width -= 50;
        dimension.height -= 50;
        this.setSize(dimension);
        this.setLocationRelativeTo(frame);
        WindowUtils.closeOnEscape(this);
        this.setVisible(true);
    }

    private void initGUI(final Frame frame) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                frame.setEnabled(true);
                CreditsDialog.this.dispose();
            }
        });
        frame.setEnabled(false);
        Container container = this.getContentPane();
        if (container instanceof JComponent) {
            ((JComponent)container).setBorder(null);
        }
        Color color = Color.white;
        Color color2 = new Color(85, 85, 85);
        container.setLayout(new BorderLayout());
        container.setBackground(color);
        List<String> list = this.readCredits();
        Font font = new Font("SansSerif", 1, 12);
        this.sp = new ScrollerPanel(list, font, 0, color2, color, 20);
        JPanel jPanel = new JPanel();
        jPanel.add(this.closeButton);
        container.add((Component)this.sp, "Center");
        container.add((Component)jPanel, "South");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readCredits() {
        URL uRL = DataLoader.getResource("games/stendhal/client/gui/credits.txt");
        LinkedList<String> linkedList = new LinkedList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), "UTF-8"));){
            String string = bufferedReader.readLine();
            while (string != null) {
                linkedList.add(string);
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            linkedList.add(0, "credits.txt not found");
        }
        return linkedList;
    }

    private void eventHandling() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CreditsDialog.this.exit();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreditsDialog.this.exit();
            }
        });
    }

    private void exit() {
        this.sp.stop();
        this.setVisible(false);
        if (this.getOwner() != null) {
            this.getOwner().setEnabled(true);
        }
        this.dispose();
        LOGGER.debug((Object)"about dialog closed");
    }
}

