/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.StendhalClient;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Inspector;
import games.stendhal.client.entity.User;
import games.stendhal.client.entity.factory.EntityMap;
import games.stendhal.client.gui.Inspectable;
import games.stendhal.client.gui.InternalManagedWindow;
import games.stendhal.client.gui.SlotGrid;
import games.stendhal.client.gui.layout.SBoxLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import marauroa.common.game.RPObject;

public class GoldenCauldronWindow
extends InternalManagedWindow
implements Inspectable {
    private static final int MAX_DISTANCE = 4;
    private final SlotGrid grid;
    private final JLabel statusLabel;
    private final JButton mixButton;
    private IEntity parent;
    private ActionListener mixListener;
    private Timer countdownTimer;
    private long readyAt;
    private String baseStatus;

    public GoldenCauldronWindow(String string) {
        super("golden_cauldron", string);
        this.setMinimizable(false);
        this.setCloseable(true);
        this.setHideOnClose(true);
        this.grid = new SlotGrid(4, 2);
        this.grid.setOpaque(false);
        this.grid.setAcceptedTypes(EntityMap.getClass("item", null, null));
        this.statusLabel = new JLabel("Kocio\u0142 nie pracuje.");
        this.statusLabel.setHorizontalAlignment(0);
        this.mixButton = new JButton("Mieszaj");
        this.mixButton.setFocusable(false);
        this.mixButton.setAlignmentX(0.5f);
        this.mixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GoldenCauldronWindow.this.mixListener != null && GoldenCauldronWindow.this.mixButton.isEnabled()) {
                    GoldenCauldronWindow.this.mixListener.actionPerformed(actionEvent);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new SBoxLayout(false, 4));
        jPanel.setBorder(new EmptyBorder(4, 6, 6, 6));
        jPanel.setOpaque(false);
        jPanel.add(this.statusLabel);
        jPanel.add(this.grid);
        jPanel.add(this.mixButton);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        jPanel2.add((Component)jPanel, "Center");
        this.setContent(jPanel2);
    }

    public void setSlot(IEntity iEntity, String string) {
        this.parent = iEntity;
        this.grid.setSlot(iEntity, string);
    }

    @Override
    public void setInspector(Inspector inspector) {
        this.grid.setInspector(inspector);
    }

    public void updateStatus(final String string, final long l) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GoldenCauldronWindow.this.baseStatus = string == null ? "" : string;
                GoldenCauldronWindow.this.readyAt = l;
                GoldenCauldronWindow.this.restartCountdown();
            }
        });
    }

    public void setMixEnabled(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GoldenCauldronWindow.this.mixButton.setEnabled(bl);
            }
        });
    }

    public void setMixAction(ActionListener actionListener) {
        this.mixListener = actionListener;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.checkDistance();
    }

    @Override
    public void close() {
        this.grid.release();
        this.stopCountdown();
        super.close();
    }

    private void checkDistance() {
        if (!this.isCloseEnough()) {
            this.close();
        }
    }

    private void restartCountdown() {
        this.stopCountdown();
        if (this.readyAt > System.currentTimeMillis()) {
            this.countdownTimer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GoldenCauldronWindow.this.refreshStatusLabel();
                }
            });
            this.countdownTimer.setRepeats(true);
            this.countdownTimer.setInitialDelay(0);
            this.countdownTimer.start();
            this.refreshStatusLabel();
        } else {
            this.statusLabel.setText(this.baseStatus);
        }
    }

    private void refreshStatusLabel() {
        if (this.readyAt <= System.currentTimeMillis()) {
            this.stopCountdown();
            this.statusLabel.setText(this.baseStatus);
            return;
        }
        long l = this.readyAt - System.currentTimeMillis();
        long l2 = Math.max(0L, l / 1000L);
        long l3 = l2 / 60L;
        long l4 = l2 % 60L;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.baseStatus != null && !this.baseStatus.isEmpty()) {
            stringBuilder.append(this.baseStatus).append(' ');
        }
        stringBuilder.append("Pozosta\u0142o ");
        if (l3 > 0L) {
            if (l3 < 10L) {
                stringBuilder.append('0');
            }
            stringBuilder.append(l3).append(':');
            if (l4 < 10L) {
                stringBuilder.append('0');
            }
            stringBuilder.append(l4);
        } else {
            stringBuilder.append(l4).append(" s");
        }
        stringBuilder.append('.');
        this.statusLabel.setText(stringBuilder.toString());
    }

    private void stopCountdown() {
        if (this.countdownTimer != null) {
            this.countdownTimer.stop();
            this.countdownTimer = null;
        }
    }

    private boolean isCloseEnough() {
        User user = User.get();
        if (user == null || this.parent == null) {
            return true;
        }
        RPObject rPObject = this.parent.getRPObject().getBaseContainer();
        if (rPObject != null && rPObject.has("name") && StendhalClient.get().getCharacter().equalsIgnoreCase(rPObject.get("name"))) {
            return true;
        }
        return this.isCloseEnough(user.getX(), user.getY());
    }

    private boolean isCloseEnough(double d, double d2) {
        int n = (int)d;
        int n2 = (int)d2;
        Rectangle2D rectangle2D = this.parent.getArea();
        rectangle2D.setRect(rectangle2D.getX() - 4.0, rectangle2D.getY() - 4.0, rectangle2D.getWidth() + 8.0, rectangle2D.getHeight() + 8.0);
        return rectangle2D.contains(n, n2);
    }
}

