/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.StendhalClient;
import games.stendhal.client.gui.KTextEdit;
import games.stendhal.common.NotificationType;
import java.awt.Color;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import marauroa.common.game.RPAction;
import org.apache.log4j.Logger;

public class KHtmlEdit
extends KTextEdit {
    private static final long serialVersionUID = -8415450500521691744L;
    private static Logger logger = Logger.getLogger(KHtmlEdit.class);

    KHtmlEdit() {
        this.textPane.addHyperlinkListener(new ActivateLinkCB());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void activateLink(HyperlinkEvent hyperlinkEvent) {
        String string;
        URL uRL = hyperlinkEvent.getURL();
        if (uRL != null) {
            if (!uRL.getProtocol().equals("say")) {
                this.getToolkit().beep();
                return;
            }
            string = uRL.getPath();
            try {
                string = URLDecoder.decode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            string = hyperlinkEvent.getDescription();
            if (string.startsWith("say:")) {
                string = string.substring(4);
                try {
                    string = URLDecoder.decode(string, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        RPAction rPAction = new RPAction();
        rPAction.put("type", "chat");
        rPAction.put("text", string);
        StendhalClient.get().send(rPAction);
    }

    protected void appendString(String string) {
        HTMLDocument hTMLDocument = (HTMLDocument)this.textPane.getDocument();
        try {
            Element element = hTMLDocument.getParagraphElement(0);
            hTMLDocument.insertBeforeEnd(element, string);
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
        catch (IOException iOException) {
            logger.error((Object)iOException, (Throwable)iOException);
        }
    }

    protected void appendHTML(StringBuilder stringBuilder, char c) {
        switch (c) {
            case '<': {
                stringBuilder.append("&lt;");
                break;
            }
            case '>': {
                stringBuilder.append("&gt;");
                break;
            }
            case '&': {
                stringBuilder.append("&amp;");
                break;
            }
            default: {
                stringBuilder.append(c);
            }
        }
    }

    protected void appendHTML(StringBuilder stringBuilder, String string) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        while (c != '\uffff') {
            this.appendHTML(stringBuilder, c);
            c = stringCharacterIterator.next();
        }
    }

    protected String translateToHTML(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        while (c != '\uffff') {
            if (c == '#') {
                c = stringCharacterIterator.next();
                if (c == '#') {
                    this.appendHTML(stringBuilder, c);
                    c = stringCharacterIterator.next();
                    continue;
                }
                String string2 = this.extractLink(stringCharacterIterator);
                if (string2 != null) {
                    this.buildLink(stringBuilder, string2);
                }
                c = stringCharacterIterator.current();
                continue;
            }
            this.appendHTML(stringBuilder, c);
            c = stringCharacterIterator.next();
        }
        return stringBuilder.toString();
    }

    protected String extractLink(CharacterIterator characterIterator) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = characterIterator.current();
        int n2 = 32;
        if (n == 39) {
            n2 = n;
        }
        while (n != 65535) {
            if (n == n2) {
                if (n2 != 32) break;
                n = characterIterator.next();
                if (n == 35) {
                    n = 32;
                } else {
                    characterIterator.previous();
                    break;
                }
            }
            stringBuilder.append((char)n);
            n = characterIterator.next();
        }
        int n3 = stringBuilder.length();
        while (n3 != 0) {
            if (!this.isWordDelim(stringBuilder.charAt(--n3))) {
                ++n3;
                break;
            }
            stringBuilder.setLength(n3);
            characterIterator.previous();
        }
        if (n3 == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    protected boolean isWordDelim(char c) {
        switch (c) {
            case '!': 
            case ',': 
            case '.': 
            case ';': 
            case '?': {
                return true;
            }
        }
        return false;
    }

    protected void buildLink(StringBuilder stringBuilder, String string) {
        stringBuilder.append("<a href='");
        if (string.startsWith("http://") || string.startsWith("https://") || string.startsWith("ftp://")) {
            stringBuilder.append(string);
        } else {
            stringBuilder.append("say:");
            try {
                stringBuilder.append(URLEncoder.encode(string, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                stringBuilder.append(string);
            }
        }
        stringBuilder.append("'>");
        this.appendHTML(stringBuilder, string);
        stringBuilder.append("</a>");
    }

    protected String colorToRGB(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    protected void initStylesForTextPane(JTextPane jTextPane, int n) {
        jTextPane.setContentType("text/html");
        HTMLDocument hTMLDocument = (HTMLDocument)jTextPane.getDocument();
        StyleSheet styleSheet = hTMLDocument.getStyleSheet();
        styleSheet.addRule("body { font-family: Dialog; font-size: " + (n + 1) + "pt }");
        styleSheet.addRule("a { color: blue; font-style: italic }");
        styleSheet.addRule("._timestamp { color: " + this.colorToRGB(HEADER_COLOR) + "; font-size: " + (n - 1) + "pt; font-style: italic }");
        styleSheet.addRule("._header { color: " + this.colorToRGB(HEADER_COLOR) + " }");
        for (NotificationType notificationType : NotificationType.values()) {
            Color color = notificationType.getColor();
            if (color == null) continue;
            styleSheet.addRule("." + notificationType.getMnemonic() + " { color: " + this.colorToRGB(color) + "; font-weight: bold; }");
        }
    }

    @Override
    protected void insertHeader(String string) {
        if (string != null && string.length() != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<span class='_header'>");
            stringBuilder.append("&lt;");
            this.appendHTML(stringBuilder, string);
            stringBuilder.append("&gt;");
            stringBuilder.append("</span>");
            this.appendString(stringBuilder.toString());
        }
    }

    @Override
    protected void insertNewline() {
        this.appendString("<br>\n");
    }

    @Override
    protected void insertText(String string, NotificationType notificationType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<span class='");
        stringBuilder.append(notificationType.getMnemonic());
        stringBuilder.append("'>");
        stringBuilder.append(this.translateToHTML(string));
        stringBuilder.append("</span>");
        this.appendString(stringBuilder.toString());
    }

    @Override
    protected void insertTimestamp(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<span class='_timestamp'>");
        this.appendHTML(stringBuilder, string);
        stringBuilder.append("</span>");
        this.appendString(stringBuilder.toString());
    }

    private class ActivateLinkCB
    implements HyperlinkListener {
        private ActivateLinkCB() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                KHtmlEdit.this.activateLink(hyperlinkEvent);
            }
        }
    }
}

