/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import java.awt.Color;
import java.util.Map;
import java.util.TreeMap;
import marauroa.common.game.RPObject;
import org.apache.log4j.Logger;

public class OutfitColor {
    public static final String HAT = "hat";
    public static final String HAIR = "hair";
    public static final String MASK = "mask";
    public static final String EYES = "eyes";
    public static final String DRESS = "dress";
    public static final String SKIN = "skin";
    public static final String DETAIL = "detail";
    private static final String[] parts = new String[]{"dress", "skin", "hair", "detail", "eyes", "mask", "hat"};
    public static final OutfitColor PLAIN = new OutfitColor();
    private Map<String, Color> map = new TreeMap<String, Color>();

    private OutfitColor() {
    }

    OutfitColor(RPObject rPObject) {
        for (String string : parts) {
            String string2 = rPObject.get("outfit_colors", string);
            if (string2 == null) continue;
            try {
                int n = Integer.parseInt(string2);
                this.map.put(string, new Color(n));
            }
            catch (NumberFormatException numberFormatException) {
                Logger.getLogger(OutfitColor.class).warn((Object)("Invalid color : " + string + "=" + string2));
            }
        }
    }

    public static OutfitColor get(RPObject rPObject) {
        Map map = rPObject.getMap("outfit_colors");
        if (map != null && !map.isEmpty()) {
            return new OutfitColor(rPObject);
        }
        return PLAIN;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof OutfitColor) {
            return this.map.equals(((OutfitColor)object).map);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Color> entry : this.map.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue().getRGB());
            stringBuilder.append(";");
        }
        return stringBuilder.toString();
    }

    public Color getColor(String string) {
        return this.map.get(string);
    }

    void setColor(String string, Color color) {
        if (color != null) {
            this.map.put(string, color);
        } else {
            this.map.remove(string);
        }
    }
}

