/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.gui.Character;
import games.stendhal.client.gui.InternalManagedWindow;
import games.stendhal.client.gui.j2DClient;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

class ReserveSetWindow
extends InternalManagedWindow {
    private static final long serialVersionUID = -6792704385484299338L;
    private final Character owner;
    private boolean added;
    private boolean suppressVisibilityEvents;

    ReserveSetWindow(final Character character, JComponent jComponent) {
        super("reserve_set", "Schowek");
        this.owner = character;
        this.setContent(jComponent);
        this.setCloseable(false);
        this.setMinimizable(false);
        this.setMovable(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                if (!ReserveSetWindow.this.suppressVisibilityEvents) {
                    character.onReserveWindowVisibilityChange(true);
                }
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                if (!ReserveSetWindow.this.suppressVisibilityEvents) {
                    character.onReserveWindowVisibilityChange(false);
                }
            }
        });
    }

    void attach() {
        if (this.added) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReserveSetWindow.this.attach();
                }
            });
            return;
        }
        if (!this.tryAttach()) {
            this.scheduleAttachRetry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryAttach() {
        j2DClient j2DClient2 = j2DClient.get();
        if (j2DClient2 == null) {
            return false;
        }
        this.suppressVisibilityEvents = true;
        try {
            j2DClient2.addWindow(this);
            this.setVisible(false);
            this.added = true;
            boolean bl = true;
            return bl;
        }
        catch (NullPointerException nullPointerException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.suppressVisibilityEvents = false;
        }
    }

    private void scheduleAttachRetry() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReserveSetWindow.this.attach();
            }
        });
    }

    void showBeside(final Component component) {
        if (!this.added) {
            this.attach();
        }
        if (!this.added) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReserveSetWindow.this.showBeside(component);
                }
            });
            return;
        }
        Container container = this.getParent();
        if (container == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReserveSetWindow.this.showBeside(component);
                }
            });
            return;
        }
        Point point = component.getLocation();
        if (component.getParent() != container) {
            point = SwingUtilities.convertPoint(component.getParent(), point, container);
        }
        Dimension dimension = this.getPreferredSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            dimension = this.getSize();
        }
        if (dimension.width <= 0 || dimension.height <= 0) {
            dimension = component.getSize();
        }
        this.setSize(dimension);
        point.translate(-dimension.width, 0);
        this.moveTo(point.x, point.y);
        this.suppressVisibilityEvents = true;
        this.setVisible(true);
        this.suppressVisibilityEvents = false;
        this.raise();
        this.owner.onReserveWindowVisibilityChange(true);
    }

    void hideWindow() {
        if (!this.added) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReserveSetWindow.this.hideWindow();
                }
            });
            return;
        }
        this.suppressVisibilityEvents = true;
        this.setVisible(false);
        this.suppressVisibilityEvents = false;
        this.owner.onReserveWindowVisibilityChange(false);
    }
}

