/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.GameObjects;
import games.stendhal.client.entity.ContentChangeListener;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.User;
import games.stendhal.client.entity.factory.EntityMap;
import games.stendhal.client.gui.InternalManagedWindow;
import games.stendhal.client.gui.ItemPanel;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.sprite.SpriteStore;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;
import org.apache.log4j.Logger;

class RunicAltar
implements ContentChangeListener {
    private static final Logger logger = Logger.getLogger(RunicAltar.class);
    private InternalManagedWindow runicAltarDialog;
    private final Map<String, ItemPanel> slotPanels = new HashMap<String, ItemPanel>();
    private User player;
    private static final int PADDING = 1;

    public RunicAltar() {
        this.runicAltarDialog = this.createLayout();
        this.runicAltarDialog.setVisible(false);
    }

    public Component getRunicAltar() {
        return this.runicAltarDialog;
    }

    public void getVisibleRunicAltar() {
        this.runicAltarDialog.setVisible(true);
    }

    public void setPlayer(User user) {
        this.player = user;
        user.addContentChangeListener(this);
        this.refreshContents();
    }

    private InternalManagedWindow createLayout() {
        JComponent jComponent = SBoxLayout.createContainer(false, 1);
        JComponent jComponent2 = SBoxLayout.createContainer(true, 20);
        JComponent jComponent3 = SBoxLayout.createContainer(false, 15);
        JComponent jComponent4 = SBoxLayout.createContainer(false, 20);
        JComponent jComponent5 = SBoxLayout.createContainer(false, 15);
        jComponent3.setAlignmentY(0.5f);
        jComponent4.setAlignmentY(0.5f);
        jComponent5.setAlignmentY(0.5f);
        jComponent2.add(jComponent3);
        jComponent2.add(jComponent4);
        jComponent2.add(jComponent5);
        jComponent.add(jComponent2);
        Class<? extends IEntity> clazz = EntityMap.getClass("item", null, null);
        SpriteStore spriteStore = SpriteStore.get();
        jComponent3.add(this.createItemPanel(clazz, spriteStore, "control_rune", "data/gui/rune-control.png"));
        jComponent3.add(this.createItemPanel(clazz, spriteStore, "utility_rune", "data/gui/rune-utility.png"));
        jComponent4.add(this.createItemPanel(clazz, spriteStore, "offensive_rune", "data/gui/rune-offensive.png"));
        jComponent4.add(this.createItemPanel(clazz, spriteStore, "special_rune", "data/gui/rune-special.png"));
        jComponent4.add(this.createItemPanel(clazz, spriteStore, "defensive_rune", "data/gui/rune-defensive.png"));
        jComponent5.add(this.createItemPanel(clazz, spriteStore, "healing_rune", "data/gui/rune-healing.png"));
        jComponent5.add(this.createItemPanel(clazz, spriteStore, "resistance_rune", "data/gui/rune-resistance.png"));
        InternalManagedWindow internalManagedWindow = new InternalManagedWindow("runicaltar", "O\u0142tarz Runiczny");
        internalManagedWindow.setContent(jComponent);
        internalManagedWindow.setHideOnClose(true);
        internalManagedWindow.setMinimizable(true);
        internalManagedWindow.setMovable(true);
        return internalManagedWindow;
    }

    private ItemPanel createItemPanel(Class<? extends IEntity> clazz, SpriteStore spriteStore, String string, String string2) {
        ItemPanel itemPanel = new ItemPanel(string, spriteStore.getSprite(string2));
        this.slotPanels.put(string, itemPanel);
        itemPanel.setAcceptedTypes(clazz);
        return itemPanel;
    }

    private void refreshContents() {
        for (Map.Entry<String, ItemPanel> entry : this.slotPanels.entrySet()) {
            ItemPanel itemPanel = entry.getValue();
            if (itemPanel == null) continue;
            itemPanel.setParent(this.player);
            RPSlot rPSlot = this.player.getSlot(entry.getKey());
            if (rPSlot == null) continue;
            Iterator iterator = rPSlot.iterator();
            if (iterator.hasNext()) {
                RPObject rPObject = (RPObject)iterator.next();
                IEntity iEntity = GameObjects.getInstance().get(rPObject);
                itemPanel.setEntity(iEntity);
                continue;
            }
            itemPanel.setEntity(null);
        }
    }

    @Override
    public void contentAdded(RPSlot rPSlot) {
        ItemPanel itemPanel = this.slotPanels.get(rPSlot.getName());
        if (itemPanel == null) {
            return;
        }
        for (RPObject rPObject : rPSlot) {
            RPObject.ID iD = rPObject.getID();
            IEntity iEntity = itemPanel.getEntity();
            if (iEntity != null && iD.equals((Object)iEntity.getRPObject().getID())) {
                return;
            }
            iEntity = GameObjects.getInstance().get(rPObject);
            if (iEntity == null) {
                logger.error((Object)("Unable to find entity for: " + rPObject), new Throwable("here"));
                return;
            }
            itemPanel.setEntity(iEntity);
        }
    }

    @Override
    public void contentRemoved(RPSlot rPSlot) {
        ItemPanel itemPanel = this.slotPanels.get(rPSlot.getName());
        if (itemPanel == null) {
            return;
        }
        for (RPObject rPObject : rPSlot) {
            RPObject.ID iD = rPObject.getID();
            IEntity iEntity = itemPanel.getEntity();
            if (iEntity != null && iD.equals((Object)iEntity.getRPObject().getID())) {
                if (rPObject.size() != 1) continue;
                itemPanel.setEntity(null);
                continue;
            }
            logger.error((Object)("Tried removing wrong object from a panel. removing: " + rPObject + " , but panel contains: " + itemPanel.getEntity()), new Throwable());
        }
    }
}

