/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.StendhalClient;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Inspector;
import games.stendhal.client.entity.User;
import games.stendhal.client.gui.Inspectable;
import games.stendhal.client.gui.InternalManagedWindow;
import games.stendhal.client.gui.SlotGrid;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import javax.swing.SwingUtilities;
import marauroa.common.game.RPObject;
import org.apache.log4j.Logger;

public class SlotWindow
extends InternalManagedWindow
implements Inspectable {
    private static Logger logger = Logger.getLogger(SlotWindow.class);
    private static final int MAX_DISTANCE = 4;
    private final SlotGrid content;
    private IEntity parent;

    public SlotWindow(String string, int n, int n2) {
        super(string, string);
        this.content = new SlotGrid(n, n2);
        this.setContent(this.content);
    }

    protected void setSlotsLayout(int n, int n2) {
        this.content.setSlotsLayout(n, n2);
        this.setContent(this.content);
        String string = this.content.getSlotName();
        if (this.parent != null && string != null) {
            this.content.setSlot(this.parent, string);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SlotWindow.this.revalidate();
                SlotWindow.this.repaint();
            }
        });
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    logger.error((Object)interruptedException, (Throwable)interruptedException);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Component component = SwingUtilities.getRoot(SlotWindow.this.getParent());
                        component.doLayout();
                        component.revalidate();
                        component.repaint();
                    }
                });
            }
        }).start();
    }

    @SafeVarargs
    public final void setAcceptedTypes(Class<? extends IEntity> ... classArray) {
        this.content.setAcceptedTypes(classArray);
    }

    public void setSlot(IEntity iEntity, String string) {
        this.parent = iEntity;
        this.content.setSlot(iEntity, string);
    }

    @Override
    public void setInspector(Inspector inspector) {
        this.content.setInspector(inspector);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.checkDistance();
    }

    private void checkDistance() {
        if (!this.isCloseEnough()) {
            this.close();
        }
    }

    @Override
    public void close() {
        this.content.release();
        super.close();
    }

    public boolean isCloseEnough() {
        User user = User.get();
        if (user != null && this.parent != null) {
            RPObject rPObject = this.parent.getRPObject().getBaseContainer();
            String string = rPObject.getRPClass().getName();
            if (string.equals("player") && rPObject.has("name") && StendhalClient.get().getCharacter().equalsIgnoreCase(rPObject.get("name"))) {
                return true;
            }
            return this.isCloseEnough(user.getX(), user.getY());
        }
        return true;
    }

    private boolean isCloseEnough(double d, double d2) {
        int n = (int)d;
        int n2 = (int)d2;
        Rectangle2D rectangle2D = this.parent.getArea();
        rectangle2D.setRect(rectangle2D.getX() - 4.0, rectangle2D.getY() - 4.0, rectangle2D.getWidth() + 8.0, rectangle2D.getHeight() + 8.0);
        return rectangle2D.contains(n, n2);
    }
}

