/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.StendhalClient;
import games.stendhal.client.gui.BareBonesBrowserLaunch;
import games.stendhal.client.gui.CreditsDialog;
import games.stendhal.client.gui.Initializer;
import games.stendhal.client.gui.TransparencyGraphicsWrapper;
import games.stendhal.client.gui.WindowUtils;
import games.stendhal.client.gui.login.CreateAccountDialog;
import games.stendhal.client.gui.login.LoginDialog;
import games.stendhal.client.sprite.DataLoader;
import games.stendhal.client.stendhal;
import games.stendhal.client.update.ClientGameConfiguration;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.ActionEvent;
import java.awt.image.ImageObserver;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class StendhalFirstScreen
extends JFrame {
    private static final long serialVersionUID = -7825572598938892220L;
    private static final String FONT_NAME = "BlackChancery";
    private static final int FONT_SIZE = 16;
    private final StendhalClient client;
    private BackgroundComponent backgroundComponent;
    private JButton loginButton;
    private JButton createAccountButton;
    private JButton helpButton;
    private JButton creditButton;
    private final Point zeroPoint = new Point();

    public StendhalFirstScreen(StendhalClient stendhalClient) {
        super(StendhalFirstScreen.detectScreen());
        this.setLocationByPlatform(true);
        WindowUtils.trackLocation(this, "main", true);
        this.client = stendhalClient;
        stendhalClient.setSplashScreen(this);
        this.initializeComponent();
        this.setVisible(true);
    }

    private static GraphicsConfiguration detectScreen() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo != null) {
            return pointerInfo.getDevice().getDefaultConfiguration();
        }
        return null;
    }

    private void initializeComponent() {
        this.backgroundComponent = new BackgroundComponent();
        this.setContentPane(this.backgroundComponent);
        Font font = new Font(FONT_NAME, 0, 16);
        String string = ClientGameConfiguration.get((String)"GAME_NAME");
        AbstractAction abstractAction = new AbstractAction("Zaloguj do gry"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new LoginDialog((Frame)StendhalFirstScreen.this, StendhalFirstScreen.this.client).setVisible(true);
            }
        };
        abstractAction.putValue("MnemonicKey", 76);
        abstractAction.putValue("ShortDescription", "Naci\u015bnij ten przycisk, aby zalogowa\u0107 sie na serwer " + string + ".");
        this.loginButton = this.createTransparentButton();
        this.loginButton.setAction(abstractAction);
        this.loginButton.setFont(font);
        AbstractAction abstractAction2 = new AbstractAction("Utw\u00f3rz konto"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new CreateAccountDialog((Frame)StendhalFirstScreen.this, StendhalFirstScreen.this.client);
            }
        };
        abstractAction2.putValue("MnemonicKey", 65);
        abstractAction2.putValue("ShortDescription", "Naci\u015bnij ten przycisk, aby utworzy\u0107 konto na serwerze " + string + ".");
        this.createAccountButton = this.createTransparentButton();
        this.createAccountButton.setFont(font);
        this.createAccountButton.setAction(abstractAction2);
        AbstractAction abstractAction3 = new AbstractAction("Pomoc"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BareBonesBrowserLaunch.openURL(ClientGameConfiguration.get((String)"DEFAULT_SERVER_WEB") + "/wprowadzenie.html");
            }
        };
        abstractAction3.putValue("MnemonicKey", 72);
        this.helpButton = this.createTransparentButton();
        this.helpButton.setFont(font);
        this.helpButton.setAction(abstractAction3);
        AbstractAction abstractAction4 = new AbstractAction("Wyr\u00f3\u017cnieni"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new CreditsDialog(StendhalFirstScreen.this);
            }
        };
        abstractAction4.putValue("MnemonicKey", 67);
        this.creditButton = this.createTransparentButton();
        this.creditButton.setFont(font);
        this.creditButton.setAction(abstractAction4);
        this.setDefaultCloseOperation(3);
        this.backgroundComponent.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.weighty = 1.0;
        this.backgroundComponent.add(Box.createVerticalGlue(), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.backgroundComponent.add((Component)this.loginButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.backgroundComponent.add((Component)this.createAccountButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.backgroundComponent.add((Component)this.helpButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.backgroundComponent.add((Component)this.creditButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.backgroundComponent.add(Box.createVerticalStrut(10), gridBagConstraints);
        this.getRootPane().setDefaultButton(this.loginButton);
        this.setTitle(string + " " + stendhal.VERSION + " - darmowa gra MMORPG - polanieonline.eu");
        URL uRL = DataLoader.getResource(ClientGameConfiguration.get((String)"GAME_ICON"));
        this.setIconImage(new ImageIcon(uRL).getImage());
        this.pack();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.loginButton.setEnabled(bl);
        this.createAccountButton.setEnabled(bl);
        this.helpButton.setEnabled(bl);
        this.creditButton.setEnabled(bl);
    }

    private JButton createTransparentButton() {
        return new JButton(){

            @Override
            public void paint(Graphics graphics) {
                super.paint(StendhalFirstScreen.this.getWrapperGraphics(graphics, this));
            }
        };
    }

    private Graphics getWrapperGraphics(Graphics graphics, JComponent jComponent) {
        if (graphics instanceof TransparencyGraphicsWrapper) {
            return graphics;
        }
        Dimension dimension = this.getSize();
        Point point = SwingUtilities.convertPoint(jComponent, this.zeroPoint, this);
        this.backgroundComponent.paintBgImage(graphics, dimension, -point.x, -point.y);
        return BackgroundComponent.createGraphicsWrapper(graphics);
    }

    static {
        Initializer.init();
    }

    private static class BackgroundComponent
    extends JComponent {
        private final ImageObserver emptyObserver = (image, n, n2, n3, n4, n5) -> false;
        private final Image bgImage;
        private final Dimension bgImageSize;

        public BackgroundComponent() {
            URL uRL = DataLoader.getResource(ClientGameConfiguration.get((String)"GAME_SPLASH_BACKGROUND"));
            this.bgImage = new ImageIcon(uRL).getImage();
            this.bgImageSize = new Dimension(this.bgImage.getWidth(this.emptyObserver), this.bgImage.getHeight(this.emptyObserver));
            this.setPreferredSize(this.bgImageSize);
        }

        @Override
        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            this.paintBgImage(graphics, dimension, 0, 0);
            Graphics graphics2 = this.getComponentGraphics(graphics);
            super.paint(graphics2);
        }

        public void paintBgImage(Graphics graphics, Dimension dimension, int n, int n2) {
            int n3;
            int n4;
            if (this.bgImageSize.width * dimension.height >= dimension.width * this.bgImageSize.height) {
                n4 = dimension.height * this.bgImageSize.width / this.bgImageSize.height;
                n3 = dimension.height;
            } else {
                n4 = dimension.width;
                n3 = dimension.width * this.bgImageSize.height / this.bgImageSize.width;
            }
            graphics.drawImage(this.bgImage, n, n2, n4, n3, this.emptyObserver);
        }

        @Override
        protected Graphics getComponentGraphics(Graphics graphics) {
            return BackgroundComponent.createGraphicsWrapper(graphics);
        }

        private static TransparencyGraphicsWrapper createGraphicsWrapper(Graphics graphics) {
            if (graphics instanceof TransparencyGraphicsWrapper) {
                return (TransparencyGraphicsWrapper)graphics;
            }
            return new TransparencyGraphicsWrapper((Graphics2D)graphics, 255);
        }
    }
}

