/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.GameLoop;
import games.stendhal.client.GameScreen;
import games.stendhal.client.StendhalClient;
import games.stendhal.client.UserContext;
import games.stendhal.client.WeatherSoundManager;
import games.stendhal.client.World;
import games.stendhal.client.Zone;
import games.stendhal.client.actions.SlashActionRepository;
import games.stendhal.client.entity.Entity;
import games.stendhal.client.entity.User;
import games.stendhal.client.entity.factory.EntityMap;
import games.stendhal.client.gui.Bag;
import games.stendhal.client.gui.Character;
import games.stendhal.client.gui.ChatLogArea;
import games.stendhal.client.gui.ContainerPanel;
import games.stendhal.client.gui.DragLayer;
import games.stendhal.client.gui.GameKeyHandler;
import games.stendhal.client.gui.J2DClientGUI;
import games.stendhal.client.gui.KeyRing;
import games.stendhal.client.gui.MagicBag;
import games.stendhal.client.gui.MainFrame;
import games.stendhal.client.gui.NotificationChannelManager;
import games.stendhal.client.gui.OutfitColor;
import games.stendhal.client.gui.OutfitDialog;
import games.stendhal.client.gui.QuitDialog;
import games.stendhal.client.gui.RunicAltar;
import games.stendhal.client.gui.ScreenController;
import games.stendhal.client.gui.ScrolledViewport;
import games.stendhal.client.gui.SettingsPanel;
import games.stendhal.client.gui.WindowUtils;
import games.stendhal.client.gui.buddies.BuddyPanelController;
import games.stendhal.client.gui.chattext.CharacterMap;
import games.stendhal.client.gui.chattext.ChatCompletionHelper;
import games.stendhal.client.gui.chattext.ChatTextController;
import games.stendhal.client.gui.group.GroupPanelController;
import games.stendhal.client.gui.layout.FreePlacementLayout;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.gui.map.MapPanelController;
import games.stendhal.client.gui.spells.Spells;
import games.stendhal.client.gui.stats.StatsPanelController;
import games.stendhal.client.gui.styled.StyledTabbedPaneUI;
import games.stendhal.client.gui.wt.core.SettingChangeListener;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.listener.FeatureChangeListener;
import games.stendhal.client.listener.PositionChangeListener;
import games.stendhal.client.stendhal;
import games.stendhal.common.MathHelper;
import games.stendhal.common.NotificationType;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TabbedPaneUI;
import marauroa.common.game.RPAction;
import marauroa.common.game.RPObject;
import org.apache.log4j.Logger;

class SwingClientGUI
implements J2DClientGUI {
    private static final int SCROLLING_SPEED = 8;
    private static final String SCALE_PREFERENCE_PROPERTY = "ui.scale_screen";
    private static final Logger logger = Logger.getLogger(SwingClientGUI.class);
    private final JLayeredPane pane;
    private final GameScreen screen;
    private final ScreenController screenController;
    private final ContainerPanel containerPanel;
    private final QuitDialog quitDialog;
    private final UserContext userContext;
    private final ChatTextController chatText = ChatTextController.get();
    private MapPanelController minimap;
    private JSplitPane verticalSplit;
    private final JFrame frame;
    private final JComponent chatLogArea;
    private final JComponent leftColumn;
    private JSplitPane horizontalSplit;
    private final Dimension frameDefaultSize;
    private Character character;
    private Bag inventory;
    private KeyRing keyring;
    private MagicBag magicbag;
    private RunicAltar runicAltar;
    private Spells spells;
    private boolean offline;
    private int paintCounter;
    private User user;
    private GameKeyHandler gameKeyHandler;
    private OutfitDialog outfitDialog;
    private FocusAdapter chatFocusRedirector;
    private boolean chatFocusRedirectInstalled;

    public SwingClientGUI(final StendhalClient stendhalClient, UserContext userContext, NotificationChannelManager notificationChannelManager, JFrame jFrame) {
        this.userContext = userContext;
        this.setupInternalWindowProperties();
        this.pane = new JLayeredPane();
        this.pane.setLayout(new FreePlacementLayout());
        this.screen = GameScreen.get(stendhalClient);
        GameScreen.setDefaultScreen(this.screen);
        this.screenController = ScreenController.get(this.screen);
        this.pane.addComponentListener(new GameScreenResizer(this.screen));
        this.pane.add(this.screen, Float.valueOf(0.0f), JLayeredPane.DEFAULT_LAYER);
        this.runicAltar = new RunicAltar();
        this.pane.add(this.runicAltar.getRunicAltar(), JLayeredPane.MODAL_LAYER);
        this.quitDialog = new QuitDialog();
        this.pane.add(this.quitDialog.getQuitDialog(), JLayeredPane.MODAL_LAYER);
        this.setupChatEntry();
        this.chatLogArea = this.createChatLog(notificationChannelManager);
        this.containerPanel = this.createContainerPanel();
        this.leftColumn = this.createLeftPanel(stendhalClient);
        this.frame = this.prepareMainWindow(jFrame);
        this.setupChatText();
        this.setupZoneChangeListeners(stendhalClient);
        this.setupOverallLayout();
        int n = this.verticalSplit.getDividerSize();
        WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        wtWindowManager.registerSettingChangeListener(SCALE_PREFERENCE_PROPERTY, new ScalingSettingChangeListener(n));
        wtWindowManager.registerSettingChangeListener("ui.display_size", new DisplaySizeChangeListener());
        this.setInitialWindowStates();
        this.frame.setVisible(true);
        this.frameDefaultSize = this.frame.getSize();
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SwingClientGUI.this.requestQuit(stendhalClient);
            }
        });
        this.setupKeyHandling(stendhalClient);
        this.locationHacksAndBugWorkaround();
        WindowUtils.restoreSize(this.frame);
    }

    private void setupInternalWindowProperties() {
        WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        wtWindowManager.setDefaultProperties("corpse", false, 0, 190);
        wtWindowManager.setDefaultProperties("chest", false, 100, 190);
    }

    private void setupChatEntry() {
        ChatCompletionHelper chatCompletionHelper = new ChatCompletionHelper(this.chatText, World.get().getPlayerList().getNamesList(), SlashActionRepository.getCommandNames());
        this.chatText.addKeyListener(chatCompletionHelper);
        this.chatFocusRedirector = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SwingClientGUI.this.chatText.getPlayerChatText().requestFocus();
            }
        };
        WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        this.updateChatFocusRedirector(wtWindowManager.getProperty("move.keys", "arrows"));
        wtWindowManager.registerSettingChangeListener("move.keys", new SettingChangeListener(){

            @Override
            public void changed(String string) {
                SwingClientGUI.this.updateChatFocusRedirector(string);
            }
        });
    }

    private void updateChatFocusRedirector(String string) {
        boolean bl;
        boolean bl2 = bl = !"wasd".equalsIgnoreCase(string);
        if (bl) {
            if (!this.chatFocusRedirectInstalled) {
                this.screen.addFocusListener(this.chatFocusRedirector);
                this.chatFocusRedirectInstalled = true;
                this.chatText.getPlayerChatText().requestFocus();
            }
        } else if (this.chatFocusRedirectInstalled) {
            this.screen.removeFocusListener(this.chatFocusRedirector);
            this.chatFocusRedirectInstalled = false;
            this.screen.requestFocusInWindow();
        }
    }

    private void setupKeyHandling(StendhalClient stendhalClient) {
        this.gameKeyHandler = new GameKeyHandler(stendhalClient, this.screen);
        this.chatText.addKeyListener(this.gameKeyHandler);
        this.screen.addKeyListener(this.gameKeyHandler);
    }

    private JComponent createChatLog(NotificationChannelManager notificationChannelManager) {
        JComponent jComponent = new ChatLogArea(notificationChannelManager).getComponent();
        jComponent.setPreferredSize(new Dimension(this.screen.getWidth(), 171));
        InputMap inputMap = jComponent.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("control PAGE_UP"), "navigatePrevious");
        inputMap.put(KeyStroke.getKeyStroke("control PAGE_DOWN"), "navigateNext");
        return jComponent;
    }

    private ContainerPanel createContainerPanel() {
        ContainerPanel containerPanel = new ContainerPanel();
        containerPanel.setAnimated(false);
        containerPanel.setMinimumSize(new Dimension(0, 0));
        this.character = new Character();
        containerPanel.addRepaintable(this.character);
        this.inventory = new Bag();
        this.inventory.setAcceptedTypes(EntityMap.getClass("item", null, null));
        containerPanel.addRepaintable(this.inventory);
        this.userContext.addFeatureChangeListener(this.inventory);
        this.keyring = new KeyRing();
        this.keyring.setAcceptedTypes(EntityMap.getClass("item", null, null));
        containerPanel.addRepaintable(this.keyring);
        this.userContext.addFeatureChangeListener(this.keyring);
        this.magicbag = new MagicBag();
        this.magicbag.setAcceptedTypes(EntityMap.getClass("item", null, null));
        containerPanel.addRepaintable(this.magicbag);
        this.userContext.addFeatureChangeListener(this.magicbag);
        this.spells = new Spells();
        this.spells.setAcceptedTypes(EntityMap.getClass("spell", null, null));
        containerPanel.addRepaintable(this.spells);
        this.userContext.addFeatureChangeListener(this.spells);
        for (FeatureChangeListener featureChangeListener : this.character.getFeatureChangeListeners()) {
            this.userContext.addFeatureChangeListener(featureChangeListener);
        }
        for (ComponentListener componentListener : this.character.getComponentListeners()) {
            containerPanel.addComponentListener(componentListener);
        }
        return containerPanel;
    }

    private JComponent createLeftPanel(StendhalClient stendhalClient) {
        this.minimap = new MapPanelController(stendhalClient);
        StatsPanelController statsPanelController = StatsPanelController.get();
        BuddyPanelController buddyPanelController = BuddyPanelController.get();
        ScrolledViewport scrolledViewport = new ScrolledViewport((JComponent)buddyPanelController.getComponent());
        scrolledViewport.setScrollingSpeed(8);
        JComponent jComponent = scrolledViewport.getComponent();
        jComponent.setBorder(null);
        JComponent jComponent2 = SBoxLayout.createContainer(false);
        jComponent2.add((Component)this.minimap.getComponent(), (Object)SLayout.EXPAND_X);
        jComponent2.add((Component)statsPanelController.getComponent(), (Object)SLayout.EXPAND_X);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(null);
        jPanel.setLayout(new SBoxLayout(false));
        JTabbedPane jTabbedPane = new JTabbedPane(3);
        TabbedPaneUI tabbedPaneUI = jTabbedPane.getUI();
        if (tabbedPaneUI instanceof StyledTabbedPaneUI) {
            ((StyledTabbedPaneUI)tabbedPaneUI).setTabLabelMargins(1);
        }
        jTabbedPane.setFocusable(false);
        jTabbedPane.add("Przyjaciele", jComponent);
        jTabbedPane.add("Grupa", GroupPanelController.get().getComponent());
        jPanel.add((Component)jTabbedPane, SBoxLayout.constraint(SLayout.EXPAND_X, SLayout.EXPAND_Y));
        jComponent2.add((Component)jPanel, SBoxLayout.constraint(SLayout.EXPAND_X, SLayout.EXPAND_Y));
        return jComponent2;
    }

    private JFrame prepareMainWindow(JFrame jFrame) {
        JFrame jFrame2 = MainFrame.prepare(jFrame);
        DragLayer dragLayer = DragLayer.get();
        jFrame2.setGlassPane(dragLayer);
        dragLayer.setVisible(true);
        this.setupWindowWideListeners(jFrame2);
        WindowUtils.watchFontSize(jFrame2);
        return jFrame2;
    }

    private void setupChatText() {
        Dimension dimension = stendhal.getDisplaySize();
        this.chatText.getPlayerChatText().setMaximumSize(new Dimension(dimension.width, Integer.MAX_VALUE));
        GameLoop.get().runAtQuit(this.chatText::saveCache);
    }

    @Override
    public void requestQuit(StendhalClient stendhalClient) {
        if (stendhalClient.getConnectionState() || !this.offline) {
            this.quitDialog.requestQuit(this.user);
        } else {
            System.exit(0);
        }
    }

    @Override
    public void getVisibleRunicAltar() {
        this.runicAltar.getVisibleRunicAltar();
    }

    @Override
    public void setOffline(boolean bl) {
        this.screenController.setOffline(bl);
        this.offline = bl;
    }

    @Override
    public void triggerPainting() {
        if (this.frame.getState() != 1) {
            ++this.paintCounter;
            if (this.frame.isActive() || "false".equals(System.getProperty("stendhal.skip.inactive", "false")) || this.paintCounter >= 20) {
                this.paintCounter = 0;
                logger.debug((Object)"Draw screen");
                this.minimap.refresh();
                this.containerPanel.repaintChildren();
                this.screen.repaint();
            }
        }
    }

    private void locationHacksAndBugWorkaround() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Point point = SwingClientGUI.this.frame.getLocation();
                SwingClientGUI.this.frame.setLocation(point.x + 1, point.y);
                SwingClientGUI.this.frame.setLocation(point.x, point.y);
                SwingClientGUI.this.frame.setEnabled(true);
                SwingClientGUI.this.chatText.getPlayerChatText().requestFocus();
            }
        });
    }

    private void smallScreenHacks() {
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Dimension dimension = this.frame.getSize();
        this.frame.setSize(Math.min(dimension.width, rectangle.width), Math.min(dimension.height, rectangle.height));
        this.verticalSplit.setDividerLocation(Math.min(stendhal.getDisplaySize().height, rectangle.height - 80));
    }

    private void setInitialWindowStates() {
        this.quitDialog.getQuitDialog().setVisible(false);
        this.character.setVisible(true);
        this.inventory.setVisible(true);
        this.keyring.setVisible(false);
        this.magicbag.setVisible(false);
        this.runicAltar.getRunicAltar().setVisible(false);
        this.spells.setVisible(false);
    }

    private void setupWindowWideListeners(JFrame jFrame) {
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                SwingClientGUI.this.chatText.getPlayerChatText().requestFocus();
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                SwingClientGUI.this.chatText.getPlayerChatText().requestFocus();
            }

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                SwingClientGUI.this.chatText.getPlayerChatText().requestFocus();
            }
        });
        jFrame.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                if (StendhalClient.serverVersionAtLeast("0.02")) {
                    RPAction rPAction = new RPAction();
                    rPAction.put("type", "conditional_stop");
                    ClientSingletonRepository.getClientFramework().send(rPAction);
                    SwingClientGUI.this.gameKeyHandler.flushDirectionKeys();
                }
            }
        });
    }

    private void setupOverallLayout() {
        Dimension dimension = stendhal.getDisplaySize();
        JComponent jComponent = SBoxLayout.createContainer(true);
        this.frame.setContentPane(jComponent);
        this.chatText.getPlayerChatText().setMaximumSize(new Dimension(dimension.width, Integer.MAX_VALUE));
        JComponent jComponent2 = SBoxLayout.createContainer(true);
        jComponent2.add((Component)this.chatText.getPlayerChatText(), (Object)SLayout.EXPAND_X);
        jComponent2.add(new CharacterMap());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(null);
        jPanel.setLayout(new SBoxLayout(false));
        jPanel.add((Component)jComponent2, (Object)SLayout.EXPAND_X);
        jPanel.add((Component)this.chatLogArea, SBoxLayout.constraint(SLayout.EXPAND_X, SLayout.EXPAND_Y));
        this.verticalSplit = new JSplitPane(0, this.pane, jPanel);
        this.verticalSplit.setBorder(null);
        this.containerPanel.setMinimumSize(this.containerPanel.getPreferredSize());
        this.leftColumn.setMinimumSize(new Dimension());
        JSplitPane jSplitPane = new JSplitPane(1, this.leftColumn, this.verticalSplit);
        jSplitPane.addComponentListener(new HorizontalSplitListener(jSplitPane));
        this.horizontalSplit = jSplitPane;
        int n = this.verticalSplit.getDividerSize();
        this.pane.setPreferredSize(new Dimension(dimension.width + n, dimension.height));
        this.horizontalSplit.setBorder(null);
        jComponent.add((Component)this.horizontalSplit, SBoxLayout.constraint(SLayout.EXPAND_Y, SLayout.EXPAND_X));
        JComponent jComponent3 = SBoxLayout.createContainer(false);
        SettingsPanel settingsPanel = new SettingsPanel();
        jComponent3.add((Component)settingsPanel, (Object)SLayout.EXPAND_X);
        jComponent3.add((Component)this.containerPanel, SBoxLayout.constraint(SLayout.EXPAND_Y, SLayout.EXPAND_X));
        jComponent.add((Component)jComponent3, (Object)SLayout.EXPAND_Y);
        this.frame.pack();
        this.horizontalSplit.setDividerLocation(this.leftColumn.getPreferredSize().width);
        this.smallScreenHacks();
    }

    private void setupZoneChangeListeners(StendhalClient stendhalClient) {
        stendhalClient.addZoneChangeListener(this.screen);
        stendhalClient.addZoneChangeListener(this.minimap);
        stendhalClient.addZoneChangeListener(new WeatherSoundManager());
        stendhalClient.addZoneChangeListener(new StendhalClient.ZoneChangeListener(){

            @Override
            public void onZoneUpdate(Zone zone) {
            }

            @Override
            public void onZoneChangeCompleted(Zone zone) {
                SwingClientGUI.this.containerPanel.setAnimated(true);
            }

            @Override
            public void onZoneChange(Zone zone) {
                SwingClientGUI.this.containerPanel.setAnimated(false);
            }
        });
    }

    @Override
    public void updateUser(User user) {
        this.user = user;
        this.character.setPlayer(user);
        this.keyring.setSlot(user, "keyring");
        this.magicbag.setSlot(user, "magicbag");
        this.spells.setSlot(user, "spells");
        this.inventory.setSlot(user, "bag");
        this.runicAltar.setPlayer(user);
    }

    @Override
    public JFrame getFrame() {
        return this.frame;
    }

    @Override
    public void resetClientDimensions() {
        int n = this.frame.getExtendedState();
        if (n != 6) {
            this.frame.setSize(this.frameDefaultSize);
        }
    }

    @Override
    public Collection<PositionChangeListener> getPositionChangeListeners() {
        return Arrays.asList(this.screenController, this.minimap);
    }

    @Override
    public void setChatLine(String string) {
        this.chatText.setChatLine(string);
    }

    @Override
    public void afterPainting() {
        this.gameKeyHandler.processDelayedDirectionRelease();
    }

    @Override
    public void beforePainting() {
        this.screen.nextFrame();
    }

    @Override
    public void addDialog(Component component) {
        this.pane.add(component, JLayeredPane.PALETTE_LAYER);
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public void addAchievementBox(String string, String string2, String string3) {
        this.screen.addAchievementBox(string, string2, string3);
    }

    @Override
    @Deprecated
    public void addGameScreenText(double d, double d2, String string, NotificationType notificationType, boolean bl) {
        this.screenController.addText(d, d2, string, notificationType, bl);
    }

    @Override
    @Deprecated
    public void addGameScreenText(Entity entity, String string, NotificationType notificationType, boolean bl) {
        this.screenController.addText(entity, string, notificationType, bl);
    }

    @Override
    public void switchToSpellState(RPObject rPObject) {
        this.screen.switchToSpellCastingState(rPObject);
    }

    @Override
    public void chooseOutfit() {
        RPObject rPObject = this.userContext.getPlayer();
        if (!rPObject.has("outfit_ext")) {
            int n = rPObject.has("outfit_org") ? rPObject.getInt("outfit_org") : rPObject.getInt("outfit");
            int n2 = n % 100;
            int n3 = n / 100 % 100;
            int n4 = (int)((double)n / Math.pow(100.0, 2.0) % 100.0);
            int n5 = (int)((double)n / Math.pow(100.0, 3.0) % 100.0);
            int n6 = (int)((double)n / Math.pow(100.0, 4.0) % 100.0);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("body=" + n2);
            stringBuilder.append(",dress=" + n3);
            stringBuilder.append(",head=" + n4);
            stringBuilder.append(",hair=" + n5);
            stringBuilder.append(",detail=" + n6);
            if (this.outfitDialog == null) {
                this.outfitDialog = new OutfitDialog((Frame)this.frame, "PolanieOnLine - Zmie\u0144 wygl\u0105d postaci", stringBuilder.toString(), new OutfitColor(rPObject));
                this.outfitDialog.setVisible(true);
            } else {
                this.outfitDialog.setState(stringBuilder.toString(), OutfitColor.get(rPObject));
                this.outfitDialog.setVisible(true);
                this.outfitDialog.toFront();
            }
        } else {
            String string = rPObject.has("outfit_ext_orig") ? rPObject.get("outfit_ext_orig") : rPObject.get("outfit_ext");
            if (this.outfitDialog == null) {
                this.outfitDialog = new OutfitDialog((Frame)this.frame, "PolanieOnLine - Zmie\u0144 wygl\u0105d postaci", string, new OutfitColor(rPObject));
                this.outfitDialog.setVisible(true);
            } else {
                this.outfitDialog.setState(string, OutfitColor.get(rPObject));
                this.outfitDialog.setVisible(true);
                this.outfitDialog.toFront();
            }
        }
    }

    private static class GameScreenResizer
    extends ComponentAdapter {
        private final Component child;

        GameScreenResizer(Component component) {
            this.child = component;
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.child.setSize(componentEvent.getComponent().getSize());
        }
    }

    private class DisplaySizeChangeListener
    implements SettingChangeListener {
        DisplaySizeChangeListener() {
            String string = WtWindowManager.getInstance().getProperty("ui.display_size", Integer.toString(stendhal.getDisplaySizeIndex()));
            this.changed(string);
        }

        @Override
        public void changed(String string) {
            int n = Math.max(0, stendhal.getAvailableDisplaySizes().size() - 1);
            int n2 = MathHelper.parseIntDefault(string, stendhal.getDisplaySizeIndex());
            int n3 = MathHelper.clamp(n2, 0, n);
            if (n3 != n2) {
                WtWindowManager.getInstance().setProperty("ui.display_size", Integer.toString(n3));
            }
            stendhal.setDisplaySizeIndex(n3);
            this.applyDisplaySize(stendhal.getDisplaySize());
        }

        private void applyDisplaySize(final Dimension dimension) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int n = SwingClientGUI.this.verticalSplit.getDividerSize();
                    SwingClientGUI.this.pane.setPreferredSize(new Dimension(dimension.width + n, dimension.height));
                    SwingClientGUI.this.pane.setSize(SwingClientGUI.this.pane.getPreferredSize());
                    SwingClientGUI.this.screen.setSize(dimension);
                    SwingClientGUI.this.screen.setPreferredSize(dimension);
                    SwingClientGUI.this.screen.revalidate();
                    SwingClientGUI.this.pane.revalidate();
                    if (SwingClientGUI.this.screen.isScaled()) {
                        SwingClientGUI.this.verticalSplit.setMaximumSize(null);
                        SwingClientGUI.this.pane.setMaximumSize(null);
                    } else {
                        SwingClientGUI.this.verticalSplit.setMaximumSize(new Dimension(dimension.width + n, Integer.MAX_VALUE));
                        SwingClientGUI.this.pane.setMaximumSize(dimension);
                        int n2 = SwingClientGUI.this.horizontalSplit.getWidth() - SwingClientGUI.this.horizontalSplit.getDividerLocation() - dimension.width - n;
                        if (n2 > 0) {
                            SwingClientGUI.this.horizontalSplit.setDividerLocation(SwingClientGUI.this.horizontalSplit.getDividerLocation() + n2);
                        }
                        if (SwingClientGUI.this.verticalSplit.getDividerLocation() > dimension.height) {
                            SwingClientGUI.this.verticalSplit.setDividerLocation(dimension.height);
                        }
                    }
                    SwingClientGUI.this.chatText.getPlayerChatText().setMaximumSize(new Dimension(dimension.width, Integer.MAX_VALUE));
                    SwingClientGUI.this.frame.pack();
                    SwingClientGUI.this.horizontalSplit.setDividerLocation(((SwingClientGUI)SwingClientGUI.this).leftColumn.getPreferredSize().width);
                }
            });
        }
    }

    private class ScalingSettingChangeListener
    implements SettingChangeListener {
        private final int divWidth;

        ScalingSettingChangeListener(int n) {
            this.divWidth = n;
            this.changed(WtWindowManager.getInstance().getProperty(SwingClientGUI.SCALE_PREFERENCE_PROPERTY, "true"));
        }

        @Override
        public final void changed(String string) {
            boolean bl = Boolean.parseBoolean(string);
            SwingClientGUI.this.screen.setUseScaling(bl);
            if (bl) {
                SwingClientGUI.this.verticalSplit.setMaximumSize(null);
                SwingClientGUI.this.pane.setMaximumSize(null);
            } else {
                Dimension dimension = stendhal.getDisplaySize();
                SwingClientGUI.this.verticalSplit.setMaximumSize(new Dimension(dimension.width + this.divWidth, Integer.MAX_VALUE));
                SwingClientGUI.this.pane.setMaximumSize(dimension);
                int n = SwingClientGUI.this.horizontalSplit.getWidth() - SwingClientGUI.this.horizontalSplit.getDividerLocation() - dimension.width - this.divWidth;
                if (n > 0) {
                    SwingClientGUI.this.horizontalSplit.setDividerLocation(SwingClientGUI.this.horizontalSplit.getDividerLocation() + n);
                }
                if (SwingClientGUI.this.verticalSplit.getDividerLocation() > dimension.height) {
                    SwingClientGUI.this.verticalSplit.setDividerLocation(dimension.height);
                }
            }
        }
    }

    private final class HorizontalSplitListener
    extends ComponentAdapter {
        private final JSplitPane split;
        private int oldWidth = Integer.MAX_VALUE;

        HorizontalSplitListener(JSplitPane jSplitPane) {
            this.split = jSplitPane;
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            final Dimension dimension = stendhal.getDisplaySize();
            if (SwingClientGUI.this.screen.isScaled()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        double d = (double)SwingClientGUI.this.screen.getWidth() / (double)dimension.width;
                        int n = (int)(d * (double)dimension.height);
                        SwingClientGUI.this.verticalSplit.setDividerLocation(n);
                    }
                });
            } else {
                int n = this.split.getDividerLocation();
                int n2 = this.split.getWidth();
                int n3 = this.oldWidth - n;
                int n4 = n2 - this.oldWidth;
                int n5 = n4 + n;
                if (n5 < 0) {
                    n3 = this.oldWidth - this.split.getLastDividerLocation();
                }
                n = MathHelper.clamp(n2 - n3, this.split.getMinimumDividerLocation(), this.split.getMaximumDividerLocation());
                this.split.setDividerLocation(n);
                this.oldWidth = this.split.getWidth();
            }
        }
    }
}

