/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.gui.ManagedWindow;
import games.stendhal.client.gui.wt.core.SettingChangeAdapter;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.common.MathHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public class WindowUtils {
    private static final String WINDOW_CLOSE = "eu.polanieonline:window_closing";
    private static final String FONT_SIZE_PROPERTY = "ui.font_size";
    private static final int DEFAULT_FONT_SIZE = 12;
    private static final String SAVE_DIMENSIONS_PROPERTY = "ui.dimensions";
    private static final String PROP_PREFIX = "ui.window.";
    private static final Map<Window, ManagedWindowDecorator> trackedWindows = new HashMap<Window, ManagedWindowDecorator>();

    private WindowUtils() {
    }

    public static void closeOnEscape(JDialog jDialog) {
        WindowUtils.closeOnEscape(jDialog, jDialog.getRootPane());
    }

    static void closeOnEscape(JFrame jFrame) {
        WindowUtils.closeOnEscape(jFrame, jFrame.getRootPane());
    }

    public static void trackLocation(Window window, String string, final boolean bl) {
        final ManagedWindowDecorator managedWindowDecorator = new ManagedWindowDecorator(window, string);
        final WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        wtWindowManager.setDefaultProperties(managedWindowDecorator.getName(), false, managedWindowDecorator.getX(), managedWindowDecorator.getY());
        wtWindowManager.formatWindow(managedWindowDecorator);
        if (bl) {
            trackedWindows.put(window, managedWindowDecorator);
        }
        window.addComponentListener(new ComponentAdapter(){
            final String widthProperty;
            final String heightProperty;
            {
                this.widthProperty = WindowUtils.PROP_PREFIX + managedWindowDecorator.getName() + ".width";
                this.heightProperty = WindowUtils.PROP_PREFIX + managedWindowDecorator.getName() + ".height";
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                WtWindowManager.getInstance().moveTo(managedWindowDecorator, managedWindowDecorator.getX(), managedWindowDecorator.getY());
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (!bl || !managedWindowDecorator.getRestored()) {
                    return;
                }
                WtWindowManager wtWindowManager = WtWindowManager.getInstance();
                if (!managedWindowDecorator.isMaximized()) {
                    wtWindowManager.setProperty(this.widthProperty, Integer.toString(managedWindowDecorator.getWidth()));
                    wtWindowManager.setProperty(this.heightProperty, Integer.toString(managedWindowDecorator.getHeight()));
                }
            }
        });
        window.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent windowEvent) {
                wtWindowManager.setProperty(WindowUtils.PROP_PREFIX + managedWindowDecorator.getName() + ".maximized", Boolean.toString(managedWindowDecorator.isMaximized()));
            }
        });
    }

    public static void restoreSize(Window window) {
        ManagedWindowDecorator managedWindowDecorator = trackedWindows.get(window);
        if (managedWindowDecorator == null) {
            throw new IllegalArgumentException("Trying to restore a window that is not being tracked");
        }
        managedWindowDecorator.setRestored(true);
        WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        if (!"true".equals(wtWindowManager.getProperty(SAVE_DIMENSIONS_PROPERTY, "true"))) {
            return;
        }
        String string = PROP_PREFIX + managedWindowDecorator.getName() + ".maximized";
        if ("true".equals(wtWindowManager.getProperty(string, "false"))) {
            if (window instanceof Frame) {
                ((Frame)window).setExtendedState(6);
                return;
            }
            wtWindowManager.setProperty(string, "false");
        }
        int n = wtWindowManager.getPropertyInt(PROP_PREFIX + managedWindowDecorator.getName() + ".width", -1);
        int n2 = wtWindowManager.getPropertyInt(PROP_PREFIX + managedWindowDecorator.getName() + ".height", -1);
        if (n != -1 && n2 != -1) {
            window.setSize(n, n2);
        }
    }

    private static void closeOnEscape(final Window window, JRootPane jRootPane) {
        InputMap inputMap = jRootPane.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), WINDOW_CLOSE);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                window.dispatchEvent(new WindowEvent(window, 201));
            }
        };
        jRootPane.getActionMap().put(WINDOW_CLOSE, abstractAction);
    }

    public static void watchFontSize(final Component component) {
        final SettingChangeAdapter settingChangeAdapter = new SettingChangeAdapter(FONT_SIZE_PROPERTY, Integer.toString(12)){

            @Override
            public void changed(String string) {
                int n = MathHelper.parseIntDefault(string, 12);
                WindowUtils.scaleComponentFonts(component, n);
                component.validate();
                component.setSize(component.getPreferredSize());
            }
        };
        WtWindowManager.getInstance().registerSettingChangeListener(FONT_SIZE_PROPERTY, settingChangeAdapter);
        if (component instanceof Window) {
            ((Window)component).addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    WtWindowManager.getInstance().deregisterSettingChangeListener(WindowUtils.FONT_SIZE_PROPERTY, settingChangeAdapter);
                }
            });
        }
    }

    private static void scaleComponentFonts(Component component, float f) {
        Font font = component.getFont().deriveFont(f);
        component.setFont(font);
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                WindowUtils.scaleComponentFonts(component2, f);
            }
        }
    }

    private static class ManagedWindowDecorator
    implements ManagedWindow {
        private final Window window;
        private final String name;
        private boolean restored;

        ManagedWindowDecorator(Window window, String string) {
            this.window = window;
            this.name = "system." + string;
        }

        boolean isMaximized() {
            if (this.window instanceof Frame) {
                return ((Frame)this.window).getExtendedState() == 6;
            }
            return false;
        }

        boolean getRestored() {
            return this.restored;
        }

        void setRestored(boolean bl) {
            this.restored = bl;
        }

        int getWidth() {
            return this.window.getWidth();
        }

        int getHeight() {
            return this.window.getHeight();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getX() {
            return this.window.getX();
        }

        @Override
        public int getY() {
            return this.window.getY();
        }

        @Override
        public boolean isMinimized() {
            return false;
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        public boolean moveTo(int n, int n2) {
            this.window.setLocation(n, n2);
            return true;
        }

        @Override
        public void setMinimized(boolean bl) {
        }

        @Override
        public void setVisible(boolean bl) {
        }
    }
}

