/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.achievementlog;

import games.stendhal.client.sprite.Sprite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class AchievementLogRenderers {
    private static AchievementLogRenderers instance;
    private static final int PAD = 5;

    public static synchronized AchievementLogRenderers get() {
        if (instance == null) {
            instance = new AchievementLogRenderers();
        }
        return instance;
    }

    public class SpriteCellRenderer
    extends JComponent
    implements TableCellRenderer {
        private Sprite sprite;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2 = jTable.getValueAt(n, n2);
            this.sprite = object2 instanceof Sprite ? (Sprite)object2 : null;
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension();
            if (this.sprite != null) {
                dimension.width = this.sprite.getWidth() + 10;
                dimension.height = this.sprite.getHeight() + 10;
            }
            return dimension;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.sprite != null) {
                this.sprite.draw(graphics, (this.getWidth() - this.sprite.getWidth()) / 2, (this.getHeight() - this.sprite.getHeight()) / 2);
            }
        }
    }

    public class DescriptionCellRenderer
    extends DefaultTableCellRenderer {
        private final Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setBorder(this.border);
            return this;
        }
    }

    public static class HeaderRenderer
    extends JPanel
    implements TableCellRenderer {
        private final JLabel header = new JLabel();

        public HeaderRenderer() {
            this.add(this.header);
            this.header.setBorder(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.header.setText(object.toString());
            return this;
        }
    }
}

