/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.buddies;

import games.stendhal.client.gui.buddies.Buddy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractListModel;
import org.apache.log4j.Logger;

class BuddyListModel
extends AbstractListModel<Buddy> {
    private static final long serialVersionUID = -2770930669293485239L;
    private final List<Buddy> buddyList = new ArrayList<Buddy>();
    private final List<Buddy> visibleBuddies = new ArrayList<Buddy>();
    private final Map<String, Buddy> buddyMap = new HashMap<String, Buddy>();
    private String filterText = "";

    BuddyListModel() {
        this.rebuildVisibleList();
    }

    @Override
    public Buddy getElementAt(int n) {
        return this.visibleBuddies.get(n);
    }

    @Override
    public int getSize() {
        return this.visibleBuddies.size();
    }

    void setFilter(String string) {
        String string2 = this.normalizeFilter(string);
        if (!this.filterText.equals(string2)) {
            this.filterText = string2;
            this.rebuildVisibleList();
        }
    }

    void setOnline(String string, boolean bl) {
        if (string == null) {
            Logger.getLogger(BuddyListModel.class).error((Object)("Buddy with no name set " + (bl ? "online" : "offline")));
            return;
        }
        Buddy buddy = this.buddyMap.get(string);
        boolean bl2 = false;
        if (buddy == null) {
            buddy = new Buddy(string);
            buddy.setOnline(bl);
            this.buddyList.add(buddy);
            this.buddyMap.put(string, buddy);
            bl2 = true;
        } else {
            bl2 = buddy.setOnline(bl);
        }
        if (bl2) {
            Collections.sort(this.buddyList);
            this.rebuildVisibleList();
        }
    }

    void removeBuddy(String string) {
        Buddy buddy = this.buddyMap.remove(string);
        if (buddy != null) {
            this.buddyList.remove(buddy);
            this.rebuildVisibleList();
        }
    }

    private void rebuildVisibleList() {
        ArrayList<Buddy> arrayList = new ArrayList<Buddy>(this.visibleBuddies);
        int n = arrayList.size();
        this.visibleBuddies.clear();
        for (Buddy buddy : this.buddyList) {
            if (!this.matchesFilter(buddy)) continue;
            this.visibleBuddies.add(buddy);
        }
        int n2 = this.visibleBuddies.size();
        if (n2 > n) {
            int n3 = this.findFirstDifference(arrayList, this.visibleBuddies);
            int n4 = n3 + (n2 - n) - 1;
            this.fireIntervalAdded(this, n3, n4);
        } else if (n2 < n) {
            int n5 = this.findFirstDifference(arrayList, this.visibleBuddies);
            int n6 = n5 + (n - n2) - 1;
            this.fireIntervalRemoved(this, n5, n6);
        } else if (!arrayList.equals(this.visibleBuddies) && n2 > 0) {
            int n7 = this.findFirstDifference(arrayList, this.visibleBuddies);
            int n8 = this.findLastDifference(arrayList, this.visibleBuddies);
            this.fireContentsChanged(this, n7, n8);
        }
    }

    private int findFirstDifference(List<Buddy> list, List<Buddy> list2) {
        int n = Math.min(list.size(), list2.size());
        for (int i = 0; i < n; ++i) {
            if (list.get(i) == list2.get(i)) continue;
            return i;
        }
        return n;
    }

    private int findLastDifference(List<Buddy> list, List<Buddy> list2) {
        int n = list.size() - 1;
        int n2 = list2.size() - 1;
        for (int i = Math.min(n, n2); i >= 0; --i) {
            if (list.get(i) == list2.get(i)) continue;
            return i;
        }
        return Math.min(n, n2);
    }

    private boolean matchesFilter(Buddy buddy) {
        if (this.filterText.isEmpty()) {
            return true;
        }
        return buddy.getName().toLowerCase(Locale.ROOT).contains(this.filterText);
    }

    private String normalizeFilter(String string) {
        if (string == null) {
            return "";
        }
        return string.trim().toLowerCase(Locale.ROOT);
    }
}

