/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.buddies;

import games.stendhal.client.gui.buddies.BuddyListModel;
import games.stendhal.client.gui.buddies.BuddyPanel;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import games.stendhal.client.gui.styled.StyledButtonUI;
import games.stendhal.client.sprite.DataLoader;
import games.stendhal.client.stendhal;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class BuddyPanelController
implements PropertyChangeListener {
    private static final Icon SEARCH_ICON = BuddyPanelController.loadSearchIcon();
    private static final BuddyPanelController instance = new BuddyPanelController();
    private final JComponent buddyPanel = new JPanel();
    private final BuddyListModel model;

    private BuddyPanelController() {
        this.buddyPanel.setLayout(new SBoxLayout(false, 5));
        this.model = new BuddyListModel();
        final JComponent jComponent = SBoxLayout.createContainer(true, 5);
        final JToggleButton jToggleButton = new JToggleButton(SEARCH_ICON);
        BuddyPanelController.configureFilterToggle(jToggleButton);
        jComponent.add(jToggleButton);
        final JTextField jTextField = new JTextField();
        jTextField.setColumns(12);
        jTextField.setVisible(false);
        jTextField.setToolTipText("Filtruj list\u0119 znajomych wed\u0142ug nazwy");
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                BuddyPanelController.this.model.setFilter(jTextField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                BuddyPanelController.this.model.setFilter(jTextField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                BuddyPanelController.this.model.setFilter(jTextField.getText());
            }
        });
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!jTextField.getText().isEmpty()) {
                    jTextField.setText("");
                }
                jTextField.setVisible(false);
                jComponent.revalidate();
                jComponent.repaint();
            }
        };
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                jTextField.setVisible(true);
                jComponent.revalidate();
                jComponent.repaint();
                jTextField.requestFocusInWindow();
            }
        };
        jTextField.getInputMap(0).put(KeyStroke.getKeyStroke("ESCAPE"), "buddyFilterHide");
        jTextField.getActionMap().put("buddyFilterHide", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jToggleButton.isSelected()) {
                    jToggleButton.setSelected(false);
                    runnable.run();
                }
            }
        });
        jToggleButton.addActionListener(actionEvent -> {
            if (jToggleButton.isSelected()) {
                runnable2.run();
            } else {
                runnable.run();
            }
        });
        jComponent.add((Component)jTextField, (Object)SLayout.EXPAND_X);
        this.buddyPanel.add((Component)jComponent, (Object)SLayout.EXPAND_X);
        BuddyPanel buddyPanel = new BuddyPanel(this.model);
        this.buddyPanel.add((Component)buddyPanel, (Object)SLayout.EXPAND_X);
    }

    private static void configureFilterToggle(JToggleButton jToggleButton) {
        jToggleButton.setMargin(new Insets(2, 2, 2, 2));
        jToggleButton.setText(null);
        jToggleButton.setFocusable(false);
        jToggleButton.setFocusPainted(false);
        jToggleButton.setIconTextGap(0);
        int n = Math.max(SEARCH_ICON.getIconWidth(), 16);
        int n2 = Math.max(SEARCH_ICON.getIconHeight(), 16);
        Dimension dimension = new Dimension(n + 8, n2 + 8);
        jToggleButton.setPreferredSize(dimension);
        jToggleButton.setMinimumSize(dimension);
        jToggleButton.setMaximumSize(dimension);
        jToggleButton.setToolTipText("Wyszukaj znajomego");
        Style style = StyleUtil.getStyle();
        if (style != null) {
            jToggleButton.setUI(new StyledButtonUI(style));
            jToggleButton.setOpaque(false);
            jToggleButton.setRolloverEnabled(true);
        }
    }

    private static Icon loadSearchIcon() {
        File[] fileArray;
        ImageIcon imageIcon = BuddyPanelController.createIcon(DataLoader.getResource("data/gui/loupe.png"));
        if (imageIcon != null) {
            return imageIcon;
        }
        String string = stendhal.getGameFolder();
        File file = string != null ? new File(string, "data/gui/loupe.png") : null;
        for (File file2 : fileArray = new File[]{new File("data/gui/loupe.png"), file, BuddyPanelController.resolveInstallIcon()}) {
            if (file2 == null || (imageIcon = BuddyPanelController.createIcon(file2)) == null) continue;
            return imageIcon;
        }
        return new SearchIcon();
    }

    private static ImageIcon createIcon(URL uRL) {
        if (uRL == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(uRL);
        return imageIcon.getIconWidth() > 0 ? imageIcon : null;
    }

    private static ImageIcon createIcon(File file) {
        if (!file.isFile()) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(file.getAbsolutePath());
        return imageIcon.getIconWidth() > 0 ? imageIcon : null;
    }

    private static File resolveInstallIcon() {
        try {
            File file;
            URL uRL = BuddyPanelController.class.getProtectionDomain().getCodeSource().getLocation();
            if (uRL == null) {
                return null;
            }
            File file2 = new File(uRL.toURI());
            File file3 = file = file2.isFile() ? file2.getParentFile() : file2;
            if (file == null) {
                return null;
            }
            return new File(file, "data/gui/loupe.png");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Component getComponent() {
        return this.buddyPanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        if (propertyChangeEvent == null) {
            return;
        }
        Map map = (Map)propertyChangeEvent.getOldValue();
        if (map != null) {
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                final Map.Entry entry = (Map.Entry)object.next();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BuddyPanelController.this.model.removeBuddy((String)entry.getKey());
                    }
                });
            }
        }
        if ((object = (Map)propertyChangeEvent.getNewValue()) != null) {
            for (final Map.Entry entry : object.entrySet()) {
                final boolean bl = Boolean.parseBoolean((String)entry.getValue());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BuddyPanelController.this.model.setOnline((String)entry.getKey(), bl);
                    }
                });
            }
        }
    }

    public static BuddyPanelController get() {
        return instance;
    }

    private static final class SearchIcon
    implements Icon {
        private static final int SIZE = 18;

        private SearchIcon() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                Color color;
                Color color2;
                Color color3;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Style style = StyleUtil.getStyle();
                if (style != null) {
                    color3 = style.getHighLightColor();
                    color2 = style.getShadowColor();
                    Color color4 = style.getPlainColor();
                    color = color4 != null ? color4.brighter() : style.getHighLightColor();
                } else {
                    color3 = new Color(240, 240, 240);
                    color2 = new Color(40, 40, 40);
                    color = new Color(160, 160, 160);
                }
                int n3 = 10;
                int n4 = n + 3;
                int n5 = n2 + 3;
                graphics2D.setColor(color);
                graphics2D.fillOval(n4, n5, n3, n3);
                graphics2D.setStroke(new BasicStroke(1.5f, 1, 1));
                graphics2D.setColor(color2);
                graphics2D.drawOval(n4, n5, n3, n3);
                graphics2D.setColor(color3);
                graphics2D.drawOval(n4 - 1, n5 - 1, n3 + 2, n3 + 2);
                int n6 = n4 + n3 - 1;
                int n7 = n5 + n3 - 1;
                int n8 = n + 18 - 4;
                int n9 = n2 + 18 - 4;
                graphics2D.setColor(color2);
                graphics2D.drawLine(n6, n7, n8, n9);
                graphics2D.setColor(color3);
                graphics2D.drawLine(n6 - 1, n7 - 1, n8 - 1, n9 - 1);
            }
            finally {
                graphics2D.dispose();
            }
        }

        @Override
        public int getIconWidth() {
            return 18;
        }

        @Override
        public int getIconHeight() {
            return 18;
        }
    }
}

