/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.group;

import games.stendhal.client.actions.SlashActionRepository;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Player;
import games.stendhal.client.entity.User;
import games.stendhal.client.gui.MousePopupAdapter;
import games.stendhal.client.gui.chatlog.HeaderLessEventLine;
import games.stendhal.client.gui.group.Member;
import games.stendhal.client.gui.group.MemberCellRenderer;
import games.stendhal.client.gui.group.MemberHealthListener;
import games.stendhal.client.gui.group.MemberListModel;
import games.stendhal.client.gui.group.MemberPopupMenu;
import games.stendhal.client.gui.j2DClient;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.sprite.DataLoader;
import games.stendhal.common.NotificationType;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;

class GroupPanel {
    private static final Logger logger = Logger.getLogger(GroupPanel.class);
    private static final int POPUP_OFFSET = 5;
    private static final int LIST_INDENT = 5;
    private static final String START_GROUP_TOOLTIP = "Zak\u0142ada now\u0105 grup\u0119";
    private static final String INVITE_TOOLTIP = "Zaprasza nowych cz\u0142onk\u00f3w";
    private static final ImageIcon MESSAGE_ICON = new ImageIcon(DataLoader.getResource("data/gui/chat.png"));
    private static final ImageIcon INVITE_ICON = new ImageIcon(DataLoader.getResource("data/gui/buddy_online.png"));
    private static final ImageIcon LEAVE_ICON = new ImageIcon(DataLoader.getResource("data/gui/buddy_offline.png"));
    private final JComponent pane;
    private final JLabel header;
    private final JLabel memberLabel;
    private final MemberListModel memberList;
    private final JList<Member> memberListComponent;
    private final JButton leaveGroupButton;
    private final JButton messageButton;
    private final JButton inviteButton;
    private final Map<String, JComponent> invites = new HashMap<String, JComponent>();
    private final JComponent inviteContainer;
    private boolean initialized = false;

    GroupPanel() {
        this.pane = SBoxLayout.createContainer(false, 5);
        this.header = new JLabel();
        this.header.addMouseListener(new HeaderMouseListener());
        this.pane.add(this.header);
        this.pane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                if (!GroupPanel.this.initialized) {
                    String[] stringArray = new String[]{"status"};
                    SlashActionRepository.get("group").execute(stringArray, "");
                    GroupPanel.this.initialized = true;
                }
                GroupPanel.this.pane.removeComponentListener(this);
            }
        });
        this.memberLabel = new JLabel("Cz\u0142onkowie:");
        this.pane.add(this.memberLabel);
        this.memberLabel.setVisible(false);
        this.memberList = new MemberListModel();
        this.memberListComponent = new JList<Member>(this.memberList);
        this.memberListComponent.setFocusable(false);
        this.memberListComponent.setCellRenderer(new MemberCellRenderer());
        this.memberListComponent.setOpaque(false);
        this.memberListComponent.addMouseListener(new MemberListMouseListener());
        this.memberListComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                for (Member member : GroupPanel.this.memberList) {
                    member.setMaxHPRepresentation(GroupPanel.this.memberListComponent.getWidth() - 4);
                }
            }
        });
        this.memberListComponent.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.pane.add(this.memberListComponent, (Object)SLayout.EXPAND_X);
        this.inviteContainer = SBoxLayout.createContainer(false, 5);
        this.inviteContainer.setAlignmentX(0.5f);
        this.pane.add(this.inviteContainer);
        SBoxLayout.addSpring(this.pane);
        JComponent jComponent = SBoxLayout.createContainer(true);
        jComponent.setAlignmentX(1.0f);
        this.pane.add(jComponent);
        SBoxLayout.addSpring(jComponent);
        this.messageButton = new JButton(MESSAGE_ICON);
        this.messageButton.setEnabled(false);
        this.messageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                j2DClient.get().setChatLine("/p ");
            }
        });
        this.messageButton.setFocusable(false);
        this.messageButton.setToolTipText("Wysy\u0142a wiadomo\u015b\u0107 do wszystkich cz\u0142onk\u00f3w grupy");
        jComponent.add(this.messageButton);
        this.inviteButton = new JButton(INVITE_ICON);
        this.inviteButton.setFocusable(false);
        this.inviteButton.setToolTipText(START_GROUP_TOOLTIP);
        this.inviteButton.addActionListener(new InviteActionListener());
        jComponent.add(this.inviteButton);
        this.leaveGroupButton = new JButton(LEAVE_ICON);
        this.leaveGroupButton.setEnabled(false);
        this.leaveGroupButton.addActionListener(new LeaveActionListener());
        this.leaveGroupButton.setFocusable(false);
        this.leaveGroupButton.setToolTipText("Rezygnacja z grupy");
        jComponent.add(this.leaveGroupButton);
        Insets insets = this.messageButton.getMargin();
        Insets insets2 = new Insets(insets.top, 1, insets.bottom, 1);
        this.messageButton.setMargin(insets2);
        this.inviteButton.setMargin(insets2);
        this.leaveGroupButton.setMargin(insets2);
    }

    JComponent getComponent() {
        return this.pane;
    }

    void showHeader(String string) {
        this.header.setText(string);
    }

    void setMembers(List<String> list) {
        this.memberList.setMembers(list);
        boolean bl = list != null;
        this.memberLabel.setVisible(bl);
        this.leaveGroupButton.setEnabled(bl);
        this.messageButton.setEnabled(bl);
        this.inviteButton.setEnabled(!bl);
        if (!bl) {
            this.inviteButton.setToolTipText(START_GROUP_TOOLTIP);
        }
        if (!bl) {
            for (JComponent jComponent : this.invites.values()) {
                jComponent.setEnabled(true);
            }
        }
    }

    void setLeader(String string) {
        this.memberList.setLeader(string);
        if (string.equals(User.getCharacterName())) {
            this.inviteButton.setEnabled(true);
            this.inviteButton.setToolTipText(INVITE_TOOLTIP);
        }
        this.expireInvite(string);
        for (JComponent jComponent : this.invites.values()) {
            jComponent.setEnabled(false);
        }
        this.initialized = true;
    }

    void receiveInvite(final String string) {
        Container container = this.pane.getParent();
        if (container instanceof JTabbedPane) {
            ((JTabbedPane)container).setSelectedComponent(this.pane);
        }
        if (this.invites.containsKey(string)) {
            return;
        }
        JButton jButton = new JButton("Do\u0142\u0105cz do " + string);
        jButton.setToolTipText("Do\u0142\u0105cza do grupy przewodzonej przez " + string);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = new String[]{"join"};
                SlashActionRepository.get("group").execute(stringArray, string);
            }
        });
        this.invites.put(string, jButton);
        jButton.setAlignmentX(0.5f);
        this.inviteContainer.add((Component)jButton, (Object)SLayout.EXPAND_X);
        this.inviteContainer.revalidate();
    }

    void expireInvite(String string) {
        JComponent jComponent = this.invites.get(string);
        if (jComponent != null) {
            this.inviteContainer.remove(jComponent);
            this.inviteContainer.revalidate();
        }
        this.invites.remove(string);
    }

    boolean addPlayer(Player player) {
        Member member = this.memberList.getMember(player.getName());
        if (member != null) {
            member.setHpRatio(player.getHpRatio());
            member.setPresent(true);
            player.addChangeListener(new MemberHealthListener(member));
            this.memberList.memberChanged(member);
            return true;
        }
        return false;
    }

    void addPlayers(List<Player> list) {
        for (Player player : list) {
            if (this.addPlayer(player)) continue;
            logger.error((Object)("Added player is not a member even though she should be. Player: " + player.getName()), new Throwable());
        }
    }

    void removePlayer(IEntity iEntity) {
        Member member = this.memberList.getMember(iEntity.getName());
        if (member != null) {
            member.setPresent(false);
            this.memberList.memberChanged(member);
        }
    }

    private class MemberListMouseListener
    extends MousePopupAdapter {
        private MemberListMouseListener() {
        }

        @Override
        protected void showPopup(MouseEvent mouseEvent) {
            int n = GroupPanel.this.memberListComponent.locationToIndex(mouseEvent.getPoint());
            Member member = (Member)GroupPanel.this.memberListComponent.getModel().getElementAt(n);
            Member member2 = GroupPanel.this.memberList.getMember(User.getCharacterName());
            boolean bl = member2.isLeader() && member != member2;
            MemberPopupMenu memberPopupMenu = new MemberPopupMenu(member.getName(), bl);
            memberPopupMenu.show(GroupPanel.this.memberListComponent, mouseEvent.getX() - 5, mouseEvent.getY() - 5);
        }
    }

    private class HeaderMouseListener
    extends MousePopupAdapter {
        private HeaderMouseListener() {
        }

        @Override
        protected void showPopup(MouseEvent mouseEvent) {
            Member member = GroupPanel.this.memberList.getMember(User.getCharacterName());
            if (!member.isLeader()) {
                return;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("wsp\u00f3lne");
            jMenuItem.addActionListener(new LootmodeActionListener("shared"));
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("samodzielne");
            jMenuItem.addActionListener(new LootmodeActionListener("single"));
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("standardowe");
            jMenuItem.addActionListener(new ExpmodeActionListener("standard"));
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("najni\u017cszy poziom");
            jMenuItem.addActionListener(new ExpmodeActionListener("lowest"));
            jPopupMenu.add(jMenuItem);
            jPopupMenu.show(GroupPanel.this.header, mouseEvent.getX() - 5, mouseEvent.getY() - 5);
        }
    }

    private static class ExpmodeActionListener
    implements ActionListener {
        private final String mode;

        ExpmodeActionListener(String string) {
            this.mode = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = new String[]{"expmode"};
            SlashActionRepository.get("group").execute(stringArray, this.mode);
        }
    }

    private static class LootmodeActionListener
    implements ActionListener {
        private final String mode;

        LootmodeActionListener(String string) {
            this.mode = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = new String[]{"lootmode"};
            SlashActionRepository.get("group").execute(stringArray, this.mode);
        }
    }

    private static class InviteActionListener
    implements ActionListener {
        private InviteActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            j2DClient.get().setChatLine("/group invite ");
            j2DClient.get().addEventLine(new HeaderLessEventLine("Wprowad\u017a imi\u0119 wojownika, kt\u00f3rego chcesz zaprosi\u0107", NotificationType.CLIENT));
        }
    }

    private static class LeaveActionListener
    implements ActionListener {
        private LeaveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = new String[]{"part"};
            SlashActionRepository.get("group").execute(stringArray, "");
        }
    }
}

