/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.group;

import games.stendhal.client.gui.group.Member;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.gui.stats.HPIndicator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

class MemberCellRenderer
implements ListCellRenderer<Member> {
    private final JComponent renderer = SBoxLayout.createContainer(false);
    private final JLabel label = new JLabel();
    private final HPBar hpBar;
    private final Font boldFont;
    private final Font normalFont;

    MemberCellRenderer() {
        this.label.setOpaque(false);
        this.renderer.add(this.label);
        Font font = this.label.getFont();
        if ((font.getStyle() & 1) != 0) {
            this.boldFont = font;
            this.normalFont = font.deriveFont(font.getStyle() ^ 1);
        } else {
            this.normalFont = font;
            this.boldFont = font.deriveFont(font.getStyle() | 1);
        }
        this.hpBar = new HPBar();
        this.renderer.add((Component)this.hpBar, (Object)SLayout.EXPAND_X);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Member> jList, Member member, int n, boolean bl, boolean bl2) {
        this.label.setText(member.getName());
        if (member.isLeader()) {
            this.label.setFont(this.boldFont);
        } else {
            this.label.setFont(this.normalFont);
        }
        Insets insets = this.hpBar.getInsets();
        int n2 = jList.getWidth() - insets.left - insets.right - 2;
        insets = jList.getInsets();
        this.hpBar.getModel().setMaxRepresentation(n2 -= insets.left + insets.right);
        if (member.isPresent()) {
            this.hpBar.setPresent(true);
            this.hpBar.setRatio(member.getHpRatio());
        } else {
            this.hpBar.setPresent(false);
        }
        return this.renderer;
    }

    private static class HPBar
    extends HPIndicator {
        private HPBar() {
        }

        void setPresent(boolean bl) {
            if (!bl) {
                this.setBarColor(Color.LIGHT_GRAY);
                this.getModel().setValue(1.0);
            }
        }
    }
}

