/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.imageviewer;

import games.stendhal.client.gui.imageviewer.ViewPanel;
import java.awt.Dimension;
import java.awt.Image;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import org.apache.log4j.Logger;

class ImageViewPanel
extends ViewPanel {
    private static final Logger logger = Logger.getLogger(ImageViewPanel.class);
    private static final String FONT_COLOR = "#FFFFFF";
    private static final String FONT_SIZE = "5";
    private Image image;
    private final URL url;
    private final String caption;

    ImageViewPanel(URL uRL, String string) {
        this.url = uRL;
        this.caption = string;
    }

    @Override
    public void prepareView(Dimension dimension) {
        this.initImage();
        this.initComponents(dimension);
    }

    private void initImage() {
        try {
            this.image = ImageIO.read(this.url);
        }
        catch (Exception exception) {
            logger.error((Object)("Failed to read image from '" + this.url + "'"), (Throwable)exception);
        }
    }

    private void initComponents(Dimension dimension) {
        Dimension dimension2 = dimension;
        int n = this.image.getWidth(null);
        int n2 = this.image.getHeight(null);
        if (this.image.getWidth(null) > dimension2.width) {
            n = dimension2.width - 2;
        }
        if (this.image.getHeight(null) > dimension2.height) {
            n2 = dimension2.height - 2;
        }
        String string = "";
        if (this.caption != null) {
            string = "<b><i><font color=\"#FFFFFF\" size=\"5\">" + this.caption + "</big></i></b><br>";
        }
        String string2 = "<img width=" + n + " height=" + n2 + " src=" + this.url.toString() + ">";
        String string3 = "<html>" + string + string2;
        JLabel jLabel = new JLabel(string3);
        this.add(jLabel);
        this.setVisible(true);
    }
}

