/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d;

import games.stendhal.client.MemoryCache;
import games.stendhal.common.color.ARGB;
import games.stendhal.common.color.HSL;
import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class Blend
implements Composite {
    private static final MemoryCache<Object, CompositeContext> cache = new MemoryCache();
    public static final Blend TrueColor = new Blend(Mode.TRUE_COLOR, null);
    public static final Blend GenericLight = new Blend(Mode.GENERIC_LIGHT, null);
    public static final Blend Multiply = new Blend(Mode.MULTIPLY, null);
    public static final Blend Screen = new Blend(Mode.SCREEN, null);
    public static final Blend SoftLight = new Blend(Mode.SOFT_LIGHT, null);
    private final Mode mode;
    private final Color color;
    private String name;

    private Blend(Mode mode, Color color) {
        this.mode = mode;
        this.color = color;
    }

    @Override
    public CompositeContext createContext(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
        switch (this.mode) {
            case MULTIPLY: {
                return new MultiplyContext();
            }
            case SOFT_LIGHT: {
                CompositeContext compositeContext = cache.get((Object)Mode.SOFT_LIGHT);
                if (compositeContext == null) {
                    compositeContext = new BlendContext(this.mode, this.color);
                    cache.put((Object)Mode.SOFT_LIGHT, compositeContext);
                }
                return compositeContext;
            }
        }
        return new BlendContext(this.mode, this.color);
    }

    public static Blend createBleach(Color color) {
        return new Blend(Mode.BLEACH, color);
    }

    public String toString() {
        if (this.name == null) {
            String string = "";
            if (this.color != null) {
                string = "(" + Integer.toHexString(this.color.getRGB()) + ")";
            }
            this.name = (Object)((Object)this.mode) + string;
        }
        return this.name;
    }

    private static class MultiplyContext
    implements CompositeContext {
        private MultiplyContext() {
        }

        @Override
        public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int n = Math.min(raster.getWidth(), raster2.getWidth());
            int n2 = Math.min(raster.getHeight(), raster2.getHeight());
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            for (int i = 0; i < n2; ++i) {
                raster.getDataElements(0, i, n, 1, nArray);
                raster2.getDataElements(0, i, n, 1, nArray2);
                for (int j = 0; j < n; ++j) {
                    int n3 = nArray2[j];
                    int n4 = nArray[j];
                    if ((n4 & 0xFF000000) == 0) continue;
                    int n5 = n3 & 0xFF000000;
                    n5 |= (n3 & 0xFF) * (n4 & 0xFF) >> 8;
                    n5 |= (n3 & 0xFF00) * (n4 & 0xFF00) >> 16 & 0xFF00;
                    nArray2[j] = n5 |= ((n3 & 0xFF0000) >> 16) * (n4 & 0xFF0000) >> 8 & 0xFF0000;
                }
                writableRaster.setDataElements(0, i, n, 1, nArray2);
            }
        }

        @Override
        public void dispose() {
        }
    }

    private static class TrueColorComposer
    implements Composer {
        private final float[] srcHsl = new float[3];
        private final float[] dstHsl = new float[3];
        private final int[] result = new int[4];

        private TrueColorComposer() {
        }

        @Override
        public int compose(int[] nArray, int[] nArray2) {
            float f;
            HSL.rgb2hsl(nArray, this.srcHsl);
            HSL.rgb2hsl(nArray2, this.dstHsl);
            float f2 = this.srcHsl[2] - 0.5f;
            float f3 = this.dstHsl[2] - 0.5f;
            this.srcHsl[2] = f = this.dstHsl[2] - 2.0f * f2 * (f3 * f3 - 0.25f);
            HSL.hsl2rgb(this.srcHsl, this.result);
            this.result[0] = nArray2[0];
            return ARGB.mergeRgb(this.result);
        }
    }

    private static class ScreenComposer
    extends SimpleComposer {
        private ScreenComposer() {
        }

        @Override
        int composeComponent(int n, int n2) {
            return 255 - ((255 - n) * (255 - n2) >> 8);
        }
    }

    private static class SoftLightComposer
    implements Composer {
        private final byte[] table = new byte[65536];

        public SoftLightComposer() {
            for (int i = 0; i < 256; ++i) {
                for (int j = 0; j < 256; ++j) {
                    this.table[i * 256 + j] = (byte)((j + 2 * i * (255 - j) / 255) * j / 255);
                }
            }
        }

        @Override
        public int compose(int[] nArray, int[] nArray2) {
            int n = 0xFF000000 & nArray2[0] << 24;
            for (int i = 1; i <= 3; ++i) {
                n |= (this.table[256 * nArray[i] + nArray2[i]] & 0xFF) << 8 * (3 - i);
            }
            return n;
        }
    }

    private static abstract class SimpleComposer
    implements Composer {
        private SimpleComposer() {
        }

        @Override
        public int compose(int[] nArray, int[] nArray2) {
            for (int i = 1; i <= 3; ++i) {
                nArray2[i] = this.composeComponent(nArray[i], nArray2[i]);
            }
            return ARGB.mergeRgb(nArray2);
        }

        abstract int composeComponent(int var1, int var2);
    }

    private static class GenericLightComposer
    implements Composer {
        private static final int DIMMING_FACTOR = 512;

        private GenericLightComposer() {
        }

        @Override
        public int compose(int[] nArray, int[] nArray2) {
            int n;
            int n2 = 0;
            for (n = 1; n <= 3; ++n) {
                n2 += nArray[n];
            }
            n = n2 / 3;
            for (int i = 1; i <= 3; ++i) {
                nArray2[i] = this.composeComponent(n, nArray2[i]);
            }
            return ARGB.mergeRgb(nArray2);
        }

        private int composeComponent(int n, int n2) {
            return Math.min(n2 + n2 * n / 512, 255);
        }
    }

    private static class BleachComposer
    implements Composer {
        final float red;
        final float green;
        final float blue;

        BleachComposer(Color color) {
            int n = color.getRGB();
            int[] nArray = new int[4];
            ARGB.splitRgb(n, nArray);
            this.red = Math.max(1, nArray[1]);
            this.green = Math.max(1, nArray[2]);
            this.blue = Math.max(1, nArray[3]);
        }

        @Override
        public int compose(int[] nArray, int[] nArray2) {
            float f = (float)nArray[1] / this.red;
            float f2 = (float)nArray[2] / this.green;
            float f3 = (float)nArray[3] / this.blue;
            float f4 = this.limitMin(Math.max(f, Math.max(f2, f3)));
            float f5 = this.limitMin(f / f4);
            float f6 = this.limitMin(f2 / f4);
            float f7 = this.limitMin(f3 / f4);
            nArray2[1] = this.bleachComponent(f4, nArray2[1], this.red, f5);
            nArray2[2] = this.bleachComponent(f4, nArray2[2], this.green, f6);
            nArray2[3] = this.bleachComponent(f4, nArray2[3], this.blue, f7);
            return ARGB.mergeRgb(nArray2);
        }

        private float limitMin(float f) {
            return Math.max(0.001f, f);
        }

        private int bleachComponent(float f, int n, float f2, float f3) {
            float f4 = f * f2 / 255.0f + 1.0f - f;
            float f5 = (float)n / f4 - (float)n;
            return (int)((float)n + f5 * f3);
        }
    }

    private static interface Composer {
        public int compose(int[] var1, int[] var2);
    }

    private static class BlendContext
    implements CompositeContext {
        final Composer composer;

        BlendContext(Mode mode, Color color) {
            switch (mode) {
                case BLEACH: {
                    this.composer = new BleachComposer(color);
                    break;
                }
                case GENERIC_LIGHT: {
                    this.composer = new GenericLightComposer();
                    break;
                }
                case SOFT_LIGHT: {
                    this.composer = new SoftLightComposer();
                    break;
                }
                case SCREEN: {
                    this.composer = new ScreenComposer();
                    break;
                }
                case TRUE_COLOR: {
                    this.composer = new TrueColorComposer();
                    break;
                }
                default: {
                    this.composer = null;
                }
            }
        }

        @Override
        public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int n = Math.min(raster.getWidth(), raster2.getWidth());
            int n2 = Math.min(raster.getHeight(), raster2.getHeight());
            int[] nArray = new int[4];
            int[] nArray2 = new int[4];
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            for (int i = 0; i < n2; ++i) {
                raster.getDataElements(0, i, n, 1, nArray3);
                raster2.getDataElements(0, i, n, 1, nArray4);
                for (int j = 0; j < n; ++j) {
                    ARGB.splitRgb(nArray4[j], nArray2);
                    if (nArray2[0] == 0) continue;
                    ARGB.splitRgb(nArray3[j], nArray);
                    if (nArray[0] == 0) continue;
                    nArray4[j] = this.composer.compose(nArray, nArray2);
                }
                writableRaster.setDataElements(0, i, n, 1, nArray4);
            }
        }

        @Override
        public void dispose() {
        }
    }

    private static enum Mode {
        BLEACH,
        GENERIC_LIGHT,
        MULTIPLY,
        SCREEN,
        SOFT_LIGHT,
        TRUE_COLOR;

    }
}

