/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.ZoneInfo;
import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.Chest;
import games.stendhal.client.entity.Inspector;
import games.stendhal.client.gui.InternalWindow;
import games.stendhal.client.gui.SlotWindow;
import games.stendhal.client.gui.j2d.entity.StateEntity2DView;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import marauroa.common.game.RPObject;

class Chest2DView
extends StateEntity2DView<Chest> {
    private static final String DEFAULT_CHEST_SPRITE = "chest";
    private static final String CHEST_SPRITE_DIRECTORY = "chests/";
    private static final String BANK_SLOT_ATTRIBUTE = "bank_slot";
    private static final Map<String, String> ZONE_SPRITES;
    private static final Map<String, String> BANK_SLOT_SPRITES;
    private static final String STATE_CLOSED = "close";
    private static final String STATE_OPEN = "open";
    private volatile boolean openChanged = false;
    private Inspector inspector;
    private boolean requestOpen = false;
    private SlotWindow slotWindow;

    private static String chestSprite(String string) {
        return CHEST_SPRITE_DIRECTORY + string;
    }

    @Override
    protected void buildSprites(Chest chest, Map<Object, Sprite> map) {
        SpriteStore spriteStore = SpriteStore.get();
        ZoneInfo zoneInfo = ZoneInfo.get();
        Sprite sprite = spriteStore.getModifiedSprite(this.translate(this.resolveSpriteName(chest)), zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
        map.put(STATE_CLOSED, spriteStore.getTile(sprite, 0, 0, 32, 32));
        map.put(STATE_OPEN, spriteStore.getTile(sprite, 0, 32, 32, 32));
    }

    private String resolveSpriteName(Chest chest) {
        String string;
        Object object;
        String string2;
        if (chest == null) {
            return DEFAULT_CHEST_SPRITE;
        }
        RPObject rPObject = chest.getRPObject();
        if (rPObject != null && rPObject.has(BANK_SLOT_ATTRIBUTE) && (string2 = BANK_SLOT_SPRITES.get(object = rPObject.get(BANK_SLOT_ATTRIBUTE).toString())) != null) {
            return string2;
        }
        object = chest.getID();
        String string3 = string2 = object != null ? object.getZoneID() : null;
        if (string2 != null && (string = ZONE_SPRITES.get(string2)) != null) {
            return string;
        }
        string = chest.getType();
        return string != null ? string : DEFAULT_CHEST_SPRITE;
    }

    @Override
    protected Object getState(Chest chest) {
        if (chest.isOpen()) {
            return STATE_OPEN;
        }
        return STATE_CLOSED;
    }

    @Override
    protected void buildActions(List<String> list) {
        super.buildActions(list);
        Chest chest = (Chest)this.entity;
        if (chest != null && chest.isOpen()) {
            list.add(ActionType.INSPECT.getRepresentation());
            list.add(ActionType.CLOSE.getRepresentation());
        } else {
            list.add(ActionType.OPEN.getRepresentation());
        }
    }

    @Override
    public int getZIndex() {
        return 5000;
    }

    @Override
    public void setInspector(Inspector inspector) {
        this.inspector = inspector;
    }

    @Override
    protected void update() {
        super.update();
        if (this.openChanged) {
            this.openChanged = false;
            if (((Chest)this.entity).isOpen()) {
                if (this.requestOpen) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Chest2DView.this.showWindow();
                        }
                    });
                }
            } else if (this.slotWindow != null) {
                this.slotWindow.close();
            }
            this.requestOpen = false;
        }
    }

    @Override
    public void entityChanged(Object object) {
        super.entityChanged(object);
        if (object == Chest.PROP_OPEN) {
            this.proceedChangedState((Chest)this.entity);
            this.openChanged = true;
        }
    }

    @Override
    public void onAction(ActionType actionType) {
        if (this.isReleased()) {
            return;
        }
        switch (actionType) {
            case INSPECT: {
                this.showWindow();
                break;
            }
            case OPEN: {
                if (!((Chest)this.entity).isOpen()) {
                    this.requestOpen = true;
                }
                actionType.send(actionType.fillTargetInfo(this.entity));
                break;
            }
            case CLOSE: {
                actionType.send(actionType.fillTargetInfo(this.entity));
                break;
            }
            default: {
                super.onAction(actionType);
            }
        }
    }

    @Override
    public void onAction() {
        if (((Chest)this.entity).isOpen()) {
            this.onAction(ActionType.INSPECT);
        } else {
            this.onAction(ActionType.OPEN);
        }
    }

    @Override
    public void release() {
        final SlotWindow slotWindow = this.slotWindow;
        if (slotWindow != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    slotWindow.close();
                }
            });
        }
        super.release();
    }

    @Override
    public StendhalCursor getCursor() {
        return StendhalCursor.BAG;
    }

    private void showWindow() {
        boolean bl = this.slotWindow == null;
        this.slotWindow = this.inspector.inspectMe(this.entity, ((Chest)this.entity).getContent(), this.slotWindow, 6, 6);
        if (bl && this.slotWindow != null) {
            this.slotWindow.addCloseListener(new InternalWindow.CloseListener(){

                @Override
                public void windowClosed(InternalWindow internalWindow) {
                    Chest2DView.this.slotWindow = null;
                }
            });
        }
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("0_semos_city", Chest2DView.chestSprite("chest_public"));
        hashMap.put("0_zakopane_s", Chest2DView.chestSprite("chest_public_snow"));
        ZONE_SPRITES = Collections.unmodifiableMap(hashMap);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("bank", Chest2DView.chestSprite("chest_semos"));
        hashMap2.put("bank_ados", Chest2DView.chestSprite("chest_ados"));
        hashMap2.put("bank_fado", Chest2DView.chestSprite("chest_fado"));
        hashMap2.put("bank_kirdneh", Chest2DView.chestSprite("chest_kirdneh"));
        hashMap2.put("bank_krakow", Chest2DView.chestSprite("chest_krakow"));
        hashMap2.put("bank_nalwor", Chest2DView.chestSprite("chest_nalwor"));
        BANK_SLOT_SPRITES = Collections.unmodifiableMap(hashMap2);
    }
}

