/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.EntityChangeListener;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.ImageEventProperty;
import games.stendhal.client.entity.Inspector;
import games.stendhal.client.entity.RPEntity;
import games.stendhal.client.entity.User;
import games.stendhal.client.gui.j2DClient;
import games.stendhal.client.gui.j2d.ImageEffect;
import games.stendhal.client.gui.j2d.entity.ActiveEntity2DView;
import games.stendhal.client.gui.j2d.entity.EntityView;
import games.stendhal.client.gui.j2d.entity.helpers.HorizontalAlignment;
import games.stendhal.client.gui.j2d.entity.helpers.VerticalAlignment;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import games.stendhal.client.sprite.AnimatedSprite;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import marauroa.common.game.RPObject;
import org.apache.log4j.Logger;

public abstract class Entity2DView<T extends IEntity>
implements EntityView<T> {
    protected T entity;
    private Composite entityComposite;
    protected volatile boolean animatedChanged;
    private volatile boolean positionChanged;
    protected volatile boolean representationChanged;
    protected volatile boolean visibilityChanged;
    private int x;
    private int xoffset;
    private int y;
    private int yoffset;
    private Sprite sprite;
    private boolean contained;
    private HorizontalAlignment xAlign = HorizontalAlignment.CENTER;
    private VerticalAlignment yAlign = VerticalAlignment.MIDDLE;
    private volatile boolean changed;
    private Collection<AttachedSprite> attachedSprites;
    private volatile boolean released = false;
    private final UpdateListener updateListener = new UpdateListener();
    private final Rectangle area = new Rectangle();
    private boolean activeIdle = false;

    @Override
    public void initialize(T t) {
        RPObject rPObject;
        if (t == null) {
            throw new IllegalArgumentException("entity must not be null");
        }
        if (this.entity != null) {
            this.entity.removeChangeListener(this.updateListener);
        }
        this.entity = t;
        this.x = 0;
        this.y = 0;
        this.xoffset = 0;
        this.yoffset = 0;
        this.entityComposite = AlphaComposite.SrcOver;
        this.contained = false;
        this.animatedChanged = false;
        this.changed = true;
        this.positionChanged = true;
        this.visibilityChanged = true;
        this.representationChanged = true;
        t.addChangeListener(this.updateListener);
        if (t instanceof RPEntity && (rPObject = ((RPEntity)t).getRPObject()).has("active_idle")) {
            this.activeIdle = true;
        }
    }

    @Override
    public void applyChanges() {
        if (this.changed) {
            this.changed = false;
            this.update();
        }
    }

    protected void buildActions(List<String> list) {
        if (this.entity.getRPObject().has("menu")) {
            list.add(this.entity.getRPObject().get("menu"));
        }
        list.add(ActionType.LOOK.getRepresentation());
    }

    protected void buildRepresentation(T t) {
        this.setSprite(SpriteStore.get().getSprite(this.translate(t.getType())));
        this.calculateOffset(t, this.getWidth(), this.getHeight());
    }

    void setSpriteAlignment(HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        this.xAlign = horizontalAlignment;
        this.yAlign = verticalAlignment;
    }

    protected void calculateOffset(T t, int n, int n2) {
        Rectangle2D rectangle2D = t.getArea();
        this.calculateOffset(n, n2, (int)(32.0 * rectangle2D.getWidth()), (int)(32.0 * rectangle2D.getHeight()));
    }

    private void calculateOffset(int n, int n2, int n3, int n4) {
        switch (this.xAlign) {
            case LEFT: {
                this.xoffset = 0;
                break;
            }
            case RIGHT: {
                this.xoffset = n3 - n;
                break;
            }
            default: {
                this.xoffset = (n3 - n) / 2;
            }
        }
        switch (this.yAlign) {
            case TOP: {
                this.yoffset = 0;
                break;
            }
            case BOTTOM: {
                this.yoffset = n4 - n2;
                break;
            }
            default: {
                this.yoffset = (n4 - n2) / 2;
            }
        }
    }

    void markChanged() {
        this.changed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachSprite(Sprite sprite, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, int n, int n2) {
        int n3 = n;
        switch (horizontalAlignment) {
            case LEFT: {
                break;
            }
            case RIGHT: {
                n3 += this.getWidth() - sprite.getWidth();
                break;
            }
            case CENTER: {
                n3 += (this.getWidth() - sprite.getWidth()) / 2;
            }
        }
        int n4 = n2;
        switch (verticalAlignment) {
            case TOP: {
                break;
            }
            case MIDDLE: {
                n4 += (this.getHeight() - sprite.getHeight()) / 2;
                break;
            }
            case BOTTOM: {
                n4 += this.getHeight() - sprite.getHeight();
            }
        }
        Entity2DView entity2DView = this;
        synchronized (entity2DView) {
            if (this.attachedSprites == null) {
                this.attachedSprites = new ConcurrentLinkedQueue<AttachedSprite>();
            }
        }
        this.attachedSprites.add(new AttachedSprite(sprite, n3, n4));
    }

    public void detachSprite(Sprite sprite) {
        Collection<AttachedSprite> collection = this.attachedSprites;
        if (collection != null) {
            Iterator<AttachedSprite> iterator = collection.iterator();
            while (iterator.hasNext()) {
                AttachedSprite attachedSprite = iterator.next();
                if (attachedSprite.sprite != sprite) continue;
                iterator.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics2D graphics2D) {
        this.applyChanges();
        Rectangle rectangle = this.getDrawingArea();
        if (this.isContained()) {
            rectangle.setLocation(0, 0);
        } else if (!this.isOnScreen(graphics2D, rectangle)) {
            return;
        }
        Composite composite = graphics2D.getComposite();
        try {
            graphics2D.setComposite(this.entityComposite);
            this.draw(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        finally {
            graphics2D.setComposite(composite);
        }
    }

    private boolean isOnScreen(Graphics2D graphics2D, Rectangle rectangle) {
        Rectangle rectangle2 = graphics2D.getClipBounds();
        return rectangle2 == null || rectangle.intersects(graphics2D.getClipBounds());
    }

    protected void draw(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        this.drawEntity(graphics2D, n, n2, n3, n4);
        this.drawAttachedSprites(graphics2D, n, n2);
    }

    private void drawAttachedSprites(Graphics2D graphics2D, int n, int n2) {
        Collection<AttachedSprite> collection = this.attachedSprites;
        if (collection != null) {
            for (AttachedSprite attachedSprite : collection) {
                attachedSprite.draw(graphics2D, n, n2);
            }
        }
    }

    protected void drawEntity(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        this.getSprite().draw(graphics2D, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawTop(Graphics2D graphics2D) {
        Rectangle rectangle = this.getArea();
        if (this.isContained()) {
            rectangle.setLocation(0, 0);
        } else if (!this.isOnScreen(graphics2D, rectangle)) {
            return;
        }
        Composite composite = graphics2D.getComposite();
        try {
            graphics2D.setComposite(this.entityComposite);
            this.drawTop(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        finally {
            graphics2D.setComposite(composite);
        }
    }

    protected void drawTop(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
    }

    @Override
    public Rectangle getArea() {
        this.area.setBounds(this.getX() + this.getXOffset(), this.getY() + this.getYOffset(), this.getWidth(), this.getHeight());
        return this.area;
    }

    protected Rectangle getDrawingArea() {
        return this.getArea();
    }

    protected String getClassResourcePath() {
        String string;
        String string2 = this.entity.getEntityClass();
        if (string2 != null && (string = this.entity.getEntitySubclass()) != null) {
            string2 = string2 + "/" + string;
        }
        return string2;
    }

    protected AlphaComposite getComposite() {
        int n = this.getVisibility();
        if (n >= 100) {
            return AlphaComposite.SrcOver;
        }
        if (n <= 0) {
            return AlphaComposite.Dst;
        }
        return AlphaComposite.getInstance(3, (float)n / 100.0f);
    }

    public int getHeight() {
        if (this.sprite != null) {
            return this.sprite.getHeight();
        }
        return 32;
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    protected int getVisibility() {
        return this.entity.getVisibility();
    }

    public int getWidth() {
        if (this.sprite != null) {
            return this.sprite.getWidth();
        }
        return 32;
    }

    protected int getX() {
        return this.x;
    }

    protected int getXOffset() {
        return this.xoffset;
    }

    protected int getY() {
        return this.y;
    }

    protected int getYOffset() {
        return this.yoffset;
    }

    @Override
    public int getZIndex() {
        return 10000;
    }

    protected boolean isAnimating() {
        return true;
    }

    public boolean isContained() {
        return this.contained;
    }

    protected void reorderActions(List<String> list) {
    }

    private void setAnimation(Sprite sprite) {
        if (sprite instanceof AnimatedSprite) {
            AnimatedSprite animatedSprite = (AnimatedSprite)sprite;
            if (this.isAnimating() || this.activeIdle) {
                animatedSprite.start();
            } else {
                animatedSprite.stop();
                if (this instanceof ActiveEntity2DView) {
                    animatedSprite.reset(1);
                } else {
                    animatedSprite.reset(0);
                }
            }
        }
    }

    @Override
    public void setContained(boolean bl) {
        this.contained = bl;
    }

    @Override
    public void setInspector(Inspector inspector) {
    }

    @Override
    public void setVisibleScreenArea(Rectangle rectangle) {
    }

    protected void setSprite(Sprite sprite) {
        this.setAnimation(sprite);
        this.animatedChanged = false;
        this.sprite = sprite;
    }

    protected String translate(String string) {
        return "data/sprites/" + string + ".png";
    }

    protected void update() {
        T t = this.entity;
        if (t == null) {
            return;
        }
        if (this.representationChanged) {
            this.representationChanged = false;
            this.buildRepresentation(t);
        }
        if (this.positionChanged) {
            this.positionChanged = false;
            this.x = (int)(32.0 * t.getX());
            this.y = (int)(32.0 * t.getY());
        }
        if (this.visibilityChanged) {
            this.visibilityChanged = false;
            this.entityComposite = this.getComposite();
        }
        if (this.animatedChanged) {
            this.animatedChanged = false;
            this.setAnimation(this.getSprite());
        }
    }

    void entityChanged(Object object) {
        if (object == IEntity.PROP_ANIMATED) {
            this.animatedChanged = true;
        } else if (object == IEntity.PROP_POSITION) {
            this.positionChanged = true;
        } else if (object == IEntity.PROP_VISIBILITY) {
            this.visibilityChanged = true;
        } else if (object instanceof ImageEventProperty) {
            new ImageEffect(this, ((ImageEventProperty)object).getImageName());
        }
    }

    @Override
    public final String[] getActions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.buildActions(arrayList);
        if (User.isAdmin()) {
            if (this.isEntityType("player")) {
                arrayList.add(ActionType.ADMIN_GAG.getRepresentation());
            }
            arrayList.add(ActionType.ADMIN_INSPECT.getRepresentation());
            if (this.isEntityType("player")) {
                arrayList.add(ActionType.ADMIN_JAIL.getRepresentation());
            }
            if (!this.isEntityType("npc") && !this.isEntityType("player")) {
                arrayList.add(ActionType.ADMIN_DESTROY.getRepresentation());
            }
            if (!this.isContained()) {
                arrayList.add(ActionType.ADMIN_ALTER.getRepresentation());
            }
        }
        this.reorderActions(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean isEntityType(String string) {
        return this.entity.getType().equals(string);
    }

    @Override
    public T getEntity() {
        return this.entity;
    }

    @Override
    public boolean isMovable() {
        return false;
    }

    @Override
    public void onAction() {
        this.onAction(ActionType.LOOK);
    }

    @Override
    public boolean onHarmlessAction() {
        this.onAction();
        return true;
    }

    @Override
    public void onAction(ActionType actionType) {
        T t = this.entity;
        if (this.isReleased()) {
            Logger.getLogger(Entity2DView.class).debug((Object)("View " + this + " already released - action not processed: " + (Object)((Object)actionType)));
            return;
        }
        int n = t.getID().getObjectID();
        String string = t.getType();
        switch (actionType) {
            case LOOK: 
            case ADMIN_INSPECT: 
            case ADMIN_DESTROY: 
            case MARK_ALL: 
            case USE: {
                actionType.send(actionType.fillTargetInfo((IEntity)t));
                break;
            }
            case ADMIN_GAG: {
                j2DClient.get().setChatLine("/gag " + t.getName() + " ");
                break;
            }
            case ADMIN_JAIL: {
                j2DClient.get().setChatLine("/jail " + t.getName() + " ");
                break;
            }
            case ADMIN_ALTER: {
                if (string.equals("player")) {
                    j2DClient.get().setChatLine("/alter " + t.getName() + " ");
                    break;
                }
                if (string.equals("creature")) {
                    j2DClient.get().setChatLine("/altercreature #" + n + " '" + t.getTitle() + "';atk;def;hp;xp");
                    break;
                }
                j2DClient.get().setChatLine("/alter #" + n + " ");
                break;
            }
            default: {
                Logger.getLogger(Entity2DView.class).error((Object)("Unknown action not processed: " + (Object)((Object)actionType)));
            }
        }
    }

    @Override
    public boolean isInteractive() {
        return true;
    }

    @Override
    public void release() {
        this.entity.removeChangeListener(this.updateListener);
        this.released = true;
    }

    protected boolean isReleased() {
        return this.released;
    }

    @Override
    public StendhalCursor getCursor() {
        String string = this.entity.getCursor();
        return StendhalCursor.valueOf(string, StendhalCursor.UNKNOWN);
    }

    private class UpdateListener
    implements EntityChangeListener<T> {
        private UpdateListener() {
        }

        @Override
        public void entityChanged(T t, Object object) {
            Entity2DView.this.entityChanged(object);
            Entity2DView.this.markChanged();
        }
    }

    private static class AttachedSprite {
        final Sprite sprite;
        int xOffset;
        int yOffset;

        AttachedSprite(Sprite sprite, int n, int n2) {
            this.sprite = sprite;
            this.xOffset = n;
            this.yOffset = n2;
        }

        void draw(Graphics2D graphics2D, int n, int n2) {
            this.sprite.draw(graphics2D, n + this.xOffset, n2 + this.yOffset);
        }
    }
}

