/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.Triple;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.gui.j2d.entity.Blood2DView;
import games.stendhal.client.gui.j2d.entity.BossCreature2DView;
import games.stendhal.client.gui.j2d.entity.Box2DView;
import games.stendhal.client.gui.j2d.entity.BreakableRing2DView;
import games.stendhal.client.gui.j2d.entity.CarrotGrower2DView;
import games.stendhal.client.gui.j2d.entity.Chest2DView;
import games.stendhal.client.gui.j2d.entity.Corpse2DView;
import games.stendhal.client.gui.j2d.entity.Creature2DView;
import games.stendhal.client.gui.j2d.entity.Door2DView;
import games.stendhal.client.gui.j2d.entity.Entity2DView;
import games.stendhal.client.gui.j2d.entity.EntityView;
import games.stendhal.client.gui.j2d.entity.FlyOverArea2DView;
import games.stendhal.client.gui.j2d.entity.GameBoard2DView;
import games.stendhal.client.gui.j2d.entity.Gate2DView;
import games.stendhal.client.gui.j2d.entity.Goat2DView;
import games.stendhal.client.gui.j2d.entity.GoatFood2DView;
import games.stendhal.client.gui.j2d.entity.GoldenCauldron2DView;
import games.stendhal.client.gui.j2d.entity.GrainField2DView;
import games.stendhal.client.gui.j2d.entity.HousePortal2DView;
import games.stendhal.client.gui.j2d.entity.InvisibleEntity2DView;
import games.stendhal.client.gui.j2d.entity.Item2DView;
import games.stendhal.client.gui.j2d.entity.LookableEntity2DView;
import games.stendhal.client.gui.j2d.entity.NPC2DView;
import games.stendhal.client.gui.j2d.entity.Pet2DView;
import games.stendhal.client.gui.j2d.entity.PlantGrower2DView;
import games.stendhal.client.gui.j2d.entity.Player2DView;
import games.stendhal.client.gui.j2d.entity.Portal2DView;
import games.stendhal.client.gui.j2d.entity.Ring2DView;
import games.stendhal.client.gui.j2d.entity.Sheep2DView;
import games.stendhal.client.gui.j2d.entity.SheepFood2DView;
import games.stendhal.client.gui.j2d.entity.ShopSign2DView;
import games.stendhal.client.gui.j2d.entity.Sign2DView;
import games.stendhal.client.gui.j2d.entity.Spell2DView;
import games.stendhal.client.gui.j2d.entity.TeleportationRing2DView;
import games.stendhal.client.gui.j2d.entity.TrainingDummy2DView;
import games.stendhal.client.gui.j2d.entity.UseableEntity2DView;
import games.stendhal.client.gui.j2d.entity.UseableGenericItem2DView;
import games.stendhal.client.gui.j2d.entity.UseableItem2DView;
import games.stendhal.client.gui.j2d.entity.UseableRing2DView;
import games.stendhal.client.gui.j2d.entity.User2DView;
import games.stendhal.client.gui.j2d.entity.WalkBlocker2DView;
import games.stendhal.client.gui.j2d.entity.Wall2DView;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EntityViewFactory {
    private static final Logger LOGGER = Logger.getLogger(EntityViewFactory.class);
    private static Map<Triple<String, String, String>, Class<? extends EntityView>> viewMap = new HashMap<Triple<String, String, String>, Class<? extends EntityView>>();

    public static EntityView<IEntity> create(IEntity iEntity) {
        try {
            boolean bl;
            Object object;
            String string;
            String string2;
            if (iEntity.isUser()) {
                User2DView<IEntity> user2DView = new User2DView<IEntity>();
                ((Entity2DView)user2DView).initialize(iEntity);
                return user2DView;
            }
            String string3 = iEntity.getType();
            Class<? extends EntityView> clazz = EntityViewFactory.getViewClass(string3, string2 = iEntity.getEntityClass(), string = iEntity.getName());
            if (clazz == null && (clazz = EntityViewFactory.getViewClass(string3, string2, (String)(object = iEntity.getEntitySubclass()))) == null) {
                LOGGER.debug((Object)("No view for this entity. name: " + string + ", type: " + string3 + ", class: " + string2 + ", subclass: " + (String)object));
                return null;
            }
            if (clazz == Blood2DView.class && !(bl = WtWindowManager.getInstance().getPropertyBoolean("gamescreen.blood", true))) {
                return null;
            }
            object = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            object.initialize(iEntity);
            return object;
        }
        catch (Exception exception) {
            LOGGER.error((Object)("Error creating entity for object: " + iEntity), (Throwable)exception);
            return null;
        }
    }

    static Class<? extends EntityView> getViewClass(String string, String string2, String string3) {
        Class<? extends EntityView> clazz = viewMap.get(new Triple<String, String, String>(string, string2, string3));
        if (clazz == null) {
            clazz = viewMap.get(new Triple<String, String, Object>(string, string2, null));
        }
        if (clazz == null) {
            clazz = viewMap.get(new Triple<String, Object, Object>(string, null, null));
        }
        return clazz;
    }

    public static Map<Triple<String, String, String>, Class<? extends EntityView>> getViewMap() {
        HashMap<Triple<String, String, String>, Class<? extends EntityView>> hashMap = new HashMap<Triple<String, String, String>, Class<? extends EntityView>>();
        hashMap.putAll(viewMap);
        return hashMap;
    }

    private static void configure() {
        EntityViewFactory.register("item", null, null, Item2DView.class);
        EntityViewFactory.register("item", "book", "bestiariusz", UseableGenericItem2DView.class);
        EntityViewFactory.register("item", "book", "spis", UseableGenericItem2DView.class);
        EntityViewFactory.register("item", "box", null, Box2DView.class);
        EntityViewFactory.register("item", "club", "kij przywo\u0142ywania nieumar\u0142ych", UseableItem2DView.class);
        EntityViewFactory.register("item", "drink", null, UseableItem2DView.class);
        EntityViewFactory.register("item", "food", null, UseableItem2DView.class);
        EntityViewFactory.register("item", "furniture", "obraz w drewnianej ramce", UseableItem2DView.class);
        EntityViewFactory.register("item", "misc", "bulwa", UseableItem2DView.class);
        EntityViewFactory.register("item", "misc", "nasiona", UseableItem2DView.class);
        EntityViewFactory.register("item", "misc", "zima zakl\u0119ta w kuli", UseableGenericItem2DView.class);
        EntityViewFactory.register("item", "misc", "pluszowy mi\u015b", UseableGenericItem2DView.class);
        EntityViewFactory.register("item", "ring", null, Ring2DView.class);
        EntityViewFactory.register("item", "ring", "pier\u015bcie\u0144 powrotu", TeleportationRing2DView.class);
        EntityViewFactory.register("item", "ring", "pier\u015bcie\u0144 szmaragdowy", BreakableRing2DView.class);
        EntityViewFactory.register("item", "ring", "obr\u0105czka \u015blubna", UseableRing2DView.class);
        EntityViewFactory.register("item", "scroll", null, UseableItem2DView.class);
        EntityViewFactory.register("item", "special", "brosza z mithrilu", Item2DView.class);
        EntityViewFactory.register("item", "tool", "m\u0142ynek", UseableItem2DView.class);
        EntityViewFactory.register("item", "tool", "wykrywacz metali", UseableGenericItem2DView.class);
        EntityViewFactory.register("item", "tool", "obrotowy no\u017cyk", UseableGenericItem2DView.class);
        EntityViewFactory.register("item", "tool", "zw\u00f3j czyszcz\u0105cy", UseableItem2DView.class);
        EntityViewFactory.register("item", "tool", "m\u0142ynek do cukru", UseableItem2DView.class);
        EntityViewFactory.register("growing_entity_spawner", null, null, GrainField2DView.class);
        EntityViewFactory.register("growing_entity_spawner", "items/grower/carrot_grower", null, CarrotGrower2DView.class);
        EntityViewFactory.register("growing_entity_spawner", "items/grower/wood_grower", null, CarrotGrower2DView.class);
        EntityViewFactory.register("plant_grower", null, null, PlantGrower2DView.class);
        EntityViewFactory.register("blackboard", null, null, Sign2DView.class);
        EntityViewFactory.register("rented_sign", null, null, Sign2DView.class);
        EntityViewFactory.register("shop_sign", null, null, ShopSign2DView.class);
        EntityViewFactory.register("sign", null, null, Sign2DView.class);
        EntityViewFactory.register("door", null, null, Door2DView.class);
        EntityViewFactory.register("gate", null, null, Gate2DView.class);
        EntityViewFactory.register("house_portal", null, null, HousePortal2DView.class);
        EntityViewFactory.register("portal", null, null, Portal2DView.class);
        EntityViewFactory.register("baby_dragon", null, null, Pet2DView.class);
        EntityViewFactory.register("cat", null, null, Pet2DView.class);
        EntityViewFactory.register("goat", null, null, Goat2DView.class);
        EntityViewFactory.register("npc", null, null, NPC2DView.class);
        EntityViewFactory.register("owczarek", null, null, Pet2DView.class);
        EntityViewFactory.register("owczarek_podhalanski", null, null, Pet2DView.class);
        EntityViewFactory.register("pet", null, null, Pet2DView.class);
        EntityViewFactory.register("purple_dragon", null, null, Pet2DView.class);
        EntityViewFactory.register("sheep", null, null, Sheep2DView.class);
        EntityViewFactory.register("training_dummy", null, null, TrainingDummy2DView.class);
        EntityViewFactory.register("creature", null, null, Creature2DView.class);
        EntityViewFactory.register("creature", "ent", "drzewiec", BossCreature2DView.class);
        EntityViewFactory.register("creature", "ent", "drzewcowa", BossCreature2DView.class);
        EntityViewFactory.register("creature", "ent", "usch\u0142y drzewiec", BossCreature2DView.class);
        EntityViewFactory.register("fish_source", null, null, UseableEntity2DView.class);
        EntityViewFactory.register("gold_source", null, null, UseableEntity2DView.class);
        EntityViewFactory.register("well_source", null, null, UseableEntity2DView.class);
        EntityViewFactory.register("wood_source", null, null, UseableEntity2DView.class);
        EntityViewFactory.register("area", null, null, InvisibleEntity2DView.class);
        EntityViewFactory.register("block", null, null, LookableEntity2DView.class);
        EntityViewFactory.register("blood", null, null, Blood2DView.class);
        EntityViewFactory.register("chest", null, null, Chest2DView.class);
        EntityViewFactory.register("corpse", null, null, Corpse2DView.class);
        EntityViewFactory.register("fire", null, null, UseableEntity2DView.class);
        EntityViewFactory.register("flyover", null, null, FlyOverArea2DView.class);
        EntityViewFactory.register("food", null, null, SheepFood2DView.class);
        EntityViewFactory.register("food", null, null, GoatFood2DView.class);
        EntityViewFactory.register("game_board", null, null, GameBoard2DView.class);
        EntityViewFactory.register("player", null, null, Player2DView.class);
        EntityViewFactory.register("spell", null, null, Spell2DView.class);
        EntityViewFactory.register("golden_cauldron", null, null, GoldenCauldron2DView.class);
        EntityViewFactory.register("useable_entity", "golden_cauldron", null, GoldenCauldron2DView.class);
        EntityViewFactory.register("useable_entity", null, null, UseableEntity2DView.class);
        EntityViewFactory.register("walkblocker", null, null, WalkBlocker2DView.class);
        EntityViewFactory.register("wall", null, null, Wall2DView.class);
    }

    private static void register(String string, String string2, String string3, Class<? extends EntityView> clazz) {
        viewMap.put(new Triple<String, String, String>(string, string2, string3), clazz);
    }

    static {
        EntityViewFactory.configure();
    }
}

