/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.StendhalClient;
import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.GoldenCauldron;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Inspector;
import games.stendhal.client.gui.GoldenCauldronWindow;
import games.stendhal.client.gui.InternalWindow;
import games.stendhal.client.gui.j2DClient;
import games.stendhal.client.gui.j2d.entity.Entity2DView;
import games.stendhal.client.gui.j2d.entity.helpers.HorizontalAlignment;
import games.stendhal.client.gui.j2d.entity.helpers.VerticalAlignment;
import games.stendhal.client.sprite.AnimatedSprite;
import games.stendhal.client.sprite.ImageSprite;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.SwingUtilities;
import marauroa.common.game.RPAction;

public class GoldenCauldron2DView
extends Entity2DView<GoldenCauldron> {
    private static final String SPRITE_SHEET = "data/maps/tileset/item/pot/cauldron.png";
    private static final int TILE = 32;
    private static final int FRAME_WIDTH = 64;
    private static final int FRAME_HEIGHT = 64;
    private static final int SHEET_COLUMNS = 8;
    private static final int ACTIVE_FRAME_DELAY = 250;
    private static final int[] IDLE_FRAME_TILES = new int[]{0, 1, 2, 3};
    private static final int[] ACTIVE_TOP_LEFT_SEQUENCE = new int[]{32, 34, 36, 38, 36, 34};
    private static final int[] ACTIVE_TOP_RIGHT_SEQUENCE = new int[]{33, 35, 37, 39, 37, 35};
    private static final int[] ACTIVE_BOTTOM_LEFT_SEQUENCE = new int[]{8, 10, 12, 14, 12, 10};
    private static final int[] ACTIVE_BOTTOM_RIGHT_SEQUENCE = new int[]{9, 11, 13, 15, 13, 11};
    private static final int ACTIVE_STIR_REPEAT = 2;
    private static final int[] ACTIVE_STIR_SEQUENCE = new int[]{5, 7, 6};
    private static final String SLOT_CONTENT = "content";
    private Sprite idleSprite;
    private AnimatedSprite activeAnimation;
    private GoldenCauldronWindow window;
    private Inspector inspector;
    private boolean openChanged;
    private boolean statusChanged;
    private boolean brewerChanged;
    private boolean readyAtChanged;
    private boolean requestOpen;

    @Override
    public void initialize(GoldenCauldron goldenCauldron) {
        this.setSpriteAlignment(HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM);
        super.initialize(goldenCauldron);
        this.representationChanged = true;
        this.openChanged = false;
        this.statusChanged = false;
        this.brewerChanged = false;
        this.readyAtChanged = false;
        this.requestOpen = false;
    }

    @Override
    protected void buildRepresentation(GoldenCauldron goldenCauldron) {
        this.ensureFrames();
        if (goldenCauldron.isActive()) {
            if (this.activeAnimation != null) {
                this.activeAnimation.reset(0);
                this.setSprite(this.activeAnimation);
            } else {
                this.setSprite(this.idleSprite);
            }
        } else {
            this.setSprite(this.idleSprite);
        }
    }

    @Override
    protected void buildActions(List<String> list) {
        GoldenCauldron goldenCauldron = (GoldenCauldron)this.entity;
        if (goldenCauldron != null && goldenCauldron.isOpen()) {
            list.add(ActionType.INSPECT.getRepresentation());
            list.add(ActionType.CLOSE.getRepresentation());
        } else {
            list.add(ActionType.OPEN.getRepresentation());
        }
    }

    @Override
    void entityChanged(Object object) {
        super.entityChanged(object);
        if (object == GoldenCauldron.PROP_STATE || object == IEntity.PROP_CLASS) {
            this.representationChanged = true;
        }
        if (object == GoldenCauldron.PROP_OPEN) {
            this.openChanged = true;
        }
        if (object == GoldenCauldron.PROP_STATUS) {
            this.statusChanged = true;
        }
        if (object == GoldenCauldron.PROP_BREWER) {
            this.brewerChanged = true;
        }
        if (object == GoldenCauldron.PROP_READY_AT) {
            this.readyAtChanged = true;
        }
    }

    @Override
    protected void update() {
        super.update();
        if (this.openChanged) {
            this.openChanged = false;
            if (((GoldenCauldron)this.entity).isOpen()) {
                this.maybeShowWindow();
            } else {
                this.destroyWindow();
            }
            this.requestOpen = false;
        }
        if (this.statusChanged) {
            this.statusChanged = false;
            this.updateStatus();
        }
        if (this.brewerChanged) {
            this.brewerChanged = false;
            this.updateMixAvailability();
        }
        if (this.readyAtChanged) {
            this.readyAtChanged = false;
            this.updateStatus();
            this.updateMixAvailability();
        }
    }

    @Override
    public void onAction(ActionType actionType) {
        if (this.isReleased()) {
            return;
        }
        switch (actionType) {
            case OPEN: {
                this.requestOpen = true;
                actionType.send(actionType.fillTargetInfo(this.entity));
                break;
            }
            case CLOSE: {
                this.requestOpen = false;
                actionType.send(actionType.fillTargetInfo(this.entity));
                break;
            }
            case INSPECT: {
                this.requestOpen = true;
                this.maybeShowWindow();
                break;
            }
            default: {
                super.onAction(actionType);
            }
        }
    }

    @Override
    public void onAction() {
        if (((GoldenCauldron)this.entity).isOpen()) {
            this.onAction(ActionType.INSPECT);
        } else {
            this.onAction(ActionType.OPEN);
        }
    }

    @Override
    public void release() {
        this.destroyWindow();
        super.release();
    }

    @Override
    public void setInspector(Inspector inspector) {
        this.inspector = inspector;
        if (this.window != null) {
            this.window.setInspector(inspector);
        }
    }

    private void maybeShowWindow() {
        if (!((GoldenCauldron)this.entity).isOpen()) {
            return;
        }
        if (this.window == null) {
            if (!this.requestOpen && !((GoldenCauldron)this.entity).isControlledByUser()) {
                return;
            }
            GoldenCauldronWindow goldenCauldronWindow = new GoldenCauldronWindow(((GoldenCauldron)this.entity).getName());
            goldenCauldronWindow.setSlot(this.entity, SLOT_CONTENT);
            goldenCauldronWindow.setInspector(this.inspector);
            goldenCauldronWindow.updateStatus(((GoldenCauldron)this.entity).getStatusText(), ((GoldenCauldron)this.entity).getReadyAt());
            goldenCauldronWindow.setMixEnabled(((GoldenCauldron)this.entity).isControlledByUser() && !((GoldenCauldron)this.entity).isActive());
            goldenCauldronWindow.setMixAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (((GoldenCauldron)GoldenCauldron2DView.this.entity).isControlledByUser()) {
                        GoldenCauldron2DView.this.sendMixAction();
                    }
                }
            });
            goldenCauldronWindow.addCloseListener(new InternalWindow.CloseListener(){

                @Override
                public void windowClosed(InternalWindow internalWindow) {
                    GoldenCauldron2DView.this.window = null;
                    if (((GoldenCauldron)GoldenCauldron2DView.this.entity).isOpen() && ((GoldenCauldron)GoldenCauldron2DView.this.entity).isControlledByUser()) {
                        RPAction rPAction = ActionType.CLOSE.fillTargetInfo(GoldenCauldron2DView.this.entity);
                        ActionType.CLOSE.send(rPAction);
                    }
                }
            });
            j2DClient.get().addWindow(goldenCauldronWindow);
            goldenCauldronWindow.setVisible(true);
            this.window = goldenCauldronWindow;
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GoldenCauldron2DView.this.window.raise();
                }
            });
        }
        this.requestOpen = false;
        this.updateStatus();
        this.updateMixAvailability();
    }

    private void destroyWindow() {
        final GoldenCauldronWindow goldenCauldronWindow = this.window;
        if (goldenCauldronWindow != null) {
            this.window = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    goldenCauldronWindow.close();
                }
            });
        }
    }

    private void updateStatus() {
        if (this.window != null) {
            this.window.updateStatus(((GoldenCauldron)this.entity).getStatusText(), ((GoldenCauldron)this.entity).getReadyAt());
        }
    }

    private void updateMixAvailability() {
        if (this.window != null) {
            boolean bl = ((GoldenCauldron)this.entity).isControlledByUser() && !((GoldenCauldron)this.entity).isActive();
            this.window.setMixEnabled(bl);
        }
    }

    private void sendMixAction() {
        RPAction rPAction = new RPAction();
        rPAction.put("type", "goldencauldron");
        rPAction.put("command", "mix");
        rPAction.put("target_path", ((GoldenCauldron)this.entity).getPath());
        StendhalClient.get().send(rPAction);
    }

    private void ensureFrames() {
        if (this.idleSprite != null && this.activeAnimation != null) {
            return;
        }
        SpriteStore spriteStore = SpriteStore.get();
        Sprite sprite = spriteStore.getSprite(SPRITE_SHEET);
        if (sprite == null) {
            this.idleSprite = spriteStore.getFailsafe();
            this.activeAnimation = null;
            return;
        }
        this.idleSprite = this.composeFrame(spriteStore, sprite, IDLE_FRAME_TILES, -1);
        int n = ACTIVE_TOP_LEFT_SEQUENCE.length;
        int n2 = ACTIVE_BOTTOM_LEFT_SEQUENCE.length;
        Sprite[] spriteArray = new Sprite[n];
        for (int i = 0; i < n; ++i) {
            int[] nArray = new int[]{ACTIVE_TOP_LEFT_SEQUENCE[i], ACTIVE_TOP_RIGHT_SEQUENCE[i], ACTIVE_BOTTOM_LEFT_SEQUENCE[i % n2], ACTIVE_BOTTOM_RIGHT_SEQUENCE[i % n2]};
            int n3 = ACTIVE_STIR_SEQUENCE[i / 2 % ACTIVE_STIR_SEQUENCE.length];
            spriteArray[i] = this.composeFrame(spriteStore, sprite, nArray, n3);
        }
        this.activeAnimation = new AnimatedSprite(spriteArray, 250, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sprite composeFrame(SpriteStore spriteStore, Sprite sprite, int[] nArray, int n) {
        BufferedImage bufferedImage = new BufferedImage(64, 64, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            this.drawTile(spriteStore, sprite, graphics2D, nArray[0], 0, 0);
            this.drawTile(spriteStore, sprite, graphics2D, nArray[1], 32, 0);
            this.drawTile(spriteStore, sprite, graphics2D, nArray[2], 0, 32);
            this.drawTile(spriteStore, sprite, graphics2D, nArray[3], 32, 32);
            if (n >= 0) {
                int n2 = n == 5 || n == 7 ? 32 : 0;
                this.drawTile(spriteStore, sprite, graphics2D, n, n2, 0);
            }
        }
        finally {
            graphics2D.dispose();
        }
        return new ImageSprite(bufferedImage);
    }

    private void drawTile(SpriteStore spriteStore, Sprite sprite, Graphics2D graphics2D, int n, int n2, int n3) {
        int n4 = n % 8;
        int n5 = n / 8;
        Sprite sprite2 = spriteStore.getTile(sprite, n4 * 32, n5 * 32, 32, 32);
        if (sprite2 != null) {
            sprite2.draw(graphics2D, n2, n3);
        }
    }
}

