/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.ZoneInfo;
import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Inspector;
import games.stendhal.client.entity.Item;
import games.stendhal.client.gui.InternalWindow;
import games.stendhal.client.gui.SlotWindow;
import games.stendhal.client.gui.j2d.entity.Entity2DView;
import games.stendhal.client.gui.j2d.entity.helpers.DrawingHelper;
import games.stendhal.client.gui.j2d.entity.helpers.HorizontalAlignment;
import games.stendhal.client.gui.j2d.entity.helpers.VerticalAlignment;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import games.stendhal.client.sprite.AnimatedSprite;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import games.stendhal.client.sprite.TextSprite;
import games.stendhal.common.MathHelper;
import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.SwingUtilities;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;
import org.apache.log4j.Logger;

public class Item2DView<T extends Item>
extends Entity2DView<T> {
    private static final Logger logger = Logger.getLogger(Item2DView.class);
    private static final int DEFAULT_SLOT_SIZE = 8;
    private volatile SlotWindow slotWindow;
    private int slotWindowWidth;
    private int slotWindowHeight;
    private volatile boolean quantityChanged;
    private Sprite quantitySprite;
    private boolean showQuantity;

    @Override
    public void initialize(T t) {
        super.initialize(t);
        this.quantitySprite = this.getQuantitySprite(t);
        this.quantityChanged = false;
        this.showQuantity = true;
    }

    @Override
    protected void buildRepresentation(T t) {
        Sprite sprite;
        SpriteStore spriteStore = SpriteStore.get();
        if (!this.isContained()) {
            ZoneInfo zoneInfo = ZoneInfo.get();
            sprite = spriteStore.getModifiedSprite(this.translate(this.getClassResourcePath()), zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
        } else {
            sprite = spriteStore.getSprite(this.translate(this.getClassResourcePath()));
        }
        int n = sprite.getWidth();
        int n2 = 32 * ((Item)t).getState();
        spriteStore.getTile(sprite, 0, n2, 32, 32);
        if (n > 32) {
            sprite = new AnimatedSprite(spriteStore.getTiles(sprite, 0, n2, n / 32, 32, 32), 100, true);
        } else if (sprite.getHeight() > 32) {
            sprite = spriteStore.getTile(sprite, 0, n2, 32, 32);
        }
        this.setSprite(sprite);
    }

    @Override
    public int getZIndex() {
        return 7000;
    }

    @Override
    protected String translate(String string) {
        return "data/sprites/items/" + string + ".png";
    }

    @Override
    protected void draw(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        super.draw(graphics2D, n, n2, n3, n4);
        if (this.showQuantity && this.quantitySprite != null) {
            this.drawQuantity(graphics2D, n, n2, n3, n4);
        }
    }

    private void drawQuantity(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        if (this.isContained()) {
            DrawingHelper.drawAlignedSprite(graphics2D, this.quantitySprite, HorizontalAlignment.RIGHT, VerticalAlignment.TOP, n, n2, n3, n4);
        } else {
            DrawingHelper.drawAlignedSprite(graphics2D, this.quantitySprite, HorizontalAlignment.CENTER, VerticalAlignment.TOP, n, n2, n3, n4);
        }
    }

    @Override
    public void setContained(boolean bl) {
        super.setContained(bl);
        this.quantityChanged = true;
        this.markChanged();
    }

    @Override
    protected void update() {
        super.update();
        Item item = (Item)this.entity;
        if (this.quantityChanged && item != null) {
            this.quantityChanged = false;
            this.quantitySprite = this.getQuantitySprite(item);
        }
    }

    @Override
    void entityChanged(Object object) {
        super.entityChanged(object);
        if (object == IEntity.PROP_CLASS || object == IEntity.PROP_STATE) {
            this.representationChanged = true;
        } else if (object == Item.PROP_QUANTITY) {
            this.quantityChanged = true;
        }
    }

    @Override
    public boolean isMovable() {
        return true;
    }

    @Override
    public void onAction() {
        this.onAction(ActionType.USE);
    }

    @Override
    public boolean onHarmlessAction() {
        return false;
    }

    @Override
    public void setInspector(final Inspector inspector) {
        if (this.getContent() != null && inspector != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Item2DView.this.inspect(inspector);
                }
            });
        }
    }

    @Override
    public void onAction(ActionType actionType) {
        switch (actionType) {
            case USE: {
                if (this.isReleased() && ((Item)this.entity).isOnGround()) break;
                actionType.send(actionType.fillTargetInfo(this.entity));
                break;
            }
            default: {
                super.onAction(actionType);
            }
        }
    }

    private void inspect(Inspector inspector) {
        SlotWindow slotWindow;
        int n;
        RPSlot rPSlot = this.getContent();
        if (this.slotWindowWidth == 0) {
            n = this.getSlotCapacity(rPSlot);
            this.calculateWindowProportions(n);
        }
        n = this.slotWindow == null ? 1 : 0;
        this.slotWindow = slotWindow = inspector.inspectMe(this.entity, rPSlot, this.slotWindow, this.slotWindowWidth, this.slotWindowHeight);
        if (slotWindow != null) {
            slotWindow.setCloseable(false);
            if (n != 0) {
                slotWindow.addCloseListener(new InternalWindow.CloseListener(){

                    @Override
                    public void windowClosed(InternalWindow internalWindow) {
                        Item2DView.this.slotWindow = null;
                    }
                });
            }
            if (this.isReleased()) {
                slotWindow.close();
            }
        }
    }

    private int getSlotCapacity(RPSlot rPSlot) {
        RPObject rPObject = ((Item)this.entity).getRPObject();
        if (rPObject.has("slot_size")) {
            return MathHelper.parseIntDefault(rPObject.get("slot_size"), 8);
        }
        logger.warn((Object)("Container is missing slot size: " + rPObject));
        return rPSlot.getCapacity();
    }

    private RPSlot getContent() {
        return ((Item)this.entity).getContent();
    }

    private void calculateWindowProportions(int n) {
        int n2 = (int)Math.sqrt(n);
        while (n % n2 != 0) {
            if (--n2 > 0) continue;
            logger.error((Object)("Failed to decide dimensions for slot window. slots = " + n));
            n2 = 1;
        }
        this.slotWindowWidth = n2;
        this.slotWindowHeight = n / n2;
    }

    @Override
    public void release() {
        final SlotWindow slotWindow = this.slotWindow;
        if (slotWindow != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    slotWindow.close();
                }
            });
        }
        super.release();
    }

    @Override
    public StendhalCursor getCursor() {
        return StendhalCursor.NORMAL;
    }

    private Sprite getQuantitySprite(T t) {
        int n = ((Item)t).getQuantity();
        if (n <= 1) {
            return null;
        }
        String string = this.isContained() && n > 9999999 ? n / 1000000 + "M" : (this.isContained() && n > 9999 ? n / 1000 + "K" : Integer.toString(n));
        return TextSprite.createTextSprite(string, Color.WHITE);
    }

    public void setShowQuantity(boolean bl) {
        this.showQuantity = bl;
    }
}

