/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.OutfitStore;
import games.stendhal.client.ZoneInfo;
import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.Entity;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.NPC;
import games.stendhal.client.entity.RPEntity;
import games.stendhal.client.entity.User;
import games.stendhal.client.gui.OutfitColor;
import games.stendhal.client.gui.j2d.entity.RPEntity2DView;
import games.stendhal.client.gui.j2d.entity.helpers.HorizontalAlignment;
import games.stendhal.client.gui.j2d.entity.helpers.VerticalAlignment;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.util.Arrays;
import java.util.List;
import marauroa.common.game.RPAction;
import org.apache.log4j.Logger;

class NPC2DView<T extends NPC>
extends RPEntity2DView<T> {
    private static final Logger logger = Logger.getLogger(NPC2DView.class);
    private volatile boolean ideaChanged = true;
    private Sprite ideaSprite;
    private List<String> animatedSprites = Arrays.asList("love");

    NPC2DView() {
    }

    @Override
    public void initialize(T t) {
        String string;
        super.initialize(t);
        if (((RPEntity)t).showTitle() && (string = ((Entity)t).getName()) != null && string.startsWith("Zekiel")) {
            this.titleDrawYOffset = -32;
        }
    }

    @Override
    protected Sprite getAnimationSprite() {
        Sprite sprite;
        SpriteStore spriteStore = SpriteStore.get();
        ZoneInfo zoneInfo = ZoneInfo.get();
        try {
            RPEntity rPEntity = (RPEntity)this.entity;
            int n = rPEntity.getOldOutfitCode();
            String string = rPEntity.getExtOutfit();
            OutfitColor outfitColor = OutfitColor.get(rPEntity.getRPObject());
            if (string != null) {
                sprite = OutfitStore.get().getAdjustedOutfit(string, outfitColor, zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
            } else if (n != -1) {
                int n2 = n % 100;
                int n3 = n / 100 % 100;
                int n4 = (int)((double)n / Math.pow(100.0, 2.0) % 100.0);
                int n5 = (int)((double)n / Math.pow(100.0, 3.0) % 100.0);
                int n6 = (int)((double)n / Math.pow(100.0, 4.0) % 100.0);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("body=" + n2);
                stringBuilder.append(",dress=" + n3);
                stringBuilder.append(",head=" + n4);
                stringBuilder.append(",hair=" + n5);
                stringBuilder.append(",detail=" + n6);
                sprite = OutfitStore.get().getAdjustedOutfit(stringBuilder.toString(), outfitColor, zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
            } else {
                sprite = spriteStore.getModifiedSprite(this.translate("npc/" + ((NPC)this.entity).getEntityClass()), zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Cannot build animations", (Throwable)exception);
            sprite = spriteStore.getModifiedSprite(this.translate(((NPC)this.entity).getEntityClass()), zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
        }
        return this.addShadow(sprite);
    }

    @Override
    void entityChanged(Object object) {
        super.entityChanged(object);
        if (object == IEntity.PROP_CLASS) {
            this.representationChanged = true;
        } else if (object == NPC.PROP_IDEA) {
            this.ideaChanged = true;
        }
    }

    @Override
    protected void buildActions(List<String> list) {
        super.buildActions(list);
        list.remove(ActionType.PUSH.getRepresentation());
        if (User.isAdmin()) {
            list.add(ActionType.ADMIN_VIEW_NPC_TRANSITIONS.getRepresentation());
        }
    }

    @Override
    protected void update() {
        super.update();
        if (this.ideaChanged) {
            this.ideaChanged = false;
            this.detachSprite(this.ideaSprite);
            this.ideaSprite = this.getIdeaSprite();
            if (this.ideaSprite != null) {
                this.attachSprite(this.ideaSprite, HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 8, -8);
            }
        }
    }

    private Sprite getIdeaSprite() {
        String string = ((NPC)this.entity).getIdea();
        if (string == null) {
            return null;
        }
        SpriteStore spriteStore = SpriteStore.get();
        Sprite sprite = spriteStore.getSprite("data/sprites/ideas/" + string + ".png");
        if (this.animatedSprites.contains(string)) {
            sprite = spriteStore.getAnimatedSprite(sprite, 100);
        }
        return sprite;
    }

    @Override
    public void onAction(ActionType actionType) {
        switch (actionType) {
            case ADMIN_VIEW_NPC_TRANSITIONS: {
                RPAction rPAction = new RPAction();
                rPAction.put("type", "script");
                rPAction.put("target", "DumpTransitionsEx.class");
                rPAction.put("args", ((NPC)this.getEntity()).getTitle());
                actionType.send(rPAction);
                break;
            }
            default: {
                super.onAction(actionType);
            }
        }
    }

    @Override
    public StendhalCursor getCursor() {
        return StendhalCursor.LOOK;
    }
}

