/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.login;

import games.stendhal.client.StendhalClient;
import games.stendhal.client.gui.NumberDocumentFilter;
import games.stendhal.client.gui.ProgressBar;
import games.stendhal.client.gui.WindowUtils;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.stendhal;
import games.stendhal.client.update.ClientGameConfiguration;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import marauroa.client.BannedAddressException;
import marauroa.client.LoginFailedException;
import marauroa.client.TimeoutException;
import marauroa.common.game.AccountResult;
import marauroa.common.net.InvalidVersionException;
import org.apache.log4j.Logger;

public class CreateAccountDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(CreateAccountDialog.class);
    private JTextField usernameField;
    private JPasswordField passwordField;
    private JPasswordField passwordretypeField;
    private JTextField emailField;
    private JTextField serverField;
    private JTextField serverPortField;
    private StendhalClient client;
    private String badEmailTitle;
    private String badEmailReason;
    private String badPasswordReason;

    public CreateAccountDialog(Frame frame, StendhalClient stendhalClient) {
        super(frame, true);
        this.client = stendhalClient;
        this.initializeComponent(frame);
        WindowUtils.closeOnEscape(this);
        this.setVisible(true);
    }

    CreateAccountDialog() {
        this.initializeComponent(null);
    }

    private void initializeComponent(final Frame frame) {
        this.setDefaultCloseOperation(2);
        if (frame != null) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    frame.setEnabled(true);
                }
            });
        }
        JLabel jLabel = new JLabel("Nazwa serwera");
        this.serverField = new JTextField(ClientGameConfiguration.get((String)"DEFAULT_SERVER"));
        this.serverField.setEditable(true);
        JLabel jLabel2 = new JLabel("Port serwera");
        this.serverPortField = new JTextField(ClientGameConfiguration.get((String)"DEFAULT_PORT"));
        ((AbstractDocument)this.serverPortField.getDocument()).setDocumentFilter(new NumberDocumentFilter(this.serverPortField, false));
        JLabel jLabel3 = new JLabel("Wybierz imi\u0119 wojownika");
        this.usernameField = new JTextField();
        JLabel jLabel4 = new JLabel("Has\u0142o (min. 6 znak\u00f3w)");
        this.passwordField = new JPasswordField();
        JLabel jLabel5 = new JLabel("Powt\u00f3rz has\u0142o");
        this.passwordretypeField = new JPasswordField();
        JLabel jLabel6 = new JLabel("Adres e-mail (opcjonalnie)");
        this.emailField = new JTextField();
        JButton jButton = new JButton();
        jButton.setText("Utw\u00f3rz Konto");
        jButton.setMnemonic(65);
        this.rootPane.setDefaultButton(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateAccountDialog.this.onCreateAccount();
            }
        });
        int n = 5;
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new SBoxLayout(false, n));
        jPanel.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        JComponent jComponent = new JComponent(){};
        jComponent.setLayout(new GridLayout(0, 2, n, n));
        jPanel.add((Component)jComponent, SBoxLayout.constraint(SLayout.EXPAND_X, SLayout.EXPAND_Y));
        jComponent.add(jLabel);
        jComponent.add(this.serverField);
        jComponent.add(jLabel2);
        jComponent.add(this.serverPortField);
        jComponent.add(jLabel3);
        jComponent.add(this.usernameField);
        jComponent.add(jLabel4);
        jComponent.add(this.passwordField);
        jComponent.add(jLabel5);
        jComponent.add(this.passwordretypeField);
        jComponent.add(jLabel6);
        jComponent.add(this.emailField);
        jComponent.add(new JComponent(){});
        JCheckBox jCheckBox = new JCheckBox("Poka\u017c has\u0142o");
        jCheckBox.setHorizontalAlignment(4);
        final char c = this.passwordField.getEchoChar();
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                char c2 = itemEvent.getStateChange() == 1 ? (char)'\u0000' : c;
                CreateAccountDialog.this.passwordField.setEchoChar(c2);
                CreateAccountDialog.this.passwordretypeField.setEchoChar(c2);
            }
        });
        jComponent.add(jCheckBox);
        JLabel jLabel7 = new JLabel("<html><body><p><font size=\"-2\">Podczas logowania, informacje, kt\u00f3re identyfikuj\u0105 tw\u00f3j komputer zostan\u0105 zapisane<br>w celu zapobiegni\u0119cia nadu\u017cyciom (np. przy pr\u00f3bie odgadni\u0119cia has\u0142a w celu w\u0142amania si\u0119 na konto<br>lub tworzeniu wielu kont w celu sprawiania problem\u00f3w).</font></p><p><font size=\"-2\">Ponadto wszystkie zdarzenia i akcje, kt\u00f3re wydarz\u0105 si\u0119 w grze-<br>(np. rozwi\u0105zywanie zada\u0144, atakowanie potwor\u00f3w) b\u0119d\u0105 zapisywane w logach.<br>Informacje te wykorzystywane b\u0119d\u0105 w celu analizy luk oraz rzadko w sprawach nadu\u017cy\u0107.</font></p><br><p><font size=\"-2\">PolanieOnLine to niekomercyjny projekt sp\u0119dzania czasu wolnego. NIE wykorzystujemy<br>Twoich danych do cel\u00f3w reklamowych oraz NIE udost\u0119pniamy ich osobom trzecim.</font></p></body></html>");
        jLabel7.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        jLabel7.setAlignmentX(0.5f);
        jPanel.add((Component)jLabel7, SBoxLayout.constraint(SLayout.EXPAND_X, SLayout.EXPAND_Y));
        JComponent jComponent2 = SBoxLayout.createContainer(true, 5);
        jComponent2.setAlignmentX(1.0f);
        JButton jButton2 = new JButton("Zamknij");
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateAccountDialog.this.dispatchEvent(new WindowEvent(CreateAccountDialog.this, 201));
            }
        });
        jComponent2.add(jButton2);
        jComponent2.add(jButton);
        jPanel.add(jComponent2);
        this.setTitle("Utw\u00f3rz Nowe Konto");
        this.setResizable(false);
        this.pack();
        this.usernameField.requestFocusInWindow();
        if (frame != null) {
            frame.setEnabled(false);
            this.setLocationRelativeTo(frame);
        }
    }

    private void onCreateAccount() {
        final String string = this.usernameField.getText();
        final String string2 = new String(this.passwordField.getPassword());
        if (!this.isEnabled()) {
            return;
        }
        boolean bl = this.checkFields();
        if (!bl) {
            return;
        }
        final String string3 = this.emailField.getText();
        final String string4 = this.serverField.getText();
        int n = 32160;
        final ProgressBar progressBar = new ProgressBar(this);
        try {
            n = Integer.parseInt(this.serverPortField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this.getOwner(), "Niew\u0142a\u015bciwy numer portu. Spr\u00f3buj ponownie.", "Niew\u0142a\u015bciwy port", 2);
            return;
        }
        final int n2 = n;
        if (this.client == null) {
            JOptionPane.showMessageDialog(this, "Konto nie zosta\u0142o utworzone!");
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                progressBar.start();
                CreateAccountDialog.this.setEnabled(false);
                try {
                    CreateAccountDialog.this.client.connect(string4, n2);
                    progressBar.step();
                }
                catch (Exception exception) {
                    progressBar.cancel();
                    CreateAccountDialog.this.setEnabled(true);
                    JOptionPane.showMessageDialog(CreateAccountDialog.this.getOwner(), "Nie mo\u017cna si\u0119 po\u0142\u0105czy\u0107 z serwerem w celu utworzenia konta. Serwer mo\u017ce nie dzia\u0142a\u0107, a je\u015bli korzystasz z innego serwera to sprawd\u017a czy poprawnie wpisa\u0142e\u015b nazw\u0119 i numer portu.");
                    LOGGER.error((Object)exception, (Throwable)exception);
                    return;
                }
                Window window = CreateAccountDialog.this.getOwner();
                try {
                    AccountResult accountResult = CreateAccountDialog.this.client.createAccount(string, string2, string3);
                    if (accountResult.failed()) {
                        progressBar.cancel();
                        CreateAccountDialog.this.setEnabled(true);
                        JOptionPane.showMessageDialog(window, accountResult.getResult().getText(), "Nie powiod\u0142o si\u0119 tworzenie konta", 0);
                    } else {
                        progressBar.step();
                        progressBar.finish();
                        CreateAccountDialog.this.client.setAccountUsername(string);
                        CreateAccountDialog.this.client.setCharacter(string);
                        CreateAccountDialog.this.client.login(string, string2);
                        progressBar.step();
                        progressBar.finish();
                        CreateAccountDialog.this.setEnabled(false);
                        if (window != null) {
                            window.setVisible(false);
                            window.dispose();
                        }
                        stendhal.setDoLogin();
                    }
                }
                catch (TimeoutException timeoutException) {
                    progressBar.cancel();
                    CreateAccountDialog.this.setEnabled(true);
                    JOptionPane.showMessageDialog(window, "Nie mo\u017cna si\u0119 po\u0142\u0105czy\u0107 z serwerem w celu utworzenia konta. Serwer mo\u017ce nie dzia\u0142a\u0107 lub mog\u0142e\u015b wprowadzi\u0107 niew\u0142a\u015bciw\u0105 nazw\u0119 serwera i numer portu.", "B\u0142\u0105d Tworzenia Konta", 0);
                }
                catch (InvalidVersionException invalidVersionException) {
                    progressBar.cancel();
                    CreateAccountDialog.this.setEnabled(true);
                    JOptionPane.showMessageDialog(window, "Uruchomi\u0142e\u015b starsz\u0105 wersj\u0119 gry. Prosz\u0119 zaktualizuj swoj\u0105 wersj\u0119", "Starsza wersja", 0);
                }
                catch (BannedAddressException bannedAddressException) {
                    progressBar.cancel();
                    CreateAccountDialog.this.setEnabled(true);
                    JOptionPane.showMessageDialog(window, "Twoje IP zosta\u0142o zablokowane. Je\u017celi nie zgadzasz si\u0119 z decyzj\u0105 to skontaktuj si\u0119 z nami na https://s1.polanieonline.eu/kontakt-gmgags.html", "Zablokowane IP", 0);
                }
                catch (LoginFailedException loginFailedException) {
                    progressBar.cancel();
                    CreateAccountDialog.this.setEnabled(true);
                    JOptionPane.showMessageDialog(window, loginFailedException.getMessage(), "B\u0142\u0105d logowania", 1);
                }
            }
        };
        thread.start();
    }

    private boolean checkFields() {
        String string;
        String string2 = new String(this.passwordField.getPassword());
        String string3 = new String(this.passwordretypeField.getPassword());
        Window window = this.getOwner();
        if (!string2.equals(string3)) {
            JOptionPane.showMessageDialog(window, "Has\u0142a nie pasuj\u0105 do siebie. Powt\u00f3rz oba has\u0142a.", "Has\u0142o nie pasuje", 2);
            return false;
        }
        boolean bl = this.validatePassword(this.usernameField.getText(), string2);
        if (!bl) {
            if (this.badPasswordReason != null) {
                int n = JOptionPane.showOptionDialog(window, this.badPasswordReason, "Niew\u0142a\u015bciwe has\u0142o", 0, 2, null, new String[]{"Tak", "Nie"}, 1);
                if (n == 1) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (!this.validateEmail(string = this.emailField.getText().trim())) {
            String string4 = this.badEmailReason + "Adres e-mail jest jedynym sposobem, w jaki administratorzy mog\u0105 kontaktowa\u0107 si\u0119 z prawowitym w\u0142a\u015bcicielem konta.\nJe\u015bli go nie dostarczysz, nie b\u0119dziesz m\u00f3g\u0142 uzyska\u0107 nowego has\u0142a do tego konta, na przyk\u0142ad:\n- Zapomnia\u0142e\u015b has\u0142a.\n- Inny gracz w jaki\u015b spos\u00f3b dostaje has\u0142o i zmienia je.\nCzy mimo to chcesz kontynuowa\u0107?";
            int n = JOptionPane.showOptionDialog(window, string4, this.badEmailTitle, 0, 2, null, new String[]{"Tak", "Nie"}, 1);
            if (n != 0) {
                return false;
            }
        }
        return true;
    }

    private boolean validateEmail(String string) {
        if (string.isEmpty()) {
            this.badEmailTitle = "Pole adresu e-mail jest puste";
            this.badEmailReason = "Nie poda\u0142e\u015b adresu e-mail.\n";
            return false;
        }
        if (!string.contains("@") || !string.contains(".") || string.length() <= 5) {
            this.badEmailTitle = "B\u0142\u0105d w adresie e-mail?";
            this.badEmailReason = "Wpisany adres e-mail ma prawdopodobnie b\u0142\u0105d.\n";
            return false;
        }
        return true;
    }

    private void debug(String string) {
        if (this.client == null) {
            LOGGER.debug((Object)string);
        }
    }

    public static void main(String[] stringArray) {
        new CreateAccountDialog(null, null);
    }

    boolean validatePassword(String string, String string2) {
        if (string2.length() > 5) {
            boolean bl = true;
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            if (bl) {
                this.badPasswordReason = "W swoim ha\u015ble u\u017cy\u0142e\u015b tylko liczb. To nie jest bezpieczna metoda.\n Czy chcesz u\u017cy\u0107 tego has\u0142a?";
            }
            boolean bl2 = false;
            if (string2.contains(string)) {
                bl2 = true;
            }
            if (!bl2) {
                String string3;
                int n;
                this.debug("Checking if password contains a derivative of the username, trimming from the back...");
                for (n = 1; n < string.length(); ++n) {
                    string3 = string.substring(0, string.length() - n);
                    this.debug("\tsprawdzam for \"" + string3 + "\"...");
                    if (string3.length() <= 3) break;
                    if (!string2.contains(string3)) continue;
                    bl2 = true;
                    this.debug("Has\u0142o zawiera nazw\u0119 konta!");
                    break;
                }
                if (!bl2) {
                    this.debug("Checking if password contains a derivative of the username, trimming from the front...");
                    for (n = 0; n < string.length(); ++n) {
                        string3 = string.substring(n);
                        this.debug("\tsprawdzam for \"" + string3 + "\"...");
                        if (string3.length() <= 3) break;
                        if (!string2.contains(string3)) continue;
                        bl2 = true;
                        this.debug("Has\u0142o zawiera nazw\u0119 konta!");
                        break;
                    }
                }
            }
            if (bl2) {
                this.badPasswordReason = "W ha\u015ble u\u017cy\u0142e\u015b nazw\u0119 konta lub jest do niej podobna. To jest kiepskie zabezpieczenie konta.\n Jeste\u015b pewien, \u017ce chcesz u\u017cy\u0107 tego has\u0142a?";
                return false;
            }
        } else {
            if (this.isVisible()) {
                JOptionPane.showMessageDialog(this.getOwner(), "Has\u0142o, kt\u00f3re wprowadzi\u0142e\u015b jest za kr\u00f3tkie. Musi si\u0119 sk\u0142ada\u0107 z minimum 6 znak\u00f3w.");
            } else {
                LOGGER.warn((Object)"Has\u0142o, kt\u00f3re wprowadzi\u0142e\u015b jest za kr\u00f3tkie. Musi si\u0119 sk\u0142ada\u0107 z minimum 6 znak\u00f3w.");
            }
            return false;
        }
        return true;
    }
}

