/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.login;

public class Profile {
    static final int DEFAULT_SERVER_PORT = 32160;
    private static final String[] OLD_SERVER_HOSTS = new String[]{"145.239.87.198"};
    private static final String NEW_SERVER_HOST = "polanieonline.eu";
    private String host;
    private int port;
    private String user;
    private String password;
    private String character;
    private String seed;

    public Profile() {
        this("", 32160, "", "");
    }

    private Profile(String string, int n, String string2, String string3) {
        this.host = string;
        this.port = n;
        this.user = string2;
        this.password = string3;
    }

    String encode() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getHost());
        stringBuilder.append('\n');
        stringBuilder.append(this.getUser());
        stringBuilder.append('\n');
        stringBuilder.append(this.getPassword());
        stringBuilder.append('\n');
        stringBuilder.append(this.getPort());
        stringBuilder.append('\n');
        stringBuilder.append(true);
        return stringBuilder.toString();
    }

    public String getHost() {
        return this.host;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getCharacter() {
        return this.character;
    }

    public String getSeed() {
        return this.seed;
    }

    static Profile decode(String string) {
        String string2;
        String[] stringArray = string.split("\n");
        Profile profile = new Profile();
        if (stringArray.length > 0) {
            string2 = stringArray[0];
            for (String string3 : OLD_SERVER_HOSTS) {
                if (!string2.equals(string3)) continue;
                string2 = NEW_SERVER_HOST;
                break;
            }
            if (string2.length() != 0) {
                profile.setHost(string2);
            }
        }
        if (stringArray.length > 1 && (string2 = stringArray[1]).length() != 0) {
            profile.setUser(string2);
        }
        if (stringArray.length > 2 && (string2 = stringArray[2]).length() != 0) {
            profile.setPassword(string2);
        }
        if (stringArray.length > 3 && (string2 = stringArray[3]).length() != 0) {
            try {
                profile.setPort(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return profile;
    }

    public static Profile createFromCommandline(String[] stringArray) {
        Profile profile = new Profile();
        for (int i = 0; i != stringArray.length; ++i) {
            if (stringArray[i].equals("-u")) {
                profile.setUser(stringArray[i + 1]);
                continue;
            }
            if (stringArray[i].equals("-p")) {
                profile.setPassword(stringArray[i + 1]);
                continue;
            }
            if (stringArray[i].equals("-c")) {
                profile.setCharacter(stringArray[i + 1]);
                continue;
            }
            if (stringArray[i].equals("-h")) {
                profile.setHost(stringArray[i + 1]);
                continue;
            }
            if (stringArray[i].equals("-P")) {
                profile.setPort(Integer.parseInt(stringArray[i + 1]));
                continue;
            }
            if (!stringArray[i].equals("-S")) continue;
            profile.setSeed(stringArray[i + 1]);
        }
        if (profile.getCharacter() == null) {
            profile.setCharacter(profile.getUser());
        }
        return profile;
    }

    public boolean isValid() {
        return this.host != null && this.user != null && this.password != null && !this.host.equals("") && !this.user.equals("") && !this.password.equals("");
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setCharacter(String string) {
        this.character = string;
    }

    public void setSeed(String string) {
        this.seed = string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Profile)) {
            return false;
        }
        Profile profile = (Profile)object;
        if (!this.getHost().equals(profile.getHost())) {
            return false;
        }
        if (this.getPort() != profile.getPort()) {
            return false;
        }
        return this.getUser().equals(profile.getUser());
    }

    public int hashCode() {
        return this.getHost().hashCode() ^ this.getUser().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getUser());
        if (this.getCharacter() != null) {
            stringBuilder.append("/");
            stringBuilder.append(this.getCharacter());
        }
        stringBuilder.append('@');
        stringBuilder.append(this.getHost());
        if (this.getPort() != 32160) {
            stringBuilder.append(':');
            stringBuilder.append(this.getPort());
        }
        return stringBuilder.toString();
    }
}

