/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.login;

import games.stendhal.client.gui.login.Encoder;
import games.stendhal.client.gui.login.Profile;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;

class ProfileList
implements Iterable<Profile> {
    protected ArrayList<Profile> profiles = new ArrayList();

    void add(Profile profile) {
        this.profiles.remove(profile);
        this.profiles.add(profile);
    }

    private void clear() {
        this.profiles.clear();
    }

    @Override
    public Iterator<Profile> iterator() {
        return this.profiles.iterator();
    }

    void load(InputStream inputStream) throws IOException {
        String string;
        Encoder encoder = new Encoder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        this.clear();
        while ((string = bufferedReader.readLine()) != null) {
            this.add(Profile.decode(encoder.decode(string)));
        }
    }

    void remove(Profile profile) {
        this.profiles.remove(profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(OutputStream outputStream) throws IOException {
        Encoder encoder = new Encoder();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        try {
            for (Profile profile : this) {
                outputStreamWriter.write(encoder.encode(profile.encode()));
                outputStreamWriter.write(System.getProperty("line.separator"));
            }
        }
        finally {
            ((Writer)outputStreamWriter).flush();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("Usage: java " + ProfileList.class.getName() + " <user.dat>");
            System.exit(1);
        }
        ProfileList profileList = new ProfileList();
        try (FileInputStream fileInputStream = new FileInputStream(stringArray[0]);){
            profileList.load(fileInputStream);
        }
        for (Profile profile : profileList) {
            System.out.println(profile);
        }
    }
}

