/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.map;

import games.stendhal.client.StendhalClient;
import games.stendhal.client.gui.map.MapObject;
import games.stendhal.client.gui.map.MapPanelController;
import games.stendhal.common.CollisionDetection;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import marauroa.common.game.RPAction;

class MapPanel
extends JComponent {
    private static final long serialVersionUID = -6471592733173102868L;
    private static final Color COLOR_BACKGROUND = new Color(0.8f, 0.8f, 0.8f);
    public static final Color COLOR_BLOCKED = new Color(1.0f, 0.0f, 0.0f);
    private static final Color COLOR_PROTECTION = new Color(202, 230, 202);
    private static final Color COLOR_SECRET = new Color(1.0f, 0.0f, 0.0f);
    private static final int MAP_WIDTH = 128;
    private static final int MAP_HEIGHT = 128;
    private static final int MINIMUM_SCALE = 2;
    private final StendhalClient client;
    private final MapPanelController controller;
    private double playerX;
    private double playerY;
    private Point lastHoverPoint;
    private int xOffset;
    private int yOffset;
    private int width;
    private int height;
    private int scale;
    private Image mapImage;
    private CollisionDetection lastCollision;
    private CollisionDetection lastProtection;
    private CollisionDetection lastSecret;
    private int lastTileWidth;
    private int lastTileHeight;

    MapPanel(MapPanelController mapPanelController, StendhalClient stendhalClient) {
        this.client = stendhalClient;
        this.controller = mapPanelController;
        this.setBackground(Color.black);
        this.updateSize(new Dimension(128, 128));
        this.setOpaque(true);
        this.setToolTipText("");
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MapPanel.this.movePlayer(mouseEvent.getPoint(), mouseEvent.getClickCount() > 1);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                MapPanel.this.updateHoverPoint(mouseEvent.getPoint());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                MapPanel.this.lastHoverPoint = null;
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.controller.setNeedsRefresh(false);
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.clipRect(0, 0, this.width, this.height);
        graphics.translate(-this.xOffset, -this.yOffset);
        this.drawMap(graphics);
        this.drawEntities(graphics);
        graphics.dispose();
    }

    private void drawEntities(Graphics graphics) {
        for (MapObject mapObject : this.controller.mapObjects.values()) {
            mapObject.draw(graphics, this.scale);
        }
    }

    private void updateSize(Dimension dimension) {
        this.setMaximumSize(dimension);
        this.setMinimumSize(new Dimension(0, dimension.height));
        this.setPreferredSize(dimension);
        this.setSize(this.getWidth(), dimension.height);
        this.controller.setNeedsRefresh(true);
        this.revalidate();
    }

    private void drawMap(Graphics graphics) {
        graphics.drawImage(this.mapImage, 0, 0, null);
    }

    void positionChanged(double d, double d2) {
        this.playerX = d;
        this.playerY = d2;
        this.updateView();
        if (this.lastHoverPoint != null) {
            this.refreshTooltipForHover();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintImmediately(int n, int n2, int n3, int n4) {
        if (StendhalClient.get().tryAcquireDrawingSemaphore()) {
            try {
                super.paintImmediately(n, n2, n3, n4);
            }
            finally {
                StendhalClient.get().releaseDrawingSemaphore();
            }
        }
    }

    private void updateView() {
        this.xOffset = 0;
        this.yOffset = 0;
        if (this.mapImage == null) {
            return;
        }
        int n = this.mapImage.getWidth(null);
        int n2 = this.mapImage.getHeight(null);
        int n3 = (int)(this.playerX * (double)this.scale + 0.5) - this.width / 2;
        int n4 = (int)(this.playerY * (double)this.scale + 0.5) - this.width / 2;
        if (n > this.width) {
            if (n3 + this.width > n) {
                this.xOffset = n - this.width;
            } else if (n3 > 0) {
                this.xOffset = n3;
            }
        }
        if (n2 > this.height) {
            if (n4 + this.height > n2) {
                this.yOffset = n2 - this.height;
            } else if (n4 > 0) {
                this.yOffset = n4;
            }
        }
    }

    void update(final CollisionDetection collisionDetection, final CollisionDetection collisionDetection2, final CollisionDetection collisionDetection3, boolean bl) {
        boolean bl2;
        final int n = collisionDetection.getWidth();
        final int n2 = collisionDetection.getHeight();
        final int n3 = Math.max(2, Math.min(128 / n2, 128 / n));
        final int n4 = Math.min(128, n * n3);
        final int n5 = Math.min(128, n2 * n3);
        final boolean bl3 = this.width != n4 || this.height != n5;
        boolean bl4 = this.lastTileWidth != n || this.lastTileHeight != n2;
        boolean bl5 = bl2 = bl || bl4 || collisionDetection != this.lastCollision || collisionDetection2 != this.lastProtection || collisionDetection3 != this.lastSecret;
        if (!bl2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapPanel.this.scale = n3;
                    MapPanel.this.width = n4;
                    MapPanel.this.height = n5;
                    if (bl3) {
                        MapPanel.this.updateSize(new Dimension(128, n5));
                    }
                    MapPanel.this.updateView();
                }
            });
            this.repaint();
            return;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        final BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n * n3, n2 * n3);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        graphics.setColor(COLOR_BACKGROUND);
        graphics.fillRect(0, 0, n * n3, n2 * n3);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (collisionDetection.collides(i, j)) {
                    graphics.setColor(COLOR_BLOCKED);
                    graphics.fillRect(i * n3, j * n3, n3, n3);
                    continue;
                }
                if (collisionDetection2 != null && collisionDetection2.collides(i, j)) {
                    graphics.setColor(COLOR_PROTECTION);
                    graphics.fillRect(i * n3, j * n3, n3, n3);
                    continue;
                }
                if (collisionDetection3 == null || !collisionDetection3.collides(i, j)) continue;
                graphics.setColor(COLOR_SECRET);
                graphics.fillRect(i * n3, j * n3, n3, n3);
            }
        }
        graphics.dispose();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapPanel.this.mapImage = bufferedImage;
                MapPanel.this.lastCollision = collisionDetection;
                MapPanel.this.lastProtection = collisionDetection2;
                MapPanel.this.lastSecret = collisionDetection3;
                MapPanel.this.lastTileWidth = n;
                MapPanel.this.lastTileHeight = n2;
                MapPanel.this.scale = n3;
                MapPanel.this.width = n4;
                MapPanel.this.height = n5;
                if (bl3) {
                    MapPanel.this.updateSize(new Dimension(128, n5));
                }
                MapPanel.this.updateView();
            }
        });
        this.repaint();
    }

    private void movePlayer(Point point, boolean bl) {
        if (point.y <= this.height) {
            RPAction rPAction = new RPAction();
            rPAction.put("type", "moveto");
            rPAction.put("x", (point.x + this.xOffset) / this.scale);
            rPAction.put("y", (point.y + this.yOffset) / this.scale);
            if (bl) {
                rPAction.put("double_click", "");
            }
            this.client.send(rPAction);
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent == null || !this.isInsideMapArea(mouseEvent.getX(), mouseEvent.getY())) {
            return null;
        }
        return this.getPlayerCoordinateTooltip();
    }

    private boolean isInsideMapArea(int n, int n2) {
        if (this.mapImage == null || this.scale <= 0) {
            return false;
        }
        return n2 >= 0 && n2 <= this.height && n >= 0 && n <= this.width;
    }

    private void updateHoverPoint(Point point) {
        if (point == null || !this.isInsideMapArea(point.x, point.y)) {
            this.lastHoverPoint = null;
            return;
        }
        this.lastHoverPoint = point;
    }

    private void refreshTooltipForHover() {
        if (this.lastHoverPoint == null) {
            return;
        }
        String string = this.getPlayerCoordinateTooltip();
        if (string == null) {
            return;
        }
        MouseEvent mouseEvent = new MouseEvent(this, 503, System.currentTimeMillis(), 0, this.lastHoverPoint.x, this.lastHoverPoint.y, 0, false);
        ToolTipManager.sharedInstance().mouseMoved(mouseEvent);
    }

    private String getPlayerCoordinateTooltip() {
        if (this.mapImage == null || this.scale <= 0) {
            return null;
        }
        int n = this.mapImage.getWidth(null) / this.scale;
        int n2 = this.mapImage.getHeight(null) / this.scale;
        int n3 = (int)Math.round(this.playerX);
        int n4 = (int)Math.round(this.playerY);
        if (n3 < 0 || n4 < 0 || n3 >= n || n4 >= n2) {
            return null;
        }
        return "(" + n3 + ", " + n4 + ")";
    }
}

