/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.progress;

import games.stendhal.client.StendhalClient;
import games.stendhal.client.entity.User;
import games.stendhal.client.gui.WindowUtils;
import games.stendhal.client.gui.progress.ProgressLog;
import games.stendhal.client.gui.progress.ProgressStatusQuery;
import java.awt.Window;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import marauroa.common.game.RPAction;

public class ProgressLogController {
    private static ProgressLogController instance;
    private ProgressLog progressLog;

    public static synchronized ProgressLogController get() {
        if (instance == null) {
            instance = new ProgressLogController();
        }
        return instance;
    }

    private ProgressLogController() {
    }

    public void setRepeatable(final Collection<String> collection) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressLogController.this.getProgressLog().setRepeatable(collection);
            }
        });
    }

    public void showCategories(final List<String> list) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RequestAction requestAction = new RequestAction();
                requestAction.setDataKey("progress_type");
                ProgressLogController.this.getProgressLog().setPages(list, requestAction);
                ProgressLogController.this.showWindow();
            }
        });
    }

    public void showCategorySummary(final String string, final List<String> list) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RequestAction requestAction = new RequestAction();
                requestAction.setDataKey("item");
                requestAction.setProgressType(string);
                ProgressLogController.this.getProgressLog().setPageIndex(string, list, requestAction);
                ProgressLogController.this.showWindow();
            }
        });
    }

    public void showDescription(final String string, final String string2, final String string3, final String string4, final List<String> list) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressLogController.this.getProgressLog().setPageContent(string, string2, string3, string4, list);
                ProgressLogController.this.showWindow();
            }
        });
    }

    private ProgressLog getProgressLog() {
        if (this.progressLog == null) {
            this.progressLog = new ProgressLog(User.getCharacterName() + " dziennik zada\u0144");
        }
        return this.progressLog;
    }

    private void showWindow() {
        Window window = this.getProgressLog().getWindow();
        WindowUtils.restoreSize(window);
        window.setVisible(true);
    }

    private static class RequestAction
    implements ProgressStatusQuery {
        private String progressType;
        private String dataKey;

        private RequestAction() {
        }

        @Override
        public void fire(String string) {
            RPAction rPAction = new RPAction();
            rPAction.put("type", "progressstatus");
            if (this.progressType != null) {
                rPAction.put("progress_type", this.progressType);
            }
            if (this.dataKey != null) {
                rPAction.put(this.dataKey, string);
            }
            StendhalClient.get().send(rPAction);
        }

        void setDataKey(String string) {
            this.dataKey = string;
        }

        void setProgressType(String string) {
            this.progressType = string;
        }
    }
}

