/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.settings;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.actions.MoveContinuousAction;
import games.stendhal.client.gui.chatlog.EventLine;
import games.stendhal.client.gui.j2DClient;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.gui.settings.SettingsComponentFactory;
import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import games.stendhal.client.gui.wt.core.SettingChangeListener;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.common.NotificationType;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;

class GeneralSettings {
    private static final String GAMESCREEN_AUTORAISECORPSE = "gamescreen.autoinspectcorpses";
    private static final String DOUBLE_CLICK_PROPERTY = "ui.doubleclick";
    private static final String HEALING_MESSAGE_PROPERTY = "ui.healingmessage";
    private static final String POISON_MESSAGE_PROPERTY = "ui.poisonmessage";
    private static final String DIMENSIONS_PROPERTY = "ui.dimensions";
    private final JComponent page;

    GeneralSettings() {
        int n = 5;
        this.page = SBoxLayout.createContainer(false, n);
        this.page.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        JComponent jComponent = SBoxLayout.createContainer(true, n);
        JComponent jComponent2 = SBoxLayout.createContainer(false, n);
        JComponent jComponent3 = SBoxLayout.createContainer(false, n);
        jComponent.add((Component)jComponent2, (Object)SLayout.EXPAND_X);
        jComponent.add((Component)jComponent3, (Object)SLayout.EXPAND_X);
        this.page.add((Component)jComponent, (Object)SLayout.EXPAND_X);
        final WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        JComponent jComponent4 = SBoxLayout.createContainer(true, n);
        JLabel jLabel = new JLabel("Sterowanie ruchem (eksperymentalne):");
        final JComboBox<MovementKeyOption> jComboBox = new JComboBox<MovementKeyOption>(MovementKeyOption.values());
        jComboBox.setToolTipText("Wybierz, czy poruszasz si\u0119 strza\u0142kami, czy klawiszami WASD (eksperymentalne). WASD wy\u0142\u0105cza automatyczne ustawianie fokusu na czacie.");
        jLabel.setToolTipText(jComboBox.getToolTipText());
        MovementKeyOption movementKeyOption = MovementKeyOption.fromProperty(wtWindowManager.getProperty("move.keys", "arrows"));
        jComboBox.setSelectedItem((Object)movementKeyOption);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = jComboBox.getSelectedItem();
                if (object instanceof MovementKeyOption) {
                    MovementKeyOption movementKeyOption = (MovementKeyOption)((Object)object);
                    wtWindowManager.setProperty("move.keys", movementKeyOption.getPropertyValue());
                    String string = "Sterowanie ruchem ustawione na " + movementKeyOption.getLabel() + ".";
                    ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", string, NotificationType.CLIENT));
                }
            }
        });
        jComponent4.add(jLabel);
        jComponent4.add(Box.createHorizontalStrut(n));
        jComponent4.add(jComboBox);
        jComponent2.add((Component)jComponent4, (Object)SLayout.EXPAND_X);
        JCheckBox jCheckBox = SettingsComponentFactory.createSettingsToggle(DOUBLE_CLICK_PROPERTY, false, "Tryb podw\u00f3jnego klikania", "Poruszanie i atak za pomoc\u0105 podw\u00f3jnego klikni\u0119cia. Je\u017celi nie zaznaczony to domy\u015blnym jest pojedy\u0144cze klikni\u0119cie.");
        jComponent2.add(jCheckBox);
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                GeneralSettings.this.getState(itemEvent, "Tryb podw\u00f3jnego klikania zosta\u0142o ");
            }
        });
        JCheckBox jCheckBox2 = SettingsComponentFactory.createSettingsToggle(GAMESCREEN_AUTORAISECORPSE, true, "Auto sprawdzanie zw\u0142ok", "Automatycznie otwiera okno zw\u0142ok potwora, z kt\u00f3rego mo\u017cesz wzi\u0105\u0107 sw\u00f3j \u0142up");
        jComponent2.add(jCheckBox2);
        jCheckBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                GeneralSettings.this.getState(itemEvent, "Automatyczne sprawdzanie zw\u0142ok zosta\u0142o ");
            }
        });
        JCheckBox jCheckBox3 = SettingsComponentFactory.createSettingsToggle(HEALING_MESSAGE_PROPERTY, false, "Poka\u017c wiadomo\u015bci o leczeniu", "Pokazuje wiadomo\u015bci o leczeniu w oknie rozmowy");
        jComponent2.add(jCheckBox3);
        jCheckBox3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                GeneralSettings.this.getState(itemEvent, "Wiadomo\u015bci o leczeniu zosta\u0142y ");
            }
        });
        JCheckBox jCheckBox4 = SettingsComponentFactory.createSettingsToggle(POISON_MESSAGE_PROPERTY, false, "Poka\u017c wiadomo\u015bci o zatruciu", "Pokazuje wiadomo\u015bci o zatruciu w oknie rozmowy");
        jComponent2.add(jCheckBox4);
        jCheckBox4.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                GeneralSettings.this.getState(itemEvent, "Wiadomo\u015bci o zatruciu zosta\u0142y ");
            }
        });
        JCheckBox jCheckBox5 = SettingsComponentFactory.createSettingsToggle("move.doubletapautowalk", false, "Automatyczne chodzenie (zbugowane)", "W\u0142\u0105cza automatyczne chodzenie, gdy klawisz kierunkowy zosta\u0142 podw\u00f3jnie klikni\u0119ty");
        jComponent2.add(jCheckBox5);
        jCheckBox5.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                GeneralSettings.this.getState(itemEvent, "Automatyczne chodzenie zosta\u0142o ");
            }
        });
        final JCheckBox jCheckBox6 = SettingsComponentFactory.createSettingsToggle("move.continuous", false, "Ci\u0105g\u0142y ruch", "Zmieniaj mapy i przechod\u017a przez portale bez zatrzymywania si\u0119");
        jCheckBox6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new MoveContinuousAction().sendAction(jCheckBox6.isSelected());
            }
        });
        WtWindowManager.getInstance().registerSettingChangeListener("move.continuous", new SettingChangeListener(){

            @Override
            public void changed(String string) {
                jCheckBox6.setSelected(Boolean.parseBoolean(string));
            }
        });
        jComponent3.add(jCheckBox6);
        JCheckBox jCheckBox7 = SettingsComponentFactory.createSettingsToggle("ui.msg_blink", true, "Migaj przy wiadomo\u015bci na kanale prywatnym", "Karta kana\u0142u czatu miga w wiadomo\u015bci, gdy nie jest skoncentrowana");
        jComponent3.add(jCheckBox7);
        JCheckBox jCheckBox8 = SettingsComponentFactory.createSettingsToggle("ui.msg_sound", true, "Powiadomienie d\u017awi\u0119kowe o prywatnej wiadomo\u015bci", "Odtwarzaj d\u017awi\u0119k dla kana\u0142u wiadomo\u015bci osobistych, gdy nie jest skoncentrowany");
        jComponent3.add(jCheckBox8);
        JComponent jComponent5 = SBoxLayout.createContainer(false, n);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Rozmiar Klienta");
        Style style = StyleUtil.getStyle();
        if (style != null) {
            jComponent5.setBackground(style.getPlainColor());
            titledBorder.setTitleColor(style.getForeground());
        }
        jComponent5.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(n, n, n, n)));
        JCheckBox jCheckBox9 = SettingsComponentFactory.createSettingsToggle(DIMENSIONS_PROPERTY, true, "Zapisz rozmiar", "Przywr\u00f3\u0107 szeroko\u015b\u0107, wysoko\u015b\u0107 i maksymalizuj klienta podczas przysz\u0142ych sesji");
        jComponent5.add(jCheckBox9);
        JButton jButton = new JButton("Zresetuj");
        jButton.setToolTipText("Zresetuj szeroko\u015b\u0107 i wysoko\u015b\u0107 klienta do domy\u015blnych wymiar\u00f3w");
        jButton.setActionCommand("reset_dimensions");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralSettings.this.resetClientDimensions();
            }
        });
        jButton.setAlignmentX(1.0f);
        jComponent5.add(jButton);
        jComponent3.add((Component)jComponent5, (Object)SLayout.EXPAND_X);
    }

    JComponent getComponent() {
        return this.page;
    }

    private void getState(ItemEvent itemEvent, String string) {
        boolean bl = itemEvent.getStateChange() == 1;
        String string2 = bl ? "w\u0142\u0105czone" : "wy\u0142\u0105czone";
        String string3 = string + string2 + ".";
        ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", string3, NotificationType.CLIENT));
    }

    private void resetClientDimensions() {
        j2DClient j2DClient2 = j2DClient.get();
        j2DClient2.resetClientDimensions();
    }

    private static enum MovementKeyOption {
        ARROWS("arrows", "strza\u0142ki"),
        WASD("wasd", "WASD");

        private final String propertyValue;
        private final String label;

        private MovementKeyOption(String string2, String string3) {
            this.propertyValue = string2;
            this.label = string3;
        }

        String getPropertyValue() {
            return this.propertyValue;
        }

        String getLabel() {
            return this.label;
        }

        public String toString() {
            return this.label;
        }

        static MovementKeyOption fromProperty(String string) {
            for (MovementKeyOption movementKeyOption : MovementKeyOption.values()) {
                if (!movementKeyOption.propertyValue.equalsIgnoreCase(string)) continue;
                return movementKeyOption;
            }
            return ARROWS;
        }
    }
}

