/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.settings;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.gui.chatlog.EventLine;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.sound.facade.SoundGroup;
import games.stendhal.client.sound.facade.Time;
import games.stendhal.common.NotificationType;
import games.stendhal.common.math.Numeric;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class SoundSettings {
    private static final String SOUND_PROPERTY = "sound.play";
    private static final String VOLUME_PROPERTY = "sound.volume.";
    private static final String DEVICE_PROPERTY = "sound.device";
    private static final String DEFAULT_DEVICE = "auto - rekomendowane";
    private final JComponent page;
    private List<JComponent> sliderComponents = new ArrayList<JComponent>(14);

    SoundSettings() {
        int n = 5;
        this.page = SBoxLayout.createContainer(false, n);
        this.page.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        JComponent jComponent = SBoxLayout.createContainer(true, n);
        JComponent jComponent2 = SBoxLayout.createContainer(false, n);
        JComponent jComponent3 = SBoxLayout.createContainer(false, n);
        jComponent.add((Component)jComponent2, (Object)SLayout.EXPAND_X);
        jComponent.add((Component)jComponent3, (Object)SLayout.EXPAND_X);
        this.page.add((Component)jComponent, (Object)SLayout.EXPAND_X);
        JCheckBox jCheckBox = new JCheckBox("Odtw\u00f3rz d\u017awi\u0119ki");
        boolean bl = WtWindowManager.getInstance().getPropertyBoolean(SOUND_PROPERTY, true);
        jCheckBox.setSelected(bl);
        jCheckBox.addItemListener(new MuteListener());
        jComponent2.add(jCheckBox);
        JComponent jComponent4 = SBoxLayout.createContainer(true, n);
        JLabel jLabel = new JLabel("Urz\u0105dzenie d\u017awi\u0119ku:");
        jComponent4.add(jLabel);
        JComponent jComponent5 = this.createDeviceSelector();
        jComponent4.add(jComponent5);
        jComponent5.setToolTipText("<html>Wyj\u015bciowe urz\u0105dzenie d\u017awi\u0119ku. <b>auto</b> powinno dzia\u0142a\u0107 u wi\u0119kszo\u015bci os\u00f3b,<br>ale wypr\u00f3buj inne je\u017celi nie mo\u017cesz otrzyma\u0107 zadowalaj\u0105cego d\u017awi\u0119ku</html>");
        this.sliderComponents.add(jLabel);
        this.sliderComponents.add(jComponent5);
        jComponent2.add(jComponent4);
        JComponent jComponent6 = SBoxLayout.createContainer(true, n);
        jComponent2.add((Component)jComponent6, (Object)SLayout.EXPAND_X);
        JLabel jLabel2 = new JLabel("G\u0142\u00f3wny");
        jComponent6.add(jLabel2);
        SBoxLayout.addSpring(jComponent6);
        JSlider jSlider = this.createMasterVolumeSlider();
        jSlider.setToolTipText("G\u0142o\u015bno\u015b\u0107 wszystki kana\u0142\u00f3w d\u017awi\u0119ku");
        jComponent6.add(jSlider);
        this.sliderComponents.add(jLabel2);
        this.sliderComponents.add(jSlider);
        jComponent6 = SBoxLayout.createContainer(true, n);
        jComponent2.add((Component)jComponent6, (Object)SLayout.EXPAND_X);
        jLabel2 = new JLabel("GUI");
        jComponent6.add(jLabel2);
        SBoxLayout.addSpring(jComponent6);
        JSlider jSlider2 = this.createVolumeSlider("gui");
        jSlider2.setToolTipText("G\u0142o\u015bno\u015b\u0107 interaktywnych operacji jak zamykanie okien");
        jComponent6.add(jSlider2);
        this.sliderComponents.add(jLabel2);
        this.sliderComponents.add(jSlider2);
        jComponent6 = SBoxLayout.createContainer(true, n);
        jComponent2.add((Component)jComponent6, (Object)SLayout.EXPAND_X);
        jLabel2 = new JLabel("Efekty");
        jComponent6.add(jLabel2);
        SBoxLayout.addSpring(jComponent6);
        JSlider jSlider3 = this.createVolumeSlider("sfx");
        jSlider3.setToolTipText("G\u0142o\u015bno\u015b\u0107 walki i inne efekty");
        jComponent6.add(jSlider3);
        this.sliderComponents.add(jLabel2);
        this.sliderComponents.add(jSlider3);
        jComponent6 = SBoxLayout.createContainer(true, n);
        jComponent2.add((Component)jComponent6, (Object)SLayout.EXPAND_X);
        jLabel2 = new JLabel("Potwory");
        jComponent6.add(jLabel2);
        SBoxLayout.addSpring(jComponent6);
        JSlider jSlider4 = this.createVolumeSlider("creature");
        jSlider4.setToolTipText("G\u0142o\u015bno\u015b\u0107 potwor\u00f3w");
        jComponent6.add(jSlider4);
        this.sliderComponents.add(jLabel2);
        this.sliderComponents.add(jSlider4);
        jComponent6 = SBoxLayout.createContainer(true, n);
        jComponent2.add((Component)jComponent6, (Object)SLayout.EXPAND_X);
        jLabel2 = new JLabel("Otoczenie");
        jComponent6.add(jLabel2);
        SBoxLayout.addSpring(jComponent6);
        JSlider jSlider5 = this.createVolumeSlider("ambient");
        jComponent6.add(jSlider5);
        this.sliderComponents.add(jLabel2);
        this.sliderComponents.add(jSlider5);
        jComponent6 = SBoxLayout.createContainer(true, n);
        jComponent2.add((Component)jComponent6, (Object)SLayout.EXPAND_X);
        jLabel2 = new JLabel("Muzyka");
        jComponent6.add(jLabel2);
        SBoxLayout.addSpring(jComponent6);
        JSlider jSlider6 = this.createVolumeSlider("music");
        jSlider6.setToolTipText("G\u0142o\u015bno\u015b\u0107 d\u017awi\u0119ku");
        jComponent6.add(jSlider6);
        this.sliderComponents.add(jLabel2);
        this.sliderComponents.add(jSlider6);
        for (JComponent jComponent7 : this.sliderComponents) {
            jComponent7.setEnabled(bl);
        }
    }

    JComponent getComponent() {
        return this.page;
    }

    private JComponent createDeviceSelector() {
        String string2;
        final JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(DEFAULT_DEVICE);
        for (String string2 : ClientSingletonRepository.getSound().getDeviceNames()) {
            jComboBox.addItem(string2);
        }
        final WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        string2 = wtWindowManager.getProperty(DEVICE_PROPERTY, DEFAULT_DEVICE);
        jComboBox.setSelectedItem(string2);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = jComboBox.getSelectedItem();
                wtWindowManager.setProperty(SoundSettings.DEVICE_PROPERTY, object != null ? object.toString() : SoundSettings.DEFAULT_DEVICE);
                wtWindowManager.save();
                String string = "Zmiana urz\u0105dzenia d\u017awi\u0119ku zadzia\u0142a dopiero przy kolejnym w\u0142\u0105czeniu gry.";
                ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", string, NotificationType.CLIENT));
            }
        });
        return jComboBox;
    }

    private JSlider createMasterVolumeSlider() {
        JSlider jSlider = new JSlider(0, 100);
        float f = ClientSingletonRepository.getSound().getVolume();
        jSlider.setValue(Numeric.floatToInt(f, 100.0f));
        jSlider.addChangeListener(new MasterVolumeListener());
        return jSlider;
    }

    private JSlider createVolumeSlider(String string) {
        JSlider jSlider = new JSlider(0, 100);
        SoundGroup soundGroup = ClientSingletonRepository.getSound().getGroup(string);
        jSlider.setValue(Numeric.floatToInt(soundGroup.getVolume(), 100.0f));
        jSlider.addChangeListener(new ChannelChangeListener(string, soundGroup));
        return jSlider;
    }

    private static class ChannelChangeListener
    implements ChangeListener {
        private final SoundGroup group;
        private final String groupName;

        public ChannelChangeListener(String string, SoundGroup soundGroup) {
            this.group = soundGroup;
            this.groupName = string;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            int n = jSlider.getValue();
            this.group.changeVolume(Numeric.intToFloat(n, 100.0f));
            WtWindowManager.getInstance().setProperty(SoundSettings.VOLUME_PROPERTY + this.groupName, Integer.toString(n));
        }
    }

    private static class MasterVolumeListener
    implements ChangeListener {
        private MasterVolumeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            int n = jSlider.getValue();
            ClientSingletonRepository.getSound().changeVolume(Numeric.intToFloat(n, 100.0f));
            WtWindowManager.getInstance().setProperty("sound.volume.master", Integer.toString(n));
        }
    }

    private class MuteListener
    implements ItemListener {
        private MuteListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = itemEvent.getStateChange() == 1;
            WtWindowManager.getInstance().setProperty(SoundSettings.SOUND_PROPERTY, Boolean.toString(bl));
            ClientSingletonRepository.getSound().mute(!bl, true, new Time(2L, Time.Unit.SEC));
            for (JComponent jComponent : SoundSettings.this.sliderComponents) {
                jComponent.setEnabled(bl);
            }
        }
    }
}

