/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.stats;

import games.stendhal.client.entity.StatusID;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.gui.stats.HPIndicator;
import games.stendhal.client.gui.stats.KarmaIndicator;
import games.stendhal.client.gui.stats.ManaIndicator;
import games.stendhal.client.gui.stats.StatusIconPanel;
import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.sprite.DataLoader;
import games.stendhal.common.constants.CurrencyReform;
import games.stendhal.common.constants.Testing;
import games.stendhal.common.grammar.Grammar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class StatsPanel
extends JPanel {
    private static final long serialVersionUID = -353271026575752035L;
    private final StatLabel hpLabel;
    private final StatLabel atkLabel;
    private final StatLabel defLabel;
    private final StatLabel ratkLabel;
    private final StatLabel miningLabel;
    private final StatLabel xpLabel;
    private final StatLabel levelLabel;
    private final StatLabel capacityLabel;
    private final HPIndicator hpBar;
    private final StatusIconPanel statusIcons;
    private final KarmaIndicator karmaIndicator;
    private final ManaIndicator manaIndicator;
    private final MoneyPanel moneyPanel;
    private final Color defaultCapacityColor;

    StatsPanel() {
        this.setLayout(new SBoxLayout(false));
        this.statusIcons = new StatusIconPanel();
        this.add(this.statusIcons);
        this.karmaIndicator = KarmaIndicator.create();
        this.karmaIndicator.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.add((Component)this.karmaIndicator, (Object)SLayout.EXPAND_X);
        this.manaIndicator = ManaIndicator.create();
        this.manaIndicator.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.manaIndicator.setToolTipText("Mana");
        this.add((Component)this.manaIndicator, (Object)SLayout.EXPAND_X);
        this.hpLabel = new StatLabel();
        this.add((Component)this.hpLabel, (Object)SLayout.EXPAND_X);
        this.hpBar = new HPIndicator();
        this.hpBar.setPreferredSize(new Dimension(0, 10));
        this.hpBar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.add((Component)this.hpBar, (Object)SLayout.EXPAND_X);
        this.toggleHPBar(WtWindowManager.getInstance().getPropertyBoolean("ui.hp_bar", true));
        this.atkLabel = new StatLabel();
        this.add((Component)this.atkLabel, (Object)SLayout.EXPAND_X);
        this.defLabel = new StatLabel();
        this.add((Component)this.defLabel, (Object)SLayout.EXPAND_X);
        this.ratkLabel = new StatLabel();
        this.add((Component)this.ratkLabel, (Object)SLayout.EXPAND_X);
        this.ratkLabel.setVisible(false);
        this.miningLabel = new StatLabel();
        this.add((Component)this.miningLabel, (Object)SLayout.EXPAND_X);
        this.miningLabel.setVisible(false);
        this.xpLabel = new StatLabel();
        this.add((Component)this.xpLabel, (Object)SLayout.EXPAND_X);
        this.levelLabel = new StatLabel();
        this.levelLabel.setToolTipText("Oczekiwanie na dane do\u015bwiadczenia");
        this.add((Component)this.levelLabel, (Object)SLayout.EXPAND_X);
        this.moneyPanel = new MoneyPanel();
        this.add((Component)this.moneyPanel, (Object)SLayout.EXPAND_X);
        this.capacityLabel = new StatLabel();
        this.add((Component)this.capacityLabel, (Object)SLayout.EXPAND_X);
        this.capacityLabel.setVisible(false);
        this.defaultCapacityColor = this.capacityLabel.getForeground();
    }

    void setHP(String string) {
        this.hpLabel.setText(string);
    }

    void setHPBar(int n, int n2) {
        this.hpBar.setHP(n, n2);
    }

    void toggleHPBar(boolean bl) {
        this.hpBar.setVisible(bl);
    }

    void setAtk(String string) {
        this.atkLabel.setText(string);
    }

    void setDef(String string) {
        this.defLabel.setText(string);
    }

    void setRatk(String string) {
        if (!this.ratkLabel.isVisible()) {
            this.ratkLabel.setVisible(true);
        }
        this.ratkLabel.setText(string);
    }

    void setMining(String string) {
        if (!this.miningLabel.isVisible()) {
            this.miningLabel.setVisible(true);
        }
        this.miningLabel.setText(string);
    }

    void setXP(String string) {
        this.xpLabel.setText(string);
    }

    void setKarma(double d) {
        this.karmaIndicator.setValue(d);
    }

    void setMana(double d) {
        this.manaIndicator.setMana(d);
    }

    void setBaseMana(double d) {
        this.manaIndicator.setBaseMana(d);
    }

    void setLevel(String string, String string2) {
        this.levelLabel.setText(string);
        this.levelLabel.setToolTipText(string2);
    }

    void setMoney(int n, int n2, int n3, int n4) {
        this.moneyPanel.setMoney(n, n2, n3, n4);
    }

    void setCapacity(String string, double d, String string2) {
        if (Testing.WEIGHT) {
            this.capacityLabel.setVisible(true);
        }
        this.capacityLabel.setText(string);
        this.capacityLabel.setToolTipText(string2);
        if (d >= 1.0) {
            this.capacityLabel.setForeground(Color.RED);
        } else if (d >= 0.9) {
            this.capacityLabel.setForeground(new Color(0xCC6600));
        } else if (d >= 0.75) {
            this.capacityLabel.setForeground(new Color(0xCC9900));
        } else if (this.defaultCapacityColor != null) {
            this.capacityLabel.setForeground(this.defaultCapacityColor);
        }
    }

    void setEating(boolean bl) {
        this.statusIcons.setEating(bl);
    }

    void setChoking(boolean bl) {
        this.statusIcons.setChoking(bl);
    }

    void setStatus(StatusID statusID, boolean bl) {
        this.statusIcons.setStatus(statusID, bl);
    }

    void resetStatuses() {
        this.statusIcons.resetStatuses();
    }

    void setAway(String string) {
        this.statusIcons.setAway(string);
    }

    void setGrumpy(String string) {
        this.statusIcons.setGrumpy(string);
    }

    private static class MoneyPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final JLabel titleLabel;
        private final CoinLabel goldLabel;
        private final CoinLabel silverLabel;
        private final CoinLabel copperLabel;
        private final CoinLabel legacyLabel;

        MoneyPanel() {
            this.setOpaque(false);
            this.setBorder(null);
            this.setLayout(new FlowLayout(0, 0, 0));
            Style style = StyleUtil.getStyle();
            this.titleLabel = new JLabel("Pieni\u0105dze:");
            this.titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
            if (style != null) {
                this.titleLabel.setForeground(style.getForeground());
            }
            this.add(this.titleLabel);
            if (CurrencyReform.useReformedCurrency()) {
                this.goldLabel = new CoinLabel("dukat", style, "data/gui/goldencoin.png");
                this.goldLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
                this.add(this.goldLabel);
                this.silverLabel = new CoinLabel("talar", style, "data/gui/silvercoin.png");
                this.silverLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
                this.add(this.silverLabel);
                this.copperLabel = new CoinLabel("miedziak", style, "data/gui/coppercoin.png");
                this.add(this.copperLabel);
                this.legacyLabel = null;
            } else {
                this.goldLabel = null;
                this.silverLabel = null;
                this.copperLabel = null;
                this.legacyLabel = new CoinLabel("money", style, "data/gui/goldencoin.png");
                this.add(this.legacyLabel);
            }
        }

        void setMoney(int n, int n2, int n3, int n4) {
            if (!CurrencyReform.useReformedCurrency()) {
                if (this.legacyLabel != null) {
                    this.legacyLabel.setAmount(n4);
                    this.legacyLabel.setToolTipText("\u0141\u0105cznie: " + n4 + " " + Grammar.polishQuantity("money", n4));
                }
                this.setToolTipText("\u0141\u0105cznie: " + n4 + " " + Grammar.polishQuantity("money", n4));
                return;
            }
            this.goldLabel.setAmount(n);
            this.silverLabel.setAmount(n2);
            this.copperLabel.setAmount(n3);
            StringBuilder stringBuilder = new StringBuilder("\u0141\u0105cznie: ");
            boolean bl = false;
            bl = this.appendPart(stringBuilder, n, "dukat", bl);
            bl = this.appendPart(stringBuilder, n2, "talar", bl);
            bl = this.appendPart(stringBuilder, n3, "miedziak", bl);
            if (!bl) {
                stringBuilder.append("0 ").append(Grammar.polishQuantity("miedziak", 0));
            }
            stringBuilder.append(" (" + n4 + " miedziak\u00f3w)");
            this.setToolTipText(stringBuilder.toString());
        }

        private boolean appendPart(StringBuilder stringBuilder, int n, String string, boolean bl) {
            if (n <= 0) {
                return bl;
            }
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(n).append(' ').append(Grammar.polishQuantity(string, n));
            return true;
        }

        private static class CoinLabel
        extends JLabel {
            private static final long serialVersionUID = 1L;
            private final String coinName;

            CoinLabel(String string, Style style, String ... stringArray) {
                super("0");
                this.coinName = string;
                this.setOpaque(false);
                this.setBorder(null);
                this.setCoinIcon(stringArray);
                this.setHorizontalTextPosition(2);
                this.setIconTextGap(4);
                if (style != null) {
                    this.setForeground(style.getForeground());
                }
            }

            void setAmount(int n) {
                this.setText(Integer.toString(n));
                this.setToolTipText(n + " " + Grammar.polishQuantity(this.coinName, n));
            }

            private void setCoinIcon(String ... stringArray) {
                if (stringArray == null) {
                    return;
                }
                for (String string : stringArray) {
                    URL uRL;
                    if (string == null || (uRL = DataLoader.getResource(string)) == null) continue;
                    this.setIcon(new ImageIcon(uRL));
                    return;
                }
            }
        }
    }

    private static class StatLabel
    extends JTextArea {
        public StatLabel() {
            this.setOpaque(false);
            this.setEditable(false);
            this.setFocusable(false);
            this.setWrapStyleWord(true);
            this.setLineWrap(true);
            Style style = StyleUtil.getStyle();
            if (style != null) {
                this.setForeground(style.getForeground());
            }
        }
    }
}

