/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.stats;

import games.stendhal.client.entity.StatusID;
import games.stendhal.client.gui.stats.StatsPanel;
import games.stendhal.common.Level;
import games.stendhal.common.MathHelper;
import games.stendhal.common.constants.CurrencyReform;
import games.stendhal.common.constants.Testing;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.SwingUtilities;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;
import org.apache.log4j.Logger;

public final class StatsPanelController {
    private static final String[] MONEY_SLOTS = new String[]{"bag", "lhand", "rhand", "pouch"};
    private static final int COPPER_PER_TALAR = 100;
    private static final int COPPER_PER_DUKAT = 10000;
    private static final String SPC = "\r\u00a0";
    private final StatsPanel panel;
    private static StatsPanelController instance;
    private final HashMap<String, HashMap<String, CoinStack>> money = new HashMap();
    private int level;
    private int xp;
    private int hp;
    private int maxhp;
    private int maxhpModified;
    private int atk;
    private int atkxp;
    private int weaponAtk;
    private int def;
    private int defxp;
    private int itemDef;
    private int ratk;
    private int ratkxp;
    private int weaponRatk;
    private int mining;
    private int miningxp;
    private int mana;
    private int baseMana;
    private double capacity;
    private double baseCapacity;

    private StatsPanelController() {
        this.panel = new StatsPanel();
    }

    public static synchronized StatsPanelController get() {
        if (instance == null) {
            instance = new StatsPanelController();
        }
        return instance;
    }

    public StatsPanel getComponent() {
        return this.panel;
    }

    public void registerListeners(PropertyChangeSupport propertyChangeSupport) {
        PropertyChangeListener propertyChangeListener = new HPChangeListener();
        this.addPropertyChangeListenerWithModifiedSupport(propertyChangeSupport, "base_hp", propertyChangeListener);
        this.addPropertyChangeListenerWithModifiedSupport(propertyChangeSupport, "hp", propertyChangeListener);
        propertyChangeListener = new ATKChangeListener();
        this.addPropertyChangeListenerWithModifiedSupport(propertyChangeSupport, "atk", propertyChangeListener);
        propertyChangeSupport.addPropertyChangeListener("atk_xp", propertyChangeListener);
        propertyChangeListener = new DEFChangeListener();
        this.addPropertyChangeListenerWithModifiedSupport(propertyChangeSupport, "def", propertyChangeListener);
        propertyChangeSupport.addPropertyChangeListener("def_xp", propertyChangeListener);
        propertyChangeListener = new RATKChangeListener();
        this.addPropertyChangeListenerWithModifiedSupport(propertyChangeSupport, "ratk", propertyChangeListener);
        propertyChangeSupport.addPropertyChangeListener("ratk_xp", propertyChangeListener);
        if (System.getProperty("pol.miningstat") != null) {
            propertyChangeListener = new MININGChangeListener();
            this.addPropertyChangeListenerWithModifiedSupport(propertyChangeSupport, "mining", propertyChangeListener);
            propertyChangeSupport.addPropertyChangeListener("mining_xp", propertyChangeListener);
        }
        propertyChangeListener = new XPChangeListener();
        propertyChangeSupport.addPropertyChangeListener("xp", propertyChangeListener);
        propertyChangeListener = new LevelChangeListener();
        this.addPropertyChangeListenerWithModifiedSupport(propertyChangeSupport, "level", propertyChangeListener);
        propertyChangeListener = new WeaponChangeListener();
        propertyChangeSupport.addPropertyChangeListener("atk_item", propertyChangeListener);
        propertyChangeListener = new ArmorChangeListener();
        propertyChangeSupport.addPropertyChangeListener("def_item", propertyChangeListener);
        propertyChangeListener = new RangedWeaponChangeListener();
        if (Testing.COMBAT) {
            propertyChangeSupport.addPropertyChangeListener("ratk_item", propertyChangeListener);
        } else {
            propertyChangeSupport.addPropertyChangeListener("atk_item", propertyChangeListener);
        }
        propertyChangeListener = new MoneyChangeListener();
        for (String string : MONEY_SLOTS) {
            propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
        }
        propertyChangeListener = new EatingChangeListener();
        propertyChangeSupport.addPropertyChangeListener("eating", propertyChangeListener);
        propertyChangeSupport.addPropertyChangeListener("choking", propertyChangeListener);
        propertyChangeListener = new StatusChangeListener();
        for (StatusID statusID : StatusID.values()) {
            propertyChangeSupport.addPropertyChangeListener(statusID.getAttribute(), propertyChangeListener);
        }
        propertyChangeListener = new AwayChangeListener();
        propertyChangeSupport.addPropertyChangeListener("away", propertyChangeListener);
        propertyChangeListener = new GrumpyChangeListener();
        propertyChangeSupport.addPropertyChangeListener("grumpy", propertyChangeListener);
        propertyChangeListener = new KarmaChangeListener();
        propertyChangeSupport.addPropertyChangeListener("karma", propertyChangeListener);
        propertyChangeListener = new ManaChangeListener();
        this.addPropertyChangeListenerWithModifiedSupport(propertyChangeSupport, "base_mana", propertyChangeListener);
        this.addPropertyChangeListenerWithModifiedSupport(propertyChangeSupport, "mana", propertyChangeListener);
        if (Testing.WEIGHT) {
            propertyChangeListener = new CapacityChangeListener();
            this.addPropertyChangeListenerWithModifiedSupport(propertyChangeSupport, "base_capacity", propertyChangeListener);
            this.addPropertyChangeListenerWithModifiedSupport(propertyChangeSupport, "capacity", propertyChangeListener);
        }
    }

    private void addPropertyChangeListenerWithModifiedSupport(PropertyChangeSupport propertyChangeSupport, String string, PropertyChangeListener propertyChangeListener) {
        propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
        propertyChangeSupport.addPropertyChangeListener("modified_" + string, propertyChangeListener);
    }

    private void updateLevel() {
        String string;
        boolean bl;
        int n = Level.getXP(this.level + 1);
        int n2 = Level.getXP(this.level);
        int n3 = n - this.xp;
        String string2 = n3 < 0 ? "\u2014" : Integer.toString(n3);
        final String string3 = "Poziom:\r\u00a0" + this.level + SPC + "(" + string2 + ")";
        boolean bl2 = n < 0;
        boolean bl3 = bl = n2 < 0 || n <= n2;
        if (bl2) {
            string = "Post\u0119p poziomu: 100% (osi\u0105gni\u0119to maksymalny poziom)";
        } else if (bl) {
            string = "Post\u0119p poziomu: \u2014 (brak danych o wymaganym do\u015bwiadczeniu)";
        } else {
            int n4 = Math.max(0, this.xp - n2);
            int n5 = n - n2;
            int n6 = MathHelper.clamp((int)Math.round((double)n4 * 100.0 / (double)n5), 0, 100);
            int n7 = Math.max(0, n3);
            string = String.format(Locale.ROOT, "Post\u0119p poziomu: %d%% (%d / %d PD). Do awansu: %d PD.", n6, n4, n5, n7);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatsPanelController.this.panel.setLevel(string3, string);
            }
        });
    }

    private void updateHP() {
        final int n = this.maxhpModified != 0 ? this.maxhpModified : this.maxhp;
        final String string = "PZ:\r\u00a0" + this.hp + "/" + n;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatsPanelController.this.panel.setHP(string);
                if (n > 0) {
                    StatsPanelController.this.panel.setHPBar(n, StatsPanelController.this.hp);
                }
            }
        });
    }

    private void updateAtk() {
        int n = Level.getXP(this.atk - 9) - this.atkxp;
        final String string = "ATK:\r\u00a0" + this.atk + "\u00d7" + (1 + this.weaponAtk) + SPC + "(" + n + ")";
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatsPanelController.this.panel.setAtk(string);
            }
        });
    }

    private void updateDef() {
        int n = Level.getXP(this.def - 9) - this.defxp;
        final String string = "OBR:\r\u00a0" + this.def + "\u00d7" + (1 + this.itemDef) + SPC + "(" + n + ")";
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatsPanelController.this.panel.setDef(string);
            }
        });
    }

    private void updateRatk() {
        if (!Testing.COMBAT) {
            return;
        }
        int n = Level.getXP(this.ratk - 9) - this.ratkxp;
        final String string = "STR:\r\u00a0" + this.ratk + "\u00d7" + (1 + this.weaponRatk) + SPC + "(" + n + ")";
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatsPanelController.this.panel.setRatk(string);
            }
        });
    }

    private void updateMining() {
        if (System.getProperty("pol.miningstat") != null) {
            return;
        }
        long l = Level.getXP(this.mining - 9) - this.miningxp;
        final String string = "G\u00f3rnictwo:\r\u00a0" + this.mining + SPC + "(" + l + ")";
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatsPanelController.this.panel.setMining(string);
            }
        });
    }

    public void toggleHPBar(boolean bl) {
        this.panel.toggleHPBar(bl);
    }

    private void addMoney(String string, RPObject rPObject) {
        int n;
        String string2;
        boolean bl;
        HashMap<String, CoinStack> hashMap = this.money.get(string);
        boolean bl2 = bl = hashMap != null;
        if (!bl) {
            hashMap = new HashMap();
        }
        if ((string2 = rPObject.get("id")) == null) {
            return;
        }
        CoinStack coinStack = hashMap.get(string2);
        CoinDescriptor coinDescriptor = this.identifyCoin(rPObject, coinStack != null ? coinStack.descriptor : null);
        if (coinDescriptor == null) {
            if (coinStack != null) {
                hashMap.remove(string2);
                if (hashMap.isEmpty()) {
                    this.money.remove(string);
                }
                this.updateMoney();
            }
            return;
        }
        int n2 = rPObject.has("quantity") ? rPObject.getInt("quantity") : (n = coinStack != null ? coinStack.quantity : 0);
        if (coinStack == null) {
            hashMap.put(string2, new CoinStack(coinDescriptor, n));
            if (!bl) {
                this.money.put(string, hashMap);
            }
        } else {
            coinStack.descriptor = coinDescriptor;
            coinStack.quantity = n;
        }
        this.updateMoney();
    }

    private void clearMoney() {
        this.money.clear();
        this.updateMoney();
    }

    private void removeMoney(String string, RPObject rPObject) {
        HashMap<String, CoinStack> hashMap = this.money.get(string);
        String string2 = rPObject.get("id");
        if (hashMap != null && string2 != null && hashMap.remove(string2) != null) {
            if (hashMap.isEmpty()) {
                this.money.remove(string);
            }
            this.updateMoney();
        }
    }

    private void updateMoney() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (HashMap<String, CoinStack> hashMap : this.money.values()) {
            for (CoinStack coinStack : hashMap.values()) {
                int n5 = coinStack.quantity;
                if (n5 <= 0) continue;
                CoinDescriptor coinDescriptor = coinStack.descriptor;
                switch (coinDescriptor.bucket) {
                    case DUKAT: {
                        n += n5;
                        break;
                    }
                    case TALAR: {
                        n2 += n5;
                        break;
                    }
                    default: {
                        n3 += n5;
                    }
                }
                n4 += n5 * coinDescriptor.copperValue;
            }
        }
        if (!CurrencyReform.useReformedCurrency()) {
            n = 0;
            n2 = 0;
            n3 = n4;
        }
        final int n6 = n;
        final int n7 = n2;
        final int n8 = n3;
        final int n9 = n4;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatsPanelController.this.panel.setMoney(n6, n7, n8, n9);
            }
        });
    }

    private CoinDescriptor identifyCoin(RPObject rPObject, CoinDescriptor coinDescriptor) {
        String string = this.resolveCoinName(rPObject);
        if (string != null) {
            if ("dukat".equals(string = string.toLowerCase(Locale.ENGLISH))) {
                return CoinDescriptor.dukat();
            }
            if ("talar".equals(string)) {
                return CoinDescriptor.talar();
            }
            if ("miedziak".equals(string) || "money".equals(string)) {
                return CoinDescriptor.copper();
            }
            return null;
        }
        if (rPObject.has("value")) {
            int n = rPObject.getInt("value");
            if (n == 10000) {
                return CoinDescriptor.dukat();
            }
            if (n == 100) {
                return CoinDescriptor.talar();
            }
            if (n > 0) {
                return CoinDescriptor.customCopper(n);
            }
        }
        return coinDescriptor;
    }

    private String resolveCoinName(RPObject rPObject) {
        String string = rPObject.get("name");
        if (string != null) {
            return string;
        }
        string = rPObject.get("subclass");
        if (string != null) {
            return string;
        }
        return rPObject.get("class");
    }

    private void updateCapacity() {
        String string;
        double d;
        String string2;
        double d2 = this.capacity;
        double d3 = this.baseCapacity;
        if (d3 <= 0.0) {
            string2 = "Ud\u017awig:\r\u00a0" + StatsPanelController.formatWeight(d2) + SPC + "/" + SPC + "\u2014 kg";
            d = 0.0;
            string = "Brak danych o maksymalnym ud\u017awigu";
        } else {
            string2 = "Ud\u017awig:\r\u00a0" + StatsPanelController.formatWeight(d2) + SPC + "/" + SPC + StatsPanelController.formatWeight(d3) + " kg";
            double d4 = d2 / d3;
            d = MathHelper.clamp((int)Math.round(d4 * 100.0), 0, 1);
            int n = MathHelper.clamp((int)Math.round(d * 100.0), 0, 100);
            double d5 = Math.max(0.0, d3 - d2);
            string = d >= 1.0 ? String.format(Locale.ROOT, "Przeci\u0105\u017cenie! Zu\u017cyto %.1f / %.1f kg (%d%%).", d2, d3, n) : (d >= 0.9 ? String.format(Locale.ROOT, "Uwaga: zu\u017cyto %.1f / %.1f kg (%d%%). Pozosta\u0142o %.1f kg.", d2, d3, n, d5) : String.format(Locale.ROOT, "Ud\u017awig: %.1f / %.1f kg (%d%%). Pozosta\u0142o %.1f kg.", d2, d3, n, d5));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatsPanelController.this.panel.setCapacity(string2, d, string);
            }
        });
    }

    private static String formatWeight(double d) {
        double d2 = Math.rint(d);
        if (Math.abs(d - d2) < 0.01) {
            return Integer.toString((int)Math.round(d2));
        }
        return String.format(Locale.ROOT, "%.1f", d);
    }

    private class MoneyChangeListener
    implements PropertyChangeListener {
        private MoneyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                StatsPanelController.this.clearMoney();
                return;
            }
            RPSlot rPSlot = (RPSlot)propertyChangeEvent.getOldValue();
            if (rPSlot != null) {
                for (RPObject rPObject : rPSlot) {
                    StatsPanelController.this.removeMoney(rPSlot.getName(), rPObject);
                }
            }
            if ((rPSlot = (RPSlot)propertyChangeEvent.getNewValue()) != null) {
                for (RPObject rPObject : rPSlot) {
                    StatsPanelController.this.addMoney(rPSlot.getName(), rPObject);
                }
            }
        }
    }

    private class GrumpyChangeListener
    implements PropertyChangeListener {
        private GrumpyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            Object object2 = null;
            if (propertyChangeEvent != null && (object = propertyChangeEvent.getNewValue()) != null) {
                object2 = object.toString();
            }
            object = object2;
            SwingUtilities.invokeLater(new Runnable((String)object){
                final /* synthetic */ String val$message;
                {
                    this.val$message = string;
                }

                @Override
                public void run() {
                    StatsPanelController.this.panel.setGrumpy(this.val$message);
                }
            });
        }
    }

    private class ManaChangeListener
    implements PropertyChangeListener {
        private ManaChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            try {
                if (propertyChangeEvent.getPropertyName().endsWith("base_mana")) {
                    StatsPanelController.this.baseMana = Integer.parseInt((String)propertyChangeEvent.getNewValue());
                    StatsPanelController.this.panel.setBaseMana(StatsPanelController.this.baseMana);
                } else {
                    StatsPanelController.this.mana = Integer.parseInt((String)propertyChangeEvent.getNewValue());
                    StatsPanelController.this.panel.setMana(StatsPanelController.this.mana);
                }
            }
            catch (NumberFormatException numberFormatException) {
                Logger.getLogger(ManaChangeListener.class).error((Object)"Invalid mana value", (Throwable)numberFormatException);
            }
        }
    }

    private class KarmaChangeListener
    implements PropertyChangeListener {
        private KarmaChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            StatsPanelController.this.panel.setKarma(MathHelper.parseDouble((String)propertyChangeEvent.getNewValue()));
        }
    }

    private class AwayChangeListener
    implements PropertyChangeListener {
        private AwayChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            Object object2 = null;
            if (propertyChangeEvent != null && (object = propertyChangeEvent.getNewValue()) != null) {
                object2 = object.toString();
            }
            object = object2;
            SwingUtilities.invokeLater(new Runnable((String)object){
                final /* synthetic */ String val$message;
                {
                    this.val$message = string;
                }

                @Override
                public void run() {
                    StatsPanelController.this.panel.setAway(this.val$message);
                }
            });
        }
    }

    private class StatusChangeListener
    implements PropertyChangeListener {
        private StatusChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StatsPanelController.this.panel.resetStatuses();
                    }
                });
                return;
            }
            Object object = propertyChangeEvent.getNewValue();
            final StatusID statusID = StatusID.getStatusID(propertyChangeEvent.getPropertyName());
            final boolean bl = object != null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatsPanelController.this.panel.setStatus(statusID, bl);
                }
            });
        }
    }

    private class EatingChangeListener
    implements PropertyChangeListener {
        private EatingChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl;
            if (propertyChangeEvent == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StatsPanelController.this.panel.setEating(false);
                        StatsPanelController.this.panel.setChoking(false);
                    }
                });
                return;
            }
            boolean bl2 = bl = propertyChangeEvent.getNewValue() != null;
            if ("eating".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StatsPanelController.this.panel.setEating(bl);
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StatsPanelController.this.panel.setChoking(bl);
                    }
                });
            }
        }
    }

    private class RangedWeaponChangeListener
    implements PropertyChangeListener {
        private RangedWeaponChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            if (Testing.COMBAT) {
                StatsPanelController.this.weaponRatk = Integer.parseInt((String)propertyChangeEvent.getNewValue());
                StatsPanelController.this.updateRatk();
            } else {
                StatsPanelController.this.weaponAtk = Integer.parseInt((String)propertyChangeEvent.getNewValue());
                StatsPanelController.this.updateAtk();
            }
        }
    }

    private class ArmorChangeListener
    implements PropertyChangeListener {
        private ArmorChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            StatsPanelController.this.itemDef = Integer.parseInt((String)propertyChangeEvent.getNewValue());
            StatsPanelController.this.updateDef();
        }
    }

    private class WeaponChangeListener
    implements PropertyChangeListener {
        private WeaponChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            StatsPanelController.this.weaponAtk = Integer.parseInt((String)propertyChangeEvent.getNewValue());
            StatsPanelController.this.updateAtk();
        }
    }

    private class LevelChangeListener
    implements PropertyChangeListener {
        private LevelChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("level")) {
                StatsPanelController.this.level = Integer.parseInt((String)propertyChangeEvent.getNewValue());
            }
            StatsPanelController.this.updateLevel();
        }
    }

    private class XPChangeListener
    implements PropertyChangeListener {
        private XPChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            StatsPanelController.this.xp = Integer.parseInt((String)propertyChangeEvent.getNewValue());
            StatsPanelController.this.updateLevel();
            final String string = "PD:\r\u00a0" + StatsPanelController.this.xp;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatsPanelController.this.panel.setXP(string);
                }
            });
        }
    }

    private class CapacityChangeListener
    implements PropertyChangeListener {
        private CapacityChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("base_capacity")) {
                StatsPanelController.this.baseCapacity = Double.parseDouble((String)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName().equals("capacity")) {
                StatsPanelController.this.capacity = Double.parseDouble((String)propertyChangeEvent.getNewValue());
            }
            StatsPanelController.this.updateCapacity();
        }
    }

    private class MININGChangeListener
    implements PropertyChangeListener {
        private MININGChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("mining_xp")) {
                StatsPanelController.this.miningxp = Integer.parseInt((String)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName().equals("mining")) {
                StatsPanelController.this.mining = Integer.parseInt((String)propertyChangeEvent.getNewValue());
            }
            StatsPanelController.this.updateMining();
        }
    }

    private class RATKChangeListener
    implements PropertyChangeListener {
        private RATKChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            if ("ratk_xp".equals(propertyChangeEvent.getPropertyName())) {
                StatsPanelController.this.ratkxp = Integer.parseInt((String)propertyChangeEvent.getNewValue());
            } else if ("ratk".equals(propertyChangeEvent.getPropertyName())) {
                StatsPanelController.this.ratk = Integer.parseInt((String)propertyChangeEvent.getNewValue());
            }
            StatsPanelController.this.updateRatk();
        }
    }

    private class DEFChangeListener
    implements PropertyChangeListener {
        private DEFChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            if ("def_xp".equals(propertyChangeEvent.getPropertyName())) {
                StatsPanelController.this.defxp = Integer.parseInt((String)propertyChangeEvent.getNewValue());
            } else if ("def".equals(propertyChangeEvent.getPropertyName())) {
                StatsPanelController.this.def = Integer.parseInt((String)propertyChangeEvent.getNewValue());
            }
            StatsPanelController.this.updateDef();
        }
    }

    private class ATKChangeListener
    implements PropertyChangeListener {
        private ATKChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            if ("atk_xp".equals(propertyChangeEvent.getPropertyName())) {
                StatsPanelController.this.atkxp = Integer.parseInt((String)propertyChangeEvent.getNewValue());
            } else if ("atk".equals(propertyChangeEvent.getPropertyName())) {
                StatsPanelController.this.atk = Integer.parseInt((String)propertyChangeEvent.getNewValue());
            }
            StatsPanelController.this.updateAtk();
        }
    }

    private static class CoinStack {
        private CoinDescriptor descriptor;
        private int quantity;

        CoinStack(CoinDescriptor coinDescriptor, int n) {
            this.descriptor = coinDescriptor;
            this.quantity = n;
        }
    }

    private static class CoinDescriptor {
        private static final CoinDescriptor DUKAT = new CoinDescriptor(Bucket.DUKAT, 10000);
        private static final CoinDescriptor TALAR = new CoinDescriptor(Bucket.TALAR, 100);
        private static final CoinDescriptor COPPER = new CoinDescriptor(Bucket.COPPER, 1);
        final Bucket bucket;
        final int copperValue;

        private CoinDescriptor(Bucket bucket, int n) {
            this.bucket = bucket;
            this.copperValue = n;
        }

        static CoinDescriptor dukat() {
            return DUKAT;
        }

        static CoinDescriptor talar() {
            return TALAR;
        }

        static CoinDescriptor copper() {
            return COPPER;
        }

        static CoinDescriptor customCopper(int n) {
            return new CoinDescriptor(Bucket.COPPER, n);
        }

        private static enum Bucket {
            DUKAT,
            TALAR,
            COPPER;

        }
    }

    private class HPChangeListener
    implements PropertyChangeListener {
        private HPChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            String string = (String)propertyChangeEvent.getNewValue();
            if (propertyChangeEvent.getPropertyName().equals("base_hp")) {
                StatsPanelController.this.maxhp = Integer.parseInt(string);
            } else if (propertyChangeEvent.getPropertyName().equals("base_hp_modified")) {
                if (string != null) {
                    StatsPanelController.this.maxhpModified = Integer.parseInt(string);
                } else {
                    StatsPanelController.this.maxhpModified = 0;
                }
            } else if (propertyChangeEvent.getPropertyName().equals("hp")) {
                StatsPanelController.this.hp = Integer.parseInt(string);
            }
            StatsPanelController.this.updateHP();
        }
    }
}

