/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.stats;

import games.stendhal.client.entity.StatusID;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.stats.AnimatedIcon;
import games.stendhal.client.sprite.DataLoader;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;

class StatusIconPanel
extends JComponent {
    private static final Pattern BREAK_PATTERN = Pattern.compile("(?is)<br\\s*/?>");
    private static final Pattern TAG_PATTERN = Pattern.compile("(?is)<[^>]+>");
    private static final String iconFolder = "data/sprites/status/panel/";
    private static final ImageIcon eatingIcon = new ImageIcon(DataLoader.getResource("data/sprites/ideas/eat.png"));
    private static final ImageIcon chokingIcon = new ImageIcon(DataLoader.getResource("data/sprites/ideas/choking.png"));
    private static final Sprite awaySprite;
    private static final Sprite grumpySprite;
    final JLabel eating;
    final JLabel choking;
    final AnimatedIcon away;
    final AnimatedIcon grumpy;
    private final Map<StatusID, JLabel> statusIDMap;
    private final List<String> activeTooltips;
    private String currentTooltipHtml;
    private String currentTooltipPlain;
    private String awayMessage;
    private String grumpyMessage;

    protected StatusIconPanel() {
        this.setLayout(new SBoxLayout(true));
        this.setOpaque(false);
        this.eating = new JLabel(eatingIcon);
        this.eating.setToolTipText("Status: Jedzenie posi\u0142ku");
        this.eating.getAccessibleContext().setAccessibleDescription("Status: Jedzenie posi\u0142ku");
        this.add(this.eating);
        this.eating.setVisible(false);
        this.choking = new JLabel(chokingIcon);
        this.choking.setToolTipText("Status: Duszenie si\u0119");
        this.choking.getAccessibleContext().setAccessibleDescription("Status: Duszenie si\u0119");
        this.add(this.choking);
        this.choking.setVisible(false);
        this.away = new AnimatedIcon(awaySprite, 1000);
        this.add(this.away);
        this.away.setVisible(false);
        this.grumpy = new AnimatedIcon(grumpySprite, 500);
        this.add(this.grumpy);
        this.grumpy.setVisible(false);
        this.activeTooltips = new ArrayList<String>();
        this.statusIDMap = new EnumMap<StatusID, JLabel>(StatusID.class);
        this.addStatusIndicator(StatusID.CONFUSE, "confuse", "Status: Oszo\u0142omienie");
        this.addStatusIndicator(StatusID.POISON, "poison", "Status: Zatrucie");
        this.addStatusIndicator(StatusID.BLEED, "bleed", "Status: Krwawienie");
        this.addStatusIndicator(StatusID.SHOCK, "shock", "Status: Pora\u017cenie");
        this.addStatusIndicator(StatusID.ZOMBIE, "zombie", "Status: Przemiana w zombie");
        this.addStatusIndicator(StatusID.HEAVY, "heavy", "Status: Przeci\u0105\u017cenie");
        this.updatePanelTooltip();
    }

    private void addStatusIndicator(StatusID statusID, String string, String string2) {
        JLabel jLabel = this.createStatusIndicator(string, string2);
        this.statusIDMap.put(statusID, jLabel);
    }

    private JLabel createStatusIndicator(String string, String string2) {
        ImageIcon imageIcon = new ImageIcon(DataLoader.getResource(iconFolder + string + ".png"));
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setVisible(false);
        if (string2 != null && !string2.isEmpty()) {
            jLabel.setToolTipText(string2);
            jLabel.getAccessibleContext().setAccessibleDescription(string2);
        }
        this.add(jLabel);
        return jLabel;
    }

    private void updatePanelTooltip() {
        String string;
        Map.Entry<StatusID, JLabel> entry2;
        this.activeTooltips.clear();
        if (this.eating.isVisible()) {
            StatusIconPanel.addNormalizedTooltip(this.activeTooltips, this.eating.getToolTipText());
        }
        if (this.choking.isVisible()) {
            StatusIconPanel.addNormalizedTooltip(this.activeTooltips, this.choking.getToolTipText());
        }
        for (Map.Entry<StatusID, JLabel> entry2 : this.statusIDMap.entrySet()) {
            JLabel jLabel = entry2.getValue();
            if (!jLabel.isVisible()) continue;
            StatusIconPanel.addNormalizedTooltip(this.activeTooltips, jLabel.getToolTipText());
        }
        if (this.away.isVisible()) {
            StatusIconPanel.addNormalizedTooltip(this.activeTooltips, this.away.getToolTipText());
        }
        if (this.grumpy.isVisible()) {
            StatusIconPanel.addNormalizedTooltip(this.activeTooltips, this.grumpy.getToolTipText());
        }
        if (this.activeTooltips.isEmpty()) {
            if (this.currentTooltipHtml != null) {
                this.currentTooltipHtml = null;
                this.setToolTipText(null);
            }
            if (this.getAccessibleContext() != null && this.currentTooltipPlain != null) {
                this.currentTooltipPlain = null;
                this.getAccessibleContext().setAccessibleDescription(null);
            }
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("<html><b>Aktywne statusy:</b><br>");
        entry2 = new StringBuilder("Aktywne statusy: ");
        for (int i = 0; i < this.activeTooltips.size(); ++i) {
            if (i > 0) {
                stringBuilder.append("<br>");
                ((StringBuilder)((Object)entry2)).append("; ");
            }
            string = this.activeTooltips.get(i);
            stringBuilder.append(string.replace("\n", "<br>"));
            ((StringBuilder)((Object)entry2)).append(string.replace('\n', ' '));
        }
        stringBuilder.append("</html>");
        String string2 = stringBuilder.toString();
        if (!string2.equals(this.currentTooltipHtml)) {
            this.currentTooltipHtml = string2;
            this.setToolTipText(string2);
        }
        if (this.getAccessibleContext() != null && !(string = ((StringBuilder)((Object)entry2)).toString()).equals(this.currentTooltipPlain)) {
            this.currentTooltipPlain = string;
            this.getAccessibleContext().setAccessibleDescription(string);
        }
    }

    private static void addNormalizedTooltip(List<String> list, String string) {
        String string2 = StatusIconPanel.normalizeTooltip(string);
        if (string2 != null && !string2.isEmpty()) {
            list.add(string2);
        }
    }

    private static String normalizeTooltip(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        String string2 = string;
        string2 = BREAK_PATTERN.matcher(string2).replaceAll("\n");
        string2 = TAG_PATTERN.matcher(string2).replaceAll("");
        string2 = string2.replace("&nbsp;", " ");
        return string2.trim();
    }

    protected void setEating(boolean bl) {
        boolean bl2 = false;
        if (bl) {
            if (this.choking.isVisible()) {
                if (this.eating.isVisible()) {
                    this.eating.setVisible(false);
                    bl2 = true;
                }
            } else if (!this.eating.isVisible()) {
                this.eating.setVisible(true);
                bl2 = true;
            }
        } else if (this.eating.isVisible()) {
            this.eating.setVisible(false);
            bl2 = true;
        }
        if (bl2) {
            this.updatePanelTooltip();
        }
    }

    protected void setChoking(boolean bl) {
        boolean bl2 = false;
        if (this.choking.isVisible() != bl) {
            this.choking.setVisible(bl);
            bl2 = true;
        }
        if (bl && this.eating.isVisible()) {
            this.eating.setVisible(false);
            bl2 = true;
        }
        if (bl2) {
            this.updatePanelTooltip();
        }
    }

    void setStatus(StatusID statusID, boolean bl) {
        JLabel jLabel = this.statusIDMap.get((Object)statusID);
        if (jLabel.isVisible() != bl) {
            jLabel.setVisible(bl);
            this.updatePanelTooltip();
        }
    }

    void resetStatuses() {
        boolean bl = false;
        for (JLabel jLabel : this.statusIDMap.values()) {
            if (!jLabel.isVisible()) continue;
            jLabel.setVisible(false);
            bl = true;
        }
        if (bl) {
            this.updatePanelTooltip();
        }
    }

    void setAway(String string) {
        boolean bl = string != null;
        boolean bl2 = false;
        if (bl) {
            if (this.awayMessage == null || !string.equals(this.awayMessage)) {
                this.awayMessage = string;
                String string2 = "<html>Jeste\u015b oddalony z wiadomo\u015bci\u0105:<br><b>" + string;
                this.away.setToolTipText(string2);
                if (this.away.getAccessibleContext() != null) {
                    this.away.getAccessibleContext().setAccessibleDescription(string2);
                }
                bl2 = true;
            }
        } else if (this.awayMessage != null) {
            this.awayMessage = null;
            this.away.setToolTipText(null);
            if (this.away.getAccessibleContext() != null) {
                this.away.getAccessibleContext().setAccessibleDescription(null);
            }
            bl2 = true;
        }
        if (this.away.isVisible() != bl) {
            this.away.setVisible(bl);
            bl2 = true;
        }
        if (bl2) {
            this.updatePanelTooltip();
        }
    }

    void setGrumpy(String string) {
        boolean bl = string != null;
        boolean bl2 = false;
        if (bl) {
            if (this.grumpyMessage == null || !string.equals(this.grumpyMessage)) {
                this.grumpyMessage = string;
                String string2 = "<html>Jeste\u015b niedost\u0119pny z wiadomo\u015bci\u0105:<br><b>" + string;
                this.grumpy.setToolTipText(string2);
                if (this.grumpy.getAccessibleContext() != null) {
                    this.grumpy.getAccessibleContext().setAccessibleDescription(string2);
                }
                bl2 = true;
            }
        } else if (this.grumpyMessage != null) {
            this.grumpyMessage = null;
            this.grumpy.setToolTipText(null);
            if (this.grumpy.getAccessibleContext() != null) {
                this.grumpy.getAccessibleContext().setAccessibleDescription(null);
            }
            bl2 = true;
        }
        if (this.grumpy.isVisible() != bl) {
            this.grumpy.setVisible(bl);
            bl2 = true;
        }
        if (bl2) {
            this.updatePanelTooltip();
        }
    }

    static {
        SpriteStore spriteStore = SpriteStore.get();
        awaySprite = spriteStore.getSprite("data/sprites/ideas/away.png");
        grumpySprite = spriteStore.getSprite("data/sprites/ideas/grumpy.png");
    }
}

