/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.styled;

import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import games.stendhal.common.MathHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class StyledTabbedPaneUI
extends BasicTabbedPaneUI {
    private final Style style;

    public static ComponentUI createUI(JComponent jComponent) {
        return new StyledTabbedPaneUI(StyleUtil.getStyle());
    }

    StyledTabbedPaneUI(Style style) {
        this.style = style;
    }

    @Override
    protected void paintContentBorder(Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getWidth();
        int n4 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
        switch (n) {
            case 1: {
                n6 += n7;
                break;
            }
        }
        StyleUtil.fillBackground(this.style, graphics, n5, n6, n3, n4 -= n7);
        this.style.getBorder().paintBorder(this.tabPane, graphics, n5, n6, n3, n4);
        int n8 = this.tabPane.getSelectedIndex();
        Rectangle rectangle = this.getTabBounds(n8, this.calcRect);
        rectangle = rectangle.intersection(new Rectangle(n5, n6, n3, n4));
        int n9 = this.style.getBorder().getBorderInsets((Component)this.tabPane).left;
        StyleUtil.fillBackground(this.style, graphics, rectangle.x + n9, rectangle.y, rectangle.width - 2 * n9, rectangle.height);
    }

    @Override
    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        if (n2 == this.getFocusIndex() && this.tabPane.isFocusOwner()) {
            graphics.setColor(this.focus);
            graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        StyleUtil.fillBackground(this.style, graphics, n3, n4, n5, n6);
        Color color = this.tabPane.getBackgroundAt(n2);
        if (color != null && !(color instanceof ColorUIResource)) {
            graphics.setColor(color);
            graphics.fillRect(n3, n4, n5, n6);
        }
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.style.getBorder().paintBorder(this.tabPane, graphics, n3, n4, n5, n6);
    }

    public void setTabLabelMargins(int n) {
        this.tabInsets = (Insets)this.tabInsets.clone();
        this.tabInsets.left = n;
        this.tabInsets.right = n;
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setFont(this.style.getFont());
        jComponent.setForeground(this.style.getForeground());
        this.focus = this.style.getShadowColor();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.tabPane.addMouseWheelListener(new MouseWheelHandler());
    }

    private class MouseWheelHandler
    implements MouseWheelListener {
        private MouseWheelHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            int n = StyledTabbedPaneUI.this.tabPane.getSelectedIndex();
            int n2 = MathHelper.clamp(n + mouseWheelEvent.getWheelRotation(), 0, StyledTabbedPaneUI.this.tabPane.getTabCount() - 1);
            if (n2 != n) {
                StyledTabbedPaneUI.this.tabPane.setSelectedIndex(n2);
            }
        }
    }
}

