/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.trade;

import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.factory.EntityMap;
import games.stendhal.client.gui.InternalManagedWindow;
import games.stendhal.client.gui.SlotGrid;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.gui.trade.TradingController;
import games.stendhal.common.TradeState;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;

class TradingWindow
extends InternalManagedWindow {
    private static final long serialVersionUID = -8404391354667893368L;
    private final TradingController controller;
    private final SlotGrid partnerSlots;
    private final SlotGrid mySlots;
    private final JLabel partnersOfferLabel;
    private final JButton offerButton;
    private final JButton acceptButton;
    private final JButton cancelButton;
    private final JLabel myOfferStatus;
    private final JLabel partnerOfferStatus;

    public TradingWindow(final TradingController tradingController) {
        super("trade", "Trading");
        this.controller = tradingController;
        JComponent jComponent = SBoxLayout.createContainer(false, 5);
        jComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JComponent jComponent2 = SBoxLayout.createContainer(true, 5);
        jComponent.add(jComponent2);
        JComponent jComponent3 = SBoxLayout.createContainer(false, 5);
        this.partnersOfferLabel = new JLabel("Biuro partnera");
        this.partnersOfferLabel.setAlignmentX(0.5f);
        jComponent3.add(this.partnersOfferLabel);
        this.partnerSlots = new SlotGrid(2, 2);
        jComponent3.add(this.partnerSlots);
        this.partnerOfferStatus = new JLabel("Zmieniam");
        this.partnerOfferStatus.setAlignmentX(0.5f);
        jComponent3.add(this.partnerOfferStatus);
        this.acceptButton = new JButton("Zaakceptuj");
        this.acceptButton.setEnabled(false);
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                tradingController.acceptTrade();
            }
        });
        this.acceptButton.setAlignmentX(1.0f);
        jComponent3.add(this.acceptButton);
        jComponent2.add(jComponent3);
        jComponent2.add((Component)new JSeparator(1), (Object)SLayout.EXPAND_Y);
        JComponent jComponent4 = SBoxLayout.createContainer(false, 5);
        JLabel jLabel = new JLabel("Moja oferta");
        jLabel.setAlignmentX(0.5f);
        jComponent4.add(jLabel);
        this.mySlots = new SlotGrid(2, 2);
        this.mySlots.setAcceptedTypes(EntityMap.getClass("item", null, null));
        jComponent4.add(this.mySlots);
        jComponent2.add(jComponent4);
        this.myOfferStatus = new JLabel("Zmieniam");
        this.myOfferStatus.setAlignmentX(0.5f);
        jComponent4.add(this.myOfferStatus);
        this.offerButton = new JButton("Zaoferuj");
        this.offerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                tradingController.lockTrade();
            }
        });
        this.offerButton.setAlignmentX(1.0f);
        jComponent4.add(this.offerButton);
        jComponent.add((Component)new JSeparator(0), (Object)SLayout.EXPAND_X);
        this.cancelButton = new JButton("Anuluj");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TradingWindow.this.close();
            }
        });
        this.cancelButton.setAlignmentX(1.0f);
        jComponent.add(this.cancelButton);
        this.setContent(jComponent);
    }

    @Override
    public void close() {
        super.close();
        this.controller.cancelTrade();
    }

    void setPartnerName(String string) {
        this.setTitle("Handel z " + string);
        this.partnersOfferLabel.setText("Oferta " + string);
    }

    void setUserStatus(TradeState tradeState) {
        this.setTraderStatus(this.myOfferStatus, tradeState);
    }

    void setPartnerStatus(TradeState tradeState) {
        this.setTraderStatus(this.partnerOfferStatus, tradeState);
    }

    private void setTraderStatus(JLabel jLabel, TradeState tradeState) {
        switch (tradeState) {
            case NO_ACTIVE_TRADE: {
                jLabel.setForeground(Color.GRAY);
                jLabel.setText("Nieaktywny");
                break;
            }
            case MAKING_OFFERS: {
                jLabel.setForeground(Color.GRAY);
                jLabel.setText("Zmieniam");
                break;
            }
            case LOCKED: {
                jLabel.setForeground(Color.WHITE);
                jLabel.setText("Zaoferowa\u0142e\u015b");
                break;
            }
            case DEAL_WAITING_FOR_OTHER_DEAL: {
                jLabel.setForeground(Color.GREEN);
                jLabel.setText("ZAAKCEPTOWANE");
                break;
            }
        }
    }

    void setUserSlot(IEntity iEntity, String string) {
        this.mySlots.setSlot(iEntity, string);
    }

    void setPartnerSlot(IEntity iEntity, String string) {
        this.partnerSlots.setSlot(iEntity, string);
    }

    void disableAll() {
        this.offerButton.setEnabled(false);
        this.acceptButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.setUserStatus(TradeState.NO_ACTIVE_TRADE);
        this.setPartnerStatus(TradeState.NO_ACTIVE_TRADE);
    }

    void allowOffer(boolean bl) {
        this.offerButton.setEnabled(bl);
    }

    void allowAccept(boolean bl) {
        this.acceptButton.setEnabled(bl);
    }

    void allowCancel(boolean bl) {
        this.cancelButton.setEnabled(bl);
    }
}

