/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class DeviceEvaluator {
    private final ArrayList<Device> mDevices;

    public DeviceEvaluator() {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        this.mDevices = new ArrayList(infoArray.length);
        for (Mixer.Info info : infoArray) {
            this.mDevices.add(new Device(info.getName(), info.getDescription(), AudioSystem.getMixer(info)));
        }
    }

    public void setRating(Pattern pattern, Pattern pattern2, int n) {
        for (Device device : this.mDevices) {
            if (pattern == null) continue;
            if (pattern.matcher(device.mName).matches()) {
                device.mRating = n;
                continue;
            }
            if (pattern2 == null || !pattern.matcher(device.mDescription).matches()) continue;
            device.mRating = n;
        }
    }

    public List<Device> createDeviceList(AudioFormat audioFormat) {
        ArrayList arrayList = (ArrayList)this.mDevices.clone();
        DeviceEvaluator.sortDeviceList(arrayList, audioFormat);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            Device device = (Device)listIterator.next();
            if (device.mMixer.getMaxLines(info) != 0) continue;
            listIterator.remove();
        }
        return arrayList;
    }

    private static void sortDeviceList(List<Device> list, AudioFormat audioFormat) {
        final DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        Collections.sort(list, new Comparator<Device>(){

            @Override
            public int compare(Device device, Device device2) {
                int n = device.mMixer.getMaxLines(info);
                int n2 = device2.mMixer.getMaxLines(info);
                if (n2 == 0) {
                    return -1;
                }
                if (device.mRating == device2.mRating ? n == -1 || n > n2 : device.mRating > device2.mRating) {
                    return -1;
                }
                return 1;
            }
        });
    }

    public static void main(String[] stringArray) {
        AudioFormat audioFormat = new AudioFormat(44100.0f, 16, 2, true, false);
        DeviceEvaluator deviceEvaluator = new DeviceEvaluator();
        deviceEvaluator.setRating(Pattern.compile(".*PulseAudio.*"), null, 1);
        deviceEvaluator.setRating(Pattern.compile(".*Java Sound Audio Engine.*"), null, -1);
        List<Device> list = deviceEvaluator.createDeviceList(audioFormat);
        for (Device device : list) {
            System.out.println(device.mName + " num lines " + device.getMaxLines(SourceDataLine.class, audioFormat));
        }
    }

    public static final class Device {
        private final String mName;
        private final String mDescription;
        private final Mixer mMixer;
        private int mRating;

        private Device(String string, String string2, Mixer mixer) {
            this.mName = string;
            this.mDescription = string2;
            this.mMixer = mixer;
            this.mRating = 0;
        }

        public String getName() {
            return this.mName;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public int getRating() {
            return this.mRating;
        }

        public <T> int getMaxLines(Class<T> clazz, AudioFormat audioFormat) {
            return this.mMixer.getMaxLines(new DataLine.Info(clazz, audioFormat));
        }

        public <T extends Line> T getLine(Class<T> clazz, AudioFormat audioFormat) {
            try {
                DataLine.Info info = new DataLine.Info(clazz, audioFormat, -1);
                return (T)this.mMixer.getLine(info);
            }
            catch (LineUnavailableException lineUnavailableException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return null;
        }
    }
}

