/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound.manager;

import games.stendhal.client.sound.facade.AudibleArea;
import games.stendhal.client.sound.facade.InfiniteAudibleArea;
import games.stendhal.client.sound.facade.SoundFileType;
import games.stendhal.client.sound.facade.Time;
import games.stendhal.client.sound.manager.AudioResource;
import games.stendhal.client.sound.manager.SoundFile;
import games.stendhal.client.sound.system.SignalProcessor;
import games.stendhal.client.sound.system.SoundSystem;
import games.stendhal.client.sound.system.processors.DirectedSound;
import games.stendhal.client.sound.system.processors.Interruptor;
import games.stendhal.client.sound.system.processors.SoundLayers;
import games.stendhal.client.sound.system.processors.VolumeAdjustor;
import games.stendhal.common.math.Algebra;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.sound.sampled.AudioFormat;
import org.apache.log4j.Logger;

public final class SoundManager {
    private static final Logger logger = Logger.getLogger(SoundManager.class);
    private static final int OUTPUT_NUM_SAMPLES = 256;
    private static final int SOUND_CHANNEL_LIMIT = 0;
    private static final int USE_NUM_MIXER_LINES = 0;
    private static final int DIMENSION = 2;
    private static final float[] HEARER_LOOKONG_DIRECTION = new float[]{0.0f, 1.0f};
    private static final AudioFormat AUDIO_FORMAT = new AudioFormat(44100.0f, 16, 2, true, false);
    private static final InfiniteAudibleArea INFINITE_AUDIBLE_AREA = new InfiniteAudibleArea();
    public static final Time ZERO_DURATION = new Time();
    private final LinkedList<SoundChannel> mChannels = new LinkedList();
    private final float[] mHearerPosition = new float[2];
    private final SoundLayers mSoundLayers = new SoundLayers();
    private boolean mMute = false;
    private final SoundSystem mSoundSystem;

    protected SoundManager() {
        Algebra.mov_Vecf(this.mHearerPosition, 0.0f);
        this.mSoundSystem = new SoundSystem(null, AUDIO_FORMAT, new Time(15L, Time.Unit.MILLI), 0);
        this.mSoundSystem.setDaemon(true);
        this.mSoundSystem.start();
    }

    public Sound openSound(AudioResource audioResource, SoundFileType soundFileType) {
        return this.openSound(audioResource, soundFileType, 256, true);
    }

    public synchronized Sound openSound(AudioResource audioResource, SoundFileType soundFileType, int n, boolean bl) {
        Sound sound = null;
        try {
            SoundFile soundFile = new SoundFile(audioResource, soundFileType, n, bl);
            sound = new Sound();
            sound.file.set(soundFile);
        }
        catch (IOException iOException) {
            logger.warn((Object)iOException);
            return null;
        }
        return sound;
    }

    public synchronized void setHearerPosition(float[] fArray) {
        Algebra.mov_Vecf(this.mHearerPosition, fArray);
    }

    public synchronized void update() {
        for (SoundChannel soundChannel : this.mChannels) {
            if (!soundChannel.isActive()) continue;
            soundChannel.update();
        }
    }

    public synchronized void play(Sound sound, float f, int n, AudibleArea audibleArea, boolean bl, Time time) {
        if (sound == null) {
            return;
        }
        if (sound.isActive()) {
            SoundChannel soundChannel = sound.channel.get();
            soundChannel.setAutoRepeat(bl);
            soundChannel.startFading(1.0f, time);
            soundChannel.setVolume(f);
            soundChannel.setLayer(n);
            soundChannel.setAudibleArea(audibleArea);
            soundChannel.resumePlayback();
            soundChannel.update();
        } else if (!this.mMute) {
            SoundChannel soundChannel = this.getInactiveChannel();
            soundChannel.setAutoRepeat(bl);
            soundChannel.setLayer(n);
            soundChannel.setAudibleArea(audibleArea);
            soundChannel.playSound(sound, f, time);
            soundChannel.update();
            this.closeInactiveChannels(0);
        }
    }

    public synchronized void stop(Sound sound, Time time) {
        if (sound != null && sound.isActive()) {
            sound.channel.get().stopPlayback(time);
        }
    }

    public synchronized void changeVolume(Sound sound, float f) {
        if (sound != null && sound.isActive()) {
            sound.channel.get().setVolume(f);
        }
    }

    public synchronized void changeLayer(Sound sound, int n) {
        if (sound != null && sound.isActive()) {
            sound.channel.get().setLayer(n);
        }
    }

    public synchronized void changeAudibleArea(Sound sound, AudibleArea audibleArea) {
        if (sound != null && sound.isActive()) {
            sound.channel.get().setAudibleArea(audibleArea);
        }
    }

    public synchronized void mute(boolean bl, boolean bl2, Time time) {
        if (bl && !this.mMute) {
            logger.info((Object)"turning off audio");
            this.mSoundSystem.suspend(time);
            if (bl2) {
                for (SoundChannel soundChannel : this.mChannels) {
                    if (!soundChannel.isActive()) continue;
                    soundChannel.startFading(0.0f, time);
                }
            }
        }
        if (!bl && this.mMute) {
            logger.info((Object)"turning on audio");
            this.mSoundSystem.proceed(null);
            if (bl2) {
                for (SoundChannel soundChannel : this.mChannels) {
                    if (!soundChannel.isActive()) continue;
                    soundChannel.startFading(time);
                }
            }
        }
        this.mMute = bl;
    }

    public synchronized Collection<Sound> getActiveSounds() {
        ArrayList<Sound> arrayList = new ArrayList<Sound>(this.mChannels.size());
        for (SoundChannel soundChannel : this.mChannels) {
            Sound sound = soundChannel.getSoundObject();
            if (sound == null || !sound.isActive()) continue;
            arrayList.add(sound);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public synchronized void exit() {
        this.mSoundSystem.exit(null);
        try {
            this.mSoundSystem.join();
        }
        catch (InterruptedException interruptedException) {
            logger.warn((Object)("joining sound system thread was interrupted: " + interruptedException));
        }
    }

    private void closeInactiveChannels(int n) {
        int n2 = this.mChannels.size();
        Iterator iterator = this.mChannels.iterator();
        while (iterator.hasNext() && this.mChannels.size() > n) {
            SoundChannel soundChannel = (SoundChannel)iterator.next();
            if (soundChannel.isActive()) continue;
            soundChannel.close();
            iterator.remove();
        }
        if ((n2 -= this.mChannels.size()) > 0) {
            logger.debug((Object)("close " + n2 + " inactive sound channels"));
        }
    }

    private SoundChannel getInactiveChannel() {
        SoundChannel soundChannel = null;
        for (SoundChannel soundChannel2 : this.mChannels) {
            if (soundChannel2.isActive()) continue;
            soundChannel = soundChannel2;
            break;
        }
        if (soundChannel == null) {
            soundChannel = new SoundChannel();
            this.mChannels.add(soundChannel);
            logger.debug((Object)("open new sound channel (number " + this.mChannels.size() + ")"));
        }
        return soundChannel;
    }

    private final class SoundChannel
    extends SignalProcessor {
        final float[] mSoundPosition = new float[2];
        final AtomicBoolean mAutoRepeat = new AtomicBoolean(false);
        final AtomicBoolean mIsActive = new AtomicBoolean(false);
        final AtomicReference<AudibleArea> mAudibleArea = new AtomicReference<InfiniteAudibleArea>(SoundManager.access$000());
        final Interruptor mInterruptor = new Interruptor();
        final DirectedSound mDirectedSound = new DirectedSound();
        final VolumeAdjustor mGlobalVolume = new VolumeAdjustor();
        final SoundLayers.VolumeAdjustor mLayerVolume;
        final SoundSystem.Output mOutput;
        Sound mSound = null;

        SoundChannel() {
            this.mOutput = SoundManager.this.mSoundSystem.openOutput(AUDIO_FORMAT);
            this.mLayerVolume = SoundManager.this.mSoundLayers.createVolumeAdjustor(0);
            SignalProcessor.createChain(this.mInterruptor, this, this.mLayerVolume, this.mGlobalVolume, this.mDirectedSound, this.mOutput);
        }

        boolean isActive() {
            return this.mIsActive.get();
        }

        void setAutoRepeat(boolean bl) {
            this.mAutoRepeat.set(bl);
        }

        void setVolume(float f) {
            this.mGlobalVolume.setVolume(f);
        }

        void startFading(float f, Time time) {
            this.mGlobalVolume.startFading(f, time);
        }

        void startFading(Time time) {
            this.mGlobalVolume.startFading(time);
        }

        void setLayer(int n) {
            this.mLayerVolume.setLayer(n);
        }

        void resumePlayback() {
            this.mInterruptor.play();
        }

        void close() {
            SoundManager.this.mSoundSystem.closeOutput(this.mOutput);
        }

        Sound getSoundObject() {
            return this.mSound;
        }

        void setAudibleArea(AudibleArea audibleArea) {
            if (audibleArea == null) {
                audibleArea = INFINITE_AUDIBLE_AREA;
            }
            this.mAudibleArea.set(audibleArea);
        }

        synchronized void playSound(Sound sound, float f, Time time) {
            if (this.mSound != null) {
                this.mSound.file.get().disconnect();
                this.mSound.file.get().restart();
                this.mSound.channel.set(null);
                this.mLayerVolume.setIntensity(0.0f);
            }
            if (sound != null) {
                if (time == null) {
                    time = ZERO_DURATION;
                }
                this.mInterruptor.play();
                this.mGlobalVolume.setVolume(0.0f);
                this.mGlobalVolume.startFading(f, time);
                sound.channel.set(this);
                sound.file.get().connectTo(this.mInterruptor, true);
            }
            this.mSound = sound;
            this.mIsActive.set(sound != null);
        }

        void stopPlayback(Time time) {
            if (time == null) {
                time = ZERO_DURATION;
            }
            this.mAutoRepeat.set(false);
            this.mGlobalVolume.startFading(0.0f, time);
            this.mInterruptor.stop(time);
        }

        void update() {
            float f = this.mAudibleArea.get().getHearingIntensity(SoundManager.this.mHearerPosition);
            this.mAudibleArea.get().getClosestPoint(this.mSoundPosition, SoundManager.this.mHearerPosition);
            this.mDirectedSound.setPositions2D(this.mSoundPosition, SoundManager.this.mHearerPosition, HEARER_LOOKONG_DIRECTION, f);
            this.mLayerVolume.setIntensity(f);
        }

        @Override
        protected void finished() {
            if (this.mAutoRepeat.get()) {
                this.mSound.file.get().restart();
            } else {
                this.playSound(null, 0.0f, null);
                super.quit();
            }
        }
    }

    public static final class Sound
    implements Cloneable {
        final AtomicReference<SoundFile> file = new AtomicReference<Object>(null);
        final AtomicReference<SoundChannel> channel = new AtomicReference<Object>(null);
        Object object = null;

        public Sound clone() {
            Sound sound = new Sound();
            sound.file.set(this.file.get().clone());
            sound.object = this.object;
            return sound;
        }

        public <T> T getAttachment(Class<T> clazz) {
            if (clazz.isInstance(this.object)) {
                return (T)this.object;
            }
            return null;
        }

        public Object getAttachment() {
            return this.object;
        }

        public boolean isActive() {
            return this.channel.get() != null && this.channel.get().isActive();
        }

        public void setAttachment(Object object) {
            this.object = object;
        }
    }
}

