/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sprite;

import games.stendhal.client.sprite.Sprite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Objects;

public class FlippedSprite
implements Sprite {
    private static final int FLIP_HORIZONTALLY_FLAG = Integer.MIN_VALUE;
    private static final int FLIP_VERTICALLY_FLAG = 0x40000000;
    private static final int FLIP_DIAGONALLY_FLAG = 0x20000000;
    private final Sprite orig;
    private final Object ref;
    private final AffineTransform flip;

    public FlippedSprite(Sprite sprite, int n) {
        this.orig = sprite;
        this.ref = new FlipReference(sprite.getReference(), n);
        this.flip = new AffineTransform();
        if ((n & Integer.MIN_VALUE) != 0) {
            this.flip.scale(-1.0, 1.0);
            this.flip.translate(-sprite.getWidth(), 0.0);
        }
        if ((n & 0x40000000) != 0) {
            this.flip.scale(1.0, -1.0);
            this.flip.translate(0.0, -sprite.getHeight());
        }
        if ((n & 0x20000000) != 0) {
            AffineTransform affineTransform = new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
            this.flip.concatenate(affineTransform);
        }
    }

    @Override
    public Sprite createRegion(int n, int n2, int n3, int n4, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void draw(Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        AffineTransform affineTransform = graphics2D.getTransform();
        affineTransform.translate(n, n2);
        affineTransform.concatenate(this.flip);
        graphics2D.setTransform(affineTransform);
        this.orig.draw(graphics2D, 0, 0);
        graphics2D.dispose();
    }

    @Override
    public void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getHeight() {
        return this.orig.getHeight();
    }

    @Override
    public Object getReference() {
        return this.ref;
    }

    @Override
    public int getWidth() {
        return this.orig.getWidth();
    }

    @Override
    public boolean isConstant() {
        return this.orig.isConstant();
    }

    private static class FlipReference {
        private final int flags;
        private final Object otherRef;

        FlipReference(Object object, int n) {
            this.otherRef = object;
            this.flags = n;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object.getClass() == FlipReference.class) {
                FlipReference flipReference = (FlipReference)object;
                return flipReference.flags == this.flags && flipReference.otherRef.equals(this.otherRef);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.otherRef, this.flags);
        }
    }
}

