/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.CStatusSender;
import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.GameLoop;
import games.stendhal.client.LogUncaughtExceptionHandler;
import games.stendhal.client.OutfitStore;
import games.stendhal.client.PerceptionDispatcher;
import games.stendhal.client.StendhalClient;
import games.stendhal.client.TileStore;
import games.stendhal.client.UserContext;
import games.stendhal.client.actions.MoveContinuousAction;
import games.stendhal.client.gui.StendhalFirstScreen;
import games.stendhal.client.gui.j2DClient;
import games.stendhal.client.gui.login.LoginDialog;
import games.stendhal.client.gui.login.Profile;
import games.stendhal.client.gui.styled.StyledLookAndFeel;
import games.stendhal.client.gui.styled.styles.StyleFactory;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.update.ClientGameConfiguration;
import games.stendhal.common.Debug;
import games.stendhal.common.MathHelper;
import games.stendhal.common.Version;
import java.awt.Dimension;
import java.io.File;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import marauroa.common.Log4J;
import marauroa.common.MarauroaUncaughtExceptionHandler;
import org.apache.log4j.Logger;

public final class stendhal {
    private static final String LOG_FOLDER = "log/";
    private static final Logger logger = Logger.getLogger(stendhal.class);
    private static final String STENDHAL_FOLDER;
    public static final String GAME_NAME;
    private static String gameFolder;
    static boolean WEB_START_SANDBOX;
    public static final String VERSION;
    private static final List<Dimension> displaySizes;
    public static final Integer SIZE_INDEX;
    public static final Integer SIZE_INDEX_LARGE;
    public static final Integer SIZE_INDEX_WIDE;
    public static final Integer DISPLAY_SIZE_INDEX;
    private static final String DISPLAY_INDEX_PROPERTY = "display.index";
    public static final boolean SHOW_COLLISION_DETECTION = false;
    public static final boolean SHOW_EVERYONE_ATTACK_INFO = false;
    public static final boolean FILTER_ATTACK_MESSAGES = true;
    public static final int DEFAULT_FPS_LIMIT = 60;
    private static volatile int fpsLimit;
    private static final CountDownLatch latch;

    private stendhal() {
    }

    private static void initGameFolder() {
        File file;
        String string = System.getProperty("user.home") + STENDHAL_FOLDER;
        String string2 = "AIX|Digital Unix|FreeBSD|HP UX|Irix|Linux|Mac OS X|Solaris";
        String string3 = System.getProperty("os.name");
        if (string3.matches(string2) && !(file = new File(string + "user.dat")).exists()) {
            gameFolder = System.getProperty("user.home") + File.separator + ".config" + File.separator + STENDHAL_FOLDER;
            return;
        }
        gameFolder = string;
    }

    public static void setDoLogin() {
        latch.countDown();
    }

    public static Dimension getDisplaySize() {
        int n = stendhal.getDisplaySizeIndex();
        return displaySizes.get(MathHelper.clamp(n, 0, Math.max(0, displaySizes.size() - 1)));
    }

    public static List<Dimension> getAvailableDisplaySizes() {
        return new ArrayList<Dimension>(displaySizes);
    }

    public static int getDisplaySizeIndex() {
        String string = System.getProperty(DISPLAY_INDEX_PROPERTY);
        int n = MathHelper.parseIntDefault(string, DISPLAY_SIZE_INDEX);
        if (n < 0 || n >= displaySizes.size()) {
            logger.error((Object)("Invalid client size index: " + string + " (" + n + ")"));
        }
        return MathHelper.clamp(n, 0, Math.max(0, displaySizes.size() - 1));
    }

    public static void setDisplaySizeIndex(int n) {
        int n2 = MathHelper.clamp(n, 0, Math.max(0, displaySizes.size() - 1));
        System.setProperty(DISPLAY_INDEX_PROPERTY, Integer.toString(n2));
    }

    public static int getFpsLimit() {
        return fpsLimit;
    }

    public static void setFpsLimit(int n) {
        fpsLimit = Math.max(1, n);
    }

    private static void initUsableDisplaySizes() {
        displaySizes.add(new Dimension(800, 600));
        displaySizes.add(new Dimension(864, 600));
        displaySizes.add(new Dimension(928, 644));
        displaySizes.add(new Dimension(1056, 732));
        displaySizes.add(new Dimension(1184, 820));
        displaySizes.add(new Dimension(1280, 820));
        displaySizes.add(new Dimension(1376, 820));
    }

    private static void startLogSystem() {
        stendhal.prepareLoggingSystemEnviroment();
        logger.debug((Object)"XXXXXXX");
        logger.info((Object)("-Setting base at :" + STENDHAL_FOLDER));
        Log4J.init((String)"data/conf/log4j.properties");
        logger.debug((Object)"XXXXXXX");
        logger.info((Object)("Setting base at :" + STENDHAL_FOLDER));
        logger.info((Object)("PolanieOnLine " + VERSION));
        logger.info((Object)Debug.PRE_RELEASE_VERSION);
        logger.info((Object)("Logging to directory: " + stendhal.getLogFolder()));
        String string = System.getProperty("sun.os.patch.level");
        if (string == null || string.equals("unknown")) {
            string = "";
        }
        logger.info((Object)("OS: " + System.getProperty("os.name") + " " + string + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch")));
        logger.info((Object)("Java-Runtime: " + System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version") + " from " + System.getProperty("java.home")));
        logger.info((Object)("Java-VM: " + System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version")));
        LogUncaughtExceptionHandler.setup();
    }

    private static void prepareLoggingSystemEnviroment() {
        System.setProperty("log.directory", stendhal.getLogFolder());
    }

    private static String getLogFolder() {
        return stendhal.getGameFolder() + LOG_FOLDER;
    }

    private static void waitForLogin() {
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Unexpected interrupt", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
    }

    public static String getGameFolder() {
        return gameFolder;
    }

    public static void main(String[] stringArray) {
        stendhal.startLogSystem();
        MarauroaUncaughtExceptionHandler.setup((boolean)false);
        stendhal.initUsableDisplaySizes();
        new Startup(stringArray);
    }

    static {
        WEB_START_SANDBOX = false;
        try {
            System.getProperty("user.home");
        }
        catch (AccessControlException accessControlException) {
            WEB_START_SANDBOX = true;
        }
        GAME_NAME = ClientGameConfiguration.get((String)"GAME_NAME");
        STENDHAL_FOLDER = File.separator + GAME_NAME.toLowerCase(Locale.ENGLISH) + File.separator;
        stendhal.initGameFolder();
        VERSION = Version.getVersion();
        displaySizes = new ArrayList<Dimension>(7);
        SIZE_INDEX = 0;
        SIZE_INDEX_LARGE = 2;
        SIZE_INDEX_WIDE = 2;
        DISPLAY_SIZE_INDEX = SIZE_INDEX_LARGE;
        fpsLimit = 60;
        latch = new CountDownLatch(1);
    }

    private static class Startup {
        StendhalFirstScreen splash;

        Startup(String[] stringArray) {
            Object object;
            WtWindowManager wtWindowManager = WtWindowManager.getInstance();
            List<Dimension> list = stendhal.getAvailableDisplaySizes();
            int n = MathHelper.clamp(wtWindowManager.getPropertyInt("ui.display_size", stendhal.getDisplaySizeIndex()), 0, Math.max(0, list.size() - 1));
            stendhal.setDisplaySizeIndex(n);
            stendhal.setFpsLimit(wtWindowManager.getPropertyInt("ui.fps_limit", 60));
            if (wtWindowManager.getPropertyBoolean("ui.font.overrideaa", false)) {
                System.setProperty("awt.useSystemAAFontSettings", "on");
            }
            String string = wtWindowManager.getProperty("ui.rendering", "");
            TileStore.init();
            ClientSingletonRepository.getEmojiStore().init();
            OutfitStore.get().init();
            final UserContext userContext = UserContext.get();
            final PerceptionDispatcher perceptionDispatcher = new PerceptionDispatcher();
            final StendhalClient stendhalClient = new StendhalClient(userContext, perceptionDispatcher);
            try {
                object = wtWindowManager.getProperty("ui.style", "Jasne drewno (default)");
                StyledLookAndFeel styledLookAndFeel = new StyledLookAndFeel(StyleFactory.createStyle((String)object));
                UIManager.setLookAndFeel(styledLookAndFeel);
                UIManager.put("PopupMenu.consumeEventOnClose", Boolean.TRUE);
                int n2 = wtWindowManager.getPropertyInt("ui.font_size", 12);
                styledLookAndFeel.setDefaultFontSize(n2);
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                logger.error((Object)"Failed to set Look and Feel", (Throwable)unsupportedLookAndFeelException);
            }
            UIManager.getLookAndFeelDefaults().put("ClassLoader", stendhal.class.getClassLoader());
            object = Profile.createFromCommandline(stringArray);
            SwingUtilities.invokeLater(new Runnable((Profile)object, stendhalClient){
                final /* synthetic */ Profile val$profile;
                final /* synthetic */ StendhalClient val$client;
                {
                    this.val$profile = profile;
                    this.val$client = stendhalClient;
                }

                @Override
                public void run() {
                    if (this.val$profile.isValid()) {
                        new LoginDialog(null, this.val$client).connect(this.val$profile);
                    } else {
                        splash = new StendhalFirstScreen(this.val$client);
                    }
                }
            });
            stendhal.waitForLogin();
            CStatusSender.send();
            GameLoop.get().runOnce(new Runnable(){

                @Override
                public void run() {
                    boolean bl = WtWindowManager.getInstance().getPropertyBoolean("move.continuous", false);
                    if (bl) {
                        new MoveContinuousAction().sendAction(true, false);
                    }
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    j2DClient j2DClient2 = new j2DClient(stendhalClient, userContext, splash);
                    perceptionDispatcher.register(j2DClient2.getPerceptionListener());
                    j2DClient2.startGameLoop();
                }
            });
        }
    }
}

