/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.stendhal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import marauroa.client.ClientFramework;
import marauroa.client.net.IPerceptionListener;
import marauroa.client.net.PerceptionHandler;
import marauroa.common.game.RPAction;
import marauroa.common.game.RPObject;
import marauroa.common.net.message.MessageS2CPerception;
import marauroa.common.net.message.TransferContent;

public class textClient
extends Thread {
    private final String host;
    private final String username;
    private final String password;
    private final String character;
    private final String port;
    private static boolean showWorld;
    private final Map<RPObject.ID, RPObject> world_objects;
    private final ClientFramework clientManager;
    private final PerceptionHandler handler;

    public textClient(String string, String string2, String string3, String string4, String string5, boolean bl) {
        this.host = string;
        this.username = string2;
        this.password = string3;
        this.character = string4;
        this.port = string5;
        this.world_objects = new HashMap<RPObject.ID, RPObject>();
        this.handler = new PerceptionHandler(new IPerceptionListener(){

            public boolean onAdded(RPObject rPObject) {
                return false;
            }

            public boolean onClear() {
                return false;
            }

            public boolean onDeleted(RPObject rPObject) {
                return false;
            }

            public void onException(Exception exception, MessageS2CPerception messageS2CPerception) {
                exception.printStackTrace();
            }

            public boolean onModifiedAdded(RPObject rPObject, RPObject rPObject2) {
                return false;
            }

            public boolean onModifiedDeleted(RPObject rPObject, RPObject rPObject2) {
                return false;
            }

            public boolean onMyRPObject(RPObject rPObject, RPObject rPObject2) {
                return false;
            }

            public void onPerceptionBegin(byte by, int n) {
            }

            public void onPerceptionEnd(byte by, int n) {
            }

            public void onSynced() {
            }

            public void onUnsynced() {
            }
        });
        this.clientManager = new ClientFramework("games/stendhal/log4j.properties"){

            protected String getGameName() {
                return "polanieonline";
            }

            protected String getVersionNumber() {
                return stendhal.VERSION;
            }

            protected void onPerception(MessageS2CPerception messageS2CPerception) {
                try {
                    System.out.println("Received perception " + messageS2CPerception.getPerceptionTimestamp());
                    textClient.this.handler.apply(messageS2CPerception, textClient.this.world_objects);
                    int n = messageS2CPerception.getPerceptionTimestamp();
                    RPAction rPAction = new RPAction();
                    if (n % 50 == 0) {
                        rPAction.put("type", "move");
                        rPAction.put("dy", "-1");
                        textClient.this.clientManager.send(rPAction);
                    } else if (n % 50 == 20) {
                        rPAction.put("type", "move");
                        rPAction.put("dy", "1");
                        textClient.this.clientManager.send(rPAction);
                    }
                    if (showWorld) {
                        System.out.println("<World contents ------------------------------------->");
                        int n2 = 0;
                        for (RPObject rPObject : textClient.this.world_objects.values()) {
                            System.out.println(++n2 + ". " + rPObject);
                        }
                        System.out.println("</World contents ------------------------------------->");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            protected List<TransferContent> onTransferREQ(List<TransferContent> list) {
                for (TransferContent transferContent : list) {
                    transferContent.ack = true;
                }
                return list;
            }

            protected void onTransfer(List<TransferContent> list) {
                System.out.println("Transfering ----");
                for (TransferContent transferContent : list) {
                    System.out.println(transferContent);
                }
            }

            protected void onAvailableCharacters(String[] stringArray) {
                System.out.println("Characters available");
                for (String string : stringArray) {
                    System.out.println(string);
                }
                try {
                    this.chooseCharacter(textClient.this.character);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            protected void onServerInfo(String[] stringArray) {
                System.out.println("Server info");
                for (String string : stringArray) {
                    System.out.println(string);
                }
            }

            protected void onPreviousLogins(List<String> list) {
                System.out.println("Previous logins");
                for (String string : list) {
                    System.out.println(string);
                }
            }
        };
    }

    @Override
    public void run() {
        try {
            this.clientManager.connect(this.host, Integer.parseInt(this.port));
            this.clientManager.login(this.username, this.password);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        while (true) {
            this.clientManager.loop(0);
            try {
                textClient.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length > 0) {
                String string = null;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                boolean bl = false;
                for (int i = 0; i != stringArray.length; ++i) {
                    if (stringArray[i].equals("-u")) {
                        string = stringArray[i + 1];
                        continue;
                    }
                    if (stringArray[i].equals("-p")) {
                        string2 = stringArray[i + 1];
                        continue;
                    }
                    if (stringArray[i].equals("-c")) {
                        string3 = stringArray[i + 1];
                        continue;
                    }
                    if (stringArray[i].equals("-h")) {
                        string4 = stringArray[i + 1];
                        continue;
                    }
                    if (stringArray[i].equals("-P")) {
                        string5 = stringArray[i + 1];
                        continue;
                    }
                    if (stringArray[i].equals("-W")) {
                        if (!"1".equals(stringArray[i + 1])) continue;
                        showWorld = true;
                        continue;
                    }
                    if (!stringArray[i].equals("-t")) continue;
                    bl = true;
                }
                if (string != null && string2 != null && string3 != null && string4 != null && string5 != null) {
                    System.out.println("Parameter operation");
                    new textClient(string4, string, string2, string3, string5, bl).start();
                    return;
                }
            }
            System.out.println("Stendhal textClient");
            System.out.println();
            System.out.println("  games.stendhal.textClient -u username -p pass -h host -P port -c character");
            System.out.println();
            System.out.println("Required parameters");
            System.out.println("* -h\tHost that is running Marauroa server");
            System.out.println("* -P\tPort on which Marauroa server is running");
            System.out.println("* -u\tUsername to log into Marauroa server");
            System.out.println("* -p\tPassword to log into Marauroa server");
            System.out.println("* -c\tCharacter used to log into Marauroa server");
            System.out.println("Optional parameters");
            System.out.println("* -W\tShow world content? 0 or 1");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

