/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.constants;

import games.stendhal.common.color.ARGB;
import games.stendhal.common.color.HSL;

public enum SkinColor {
    COLOR1(0.05f, 0.7f),
    COLOR2(0.05f, 0.55f),
    COLOR3(0.05f, 0.4f),
    COLOR4(0.05f, 0.25f),
    COLOR5(0.07f, 0.7f),
    COLOR6(0.07f, 0.55f),
    COLOR7(0.07f, 0.4f),
    COLOR8(0.07f, 0.25f),
    COLOR9(0.09f, 0.7f),
    COLOR10(0.09f, 0.55f),
    COLOR11(0.09f, 0.4f),
    COLOR12(0.09f, 0.25f),
    COLOR13(0.11f, 0.7f),
    COLOR14(0.11f, 0.55f),
    COLOR15(0.11f, 0.4f),
    COLOR16(0.11f, 0.25f);

    private static final float HUE_MIN = 0.05f;
    private static final float HUE_MAX = 0.11f;
    private static final float SAT_MIN = 0.25f;
    private static final float SAT_MAX = 0.7f;
    private final int color;
    public static final int DARK = 3283988;
    public static final int LIGHT = 14860956;

    private SkinColor(float f, float f2) {
        float[] fArray = new float[]{f, f2, 0.5f};
        int[] nArray = new int[4];
        HSL.hsl2rgb(fArray, nArray);
        this.color = ARGB.mergeRgb(nArray);
    }

    public static SkinColor fromInteger(int n) {
        int[] nArray = new int[4];
        ARGB.splitRgb(n, nArray);
        float[] fArray = new float[3];
        HSL.rgb2hsl(nArray, fArray);
        float f = Float.MAX_VALUE;
        SkinColor skinColor = null;
        for (SkinColor skinColor2 : SkinColor.values()) {
            ARGB.splitRgb(skinColor2.color, nArray);
            float[] fArray2 = new float[3];
            HSL.rgb2hsl(nArray, fArray2);
            float f2 = fArray[0] - fArray2[0];
            float f3 = fArray[1] - fArray2[1];
            float f4 = f2 * f2 + f3 * f3;
            if (!(f4 < f)) continue;
            skinColor = skinColor2;
            f = f4;
        }
        return skinColor;
    }

    public int getColor() {
        return this.color;
    }

    public static boolean isValidColor(int n) {
        float[] fArray = new float[3];
        int[] nArray = new int[4];
        ARGB.splitRgb(n, nArray);
        HSL.rgb2hsl(nArray, fArray);
        float f = (1.0f - fArray[2]) / 4.0f + 0.02f;
        float f2 = (1.0f - fArray[2]) / 3.0f + 0.0125f;
        return SkinColor.isInRange(fArray[0], 0.05f, 0.11f, f) && SkinColor.isInRange(fArray[1], 0.25f, 0.7f, f2);
    }

    private static boolean isInRange(float f, float f2, float f3, float f4) {
        return f + f4 >= f2 && f - f4 <= f3;
    }
}

