/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.grammar;

import games.stendhal.common.grammar.PrefixExtractor;
import games.stendhal.common.grammar.PrefixManager;
import games.stendhal.common.parser.Expression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.apache.log4j.Logger;

public class Grammar {
    private static final Logger logger = Logger.getLogger(Grammar.class);
    private static Grammar instance;
    private static final String of = " ";

    public static Grammar get() {
        if (instance == null) {
            instance = new Grammar();
        }
        return instance;
    }

    public static String itthem(int n) {
        if (n == 1) {
            return "to";
        }
        return "je";
    }

    public static String makeUpperCaseWord(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string.length() > 0) {
            stringBuilder.append(Character.toUpperCase(string.charAt(0)));
            if (string.length() > 1) {
                stringBuilder.append(string.substring(1));
            }
        }
        return stringBuilder.toString();
    }

    public static String ItThem(int n) {
        return Grammar.makeUpperCaseWord(Grammar.itthem(n));
    }

    public static String itthey(int n) {
        if (n == 1) {
            return "to";
        }
        return "oni";
    }

    public static String ItThey(int n) {
        return Grammar.makeUpperCaseWord(Grammar.itthey(n));
    }

    public static String isare(int n) {
        if (n == 1) {
            return "jest";
        }
        return "s\u0105";
    }

    public static String IsAre(int n) {
        return Grammar.makeUpperCaseWord(Grammar.isare(n));
    }

    public static String hashave(int n) {
        if (n == 1) {
            return "ma";
        }
        return "maj\u0105";
    }

    public static String HasHave(int n) {
        return Grammar.makeUpperCaseWord(Grammar.hashave(n));
    }

    public static String thatthose(int n) {
        if (n == 1) {
            return "ten";
        }
        return "te";
    }

    public static String ThatThose(int n) {
        return Grammar.makeUpperCaseWord(Grammar.thatthose(n));
    }

    public static String thisthese(int n) {
        if (n == 1) {
            return "ten";
        }
        return "te";
    }

    public static String ThisThese(int n) {
        return Grammar.makeUpperCaseWord(Grammar.thisthese(n));
    }

    static String addPrefixIfNotAlreadyThere(String string, String string2, String string3) {
        if (string.startsWith(string2)) {
            return string;
        }
        if (string.startsWith(string3)) {
            return string;
        }
        return string2 + string;
    }

    public static String fullForm(String string) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        String string3 = string2.replace("#", "");
        string3 = string3.startsWith("book ") ? string3.substring(5) + " book" : (string3.indexOf(" armor") > -1 ? Grammar.addPrefixIfNotAlreadyThere(string2, "suit of ", "suits of ") : (string3.startsWith("r\u0119kawic") || string3.startsWith("spodni") ? Grammar.addPrefixIfNotAlreadyThere(string2, "para ", "pary ") : Grammar.replaceInternalByDisplayNames(PrefixManager.s_instance.fullForm(string3, string2))));
        return string3;
    }

    public static String replaceInternalByDisplayNames(String string) {
        return string.replace("icecream", "ice cream");
    }

    public static Expression mergeCompoundNoun(Expression expression, Expression expression2) {
        if (expression.getMainWord().equals("ice") && expression2.getMainWord().equals("cream") || expression.getMainWord().equals("teddy") && expression2.getMainWord().equals("bear")) {
            if (expression.getMainWord().equals("ice")) {
                expression.setNormalized("icecream");
            }
            return expression;
        }
        expression2.mergeLeft(expression, true);
        return expression2;
    }

    public static String extractNoun(String string) {
        String string2;
        if (string == null) {
            string2 = null;
        } else {
            boolean bl;
            PrefixExtractor prefixExtractor = new PrefixExtractor(string);
            do {
                bl = false;
                if (prefixExtractor.extractNounSingular()) {
                    bl = true;
                }
                if (!prefixExtractor.extractNounPlural()) continue;
                bl = true;
            } while (bl);
            string2 = prefixExtractor.toString();
        }
        return string2;
    }

    public static boolean isNormalized(String string) {
        PrefixExtractor prefixExtractor;
        boolean bl = string == null ? true : !(prefixExtractor = new PrefixExtractor(string)).extractNounSingular() && !prefixExtractor.extractNounPlural();
        return bl;
    }

    public static String plural(String string) {
        if (string == null) {
            return null;
        }
        String string2 = Grammar.fullForm(string);
        String string3 = "";
        if (string2.split(of).length > 1) {
            return Grammar.plural(string2.split(of));
        }
        int n = string2.indexOf(43);
        if (n != -1) {
            if (string2.charAt(n - 1) == ' ') {
                string3 = string2.substring(n - 1);
                string2 = string2.substring(0, n - 1);
            } else {
                string3 = string2.substring(n);
                string2 = string2.substring(0, n);
            }
        }
        if (string2.indexOf(of) > -1) {
            return Grammar.plural(string2.substring(0, string2.indexOf(of))) + string2.substring(string2.indexOf(of)) + string3;
        }
        if (string2.equals("money") || string2.equals("kierpce") || string2.equals("korale") || string2.endsWith("\u00f3w") || string2.endsWith("ami")) {
            return string2;
        }
        if (string2.startsWith("r\u0119kawice") || string2.equals("spodnie")) {
            return string2.substring(0, string2.length() - 1) + string3;
        }
        if (string2.startsWith("magia")) {
            return string2.substring(0, string2.length() - 1) + "i" + string3;
        }
        if (string2.startsWith("bro\u0144")) {
            return string2.substring(0, string2.length() - 1) + "ni" + string3;
        }
        if (string2.startsWith("p\u0142aszcz")) {
            return string2 + "y" + string3;
        }
        if (string2.equals("wojownik") || string2.equals("przedmiot")) {
            return string2 + "\u00f3w" + string3;
        }
        if (string2.startsWith("sok")) {
            return string2 + "i" + string3;
        }
        if (string2.equals("miecz")) {
            return string2 + "e" + string3;
        }
        if (string2.equals("dzie\u0144")) {
            return string2.substring(0, string2.length() - 4) + "ni" + string3;
        }
        if (string2.equals("tydzie\u0144")) {
            return string2.substring(0, string2.length() - 5) + "godni" + string3;
        }
        if (string2.endsWith("d\u0119") || string2.endsWith("t\u0119") || string2.endsWith("n\u0119")) {
            return string2.substring(0, string2.length() - 1) + "y" + string3;
        }
        if (string2.endsWith("owy") || string2.endsWith("ki")) {
            return string2 + "ch" + string3;
        }
        if (string2.endsWith("wy")) {
            return string2.substring(0, string2.length() - 2) + "owe" + string3;
        }
        if (string2.endsWith("ik")) {
            return string2.substring(0, string2.length() - 1) + "cy" + string3;
        }
        if (string2.endsWith("o") || string2.endsWith("e")) {
            return string2.substring(0, string2.length() - 1) + "a" + string3;
        }
        if (string2.endsWith("um")) {
            return string2.substring(0, string2.length() - 2) + "a" + string3;
        }
        if (string2.endsWith("ka") || string2.endsWith("ga")) {
            return string2.substring(0, string2.length() - 1) + "i" + string3;
        }
        if (string2.endsWith("ca") || string2.endsWith("ea") || string2.endsWith("ia") || string2.endsWith("ja") || string2.endsWith("la") || string2.endsWith("\u017ca") || string2.endsWith("rza") || string2.endsWith("ta")) {
            return string2.substring(0, string2.length() - 1) + "e" + string3;
        }
        if (string2.endsWith("a")) {
            return string2.substring(0, string2.length() - 1) + "y" + string3;
        }
        if (string2.endsWith("ek")) {
            return string2.substring(0, string2.length() - 2) + "ki" + string3;
        }
        if (string2.endsWith("k") || string2.endsWith("g")) {
            return string2 + "i" + string3;
        }
        if (string2.endsWith("c") || string2.endsWith("j") || string2.endsWith("\u017c") || string2.endsWith("rz")) {
            return string2 + "e" + string3;
        }
        if (string2.endsWith("\u0107")) {
            return string2.substring(0, string2.length() - 1) + "cie" + string3;
        }
        if (string2.endsWith("\u0144")) {
            return string2.substring(0, string2.length() - 1) + "nie" + string3;
        }
        if (string2.endsWith("\u015b")) {
            return string2.substring(0, string2.length() - 1) + "sie" + string3;
        }
        if (string2.endsWith("\u017a")) {
            return string2.substring(0, string2.length() - 1) + "zie" + string3;
        }
        return string2 + "y" + string3;
    }

    public static String plural(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 2) {
            if (stringArray[0].startsWith("zatruta")) {
                stringArray[0] = stringArray[0].substring(0, stringArray[0].length() - 1) + "e";
            }
            if (stringArray[1].startsWith("strza\u0142a")) {
                stringArray[1] = stringArray[1].substring(0, stringArray[1].length() - 1) + "y";
            }
            return stringArray[0] + of + stringArray[1];
        }
        if (stringArray.length == 3) {
            if (stringArray[0].startsWith("nap\u00f3j")) {
                stringArray[0] = stringArray[0].substring(0, stringArray[0].length() - 2) + "oj\u00f3w";
            }
            return stringArray[0] + of + stringArray[1] + of + stringArray[2];
        }
        if (stringArray.length == 4) {
            return stringArray[0] + of + stringArray[1] + of + stringArray[2] + of + stringArray[3];
        }
        return Grammar.plural(stringArray[0]);
    }

    public static String pluralCreature(String string) {
        if (string.equals("chicken")) {
            return "chickens";
        }
        return Grammar.plural(string);
    }

    public static String singular(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "";
        int n = string.indexOf(43);
        if (n != -1) {
            string2 = string.substring(n - 1);
            string = string.substring(0, n - 1);
        }
        if (string.startsWith("para ")) {
            if (string.matches("^para spodnie(\\b.*)?")) {
                string = string.replaceFirst("^para spodnie", "para spodni");
            } else if (string.matches("^para r\u0119kawice(\\b.*)?")) {
                string = string.replaceFirst("^para r\u0119kawice", "para r\u0119kawic");
            } else if (string.matches("^para buty(\\b.*)?")) {
                string = string.replaceFirst("^para buty", "para but\u00f3w");
            }
            String[] stringArray = string.split(of);
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : stringArray) {
                if (string3.endsWith("e")) {
                    string3 = string3.endsWith("ce") ? string3.substring(0, string3.length() - 2) + "czych" : (string3.endsWith("ne") ? string3.substring(0, string3.length() - 2) + "nych" : (string3.endsWith("owe") ? string3.substring(0, string3.length() - 3) + "owych" : (string3.endsWith("ane") ? string3.substring(0, string3.length() - 3) + "anych" : (string3.endsWith("kie") ? string3.substring(0, string3.length() - 3) + "kich" : (string3.endsWith("ze") ? string3.substring(0, string3.length() - 2) + "zych" : string3.substring(0, string3.length() - 1) + "ych")))));
                }
                stringBuilder.append(string3).append(of);
            }
            string = stringBuilder.toString().trim();
            return string;
        }
        if (string.startsWith("kawa\u0142ek ")) {
            if (string.matches("^kawa\u0142ek szynka(\\b.*)?")) {
                string = string.replaceFirst("^kawa\u0142ek szynka", "kawa\u0142ek szynki");
            } else if (string.matches("^kawa\u0142ek mi\u0119so(\\b.*)?")) {
                string = string.replaceFirst("^kawa\u0142ek mi\u0119so", "kawa\u0142ek mi\u0119sa");
            }
            return string;
        }
        if (string.equals("mnich")) {
            return "mnicha" + string2;
        }
        if (string.indexOf(of) > -1) {
            return Grammar.singular(string.substring(0, string.indexOf(of))) + string.substring(string.indexOf(of)) + string2;
        }
        if (string.endsWith("czy")) {
            return string.substring(0, string.length() - 1) + string2;
        }
        if (string.endsWith("\u00f3w")) {
            return string.substring(0, string.length() - 2) + string2;
        }
        return string + string2;
    }

    public static String youryour(int n, String string) {
        if (string.equals("p\u0105czek") || string.equals("chleb")) {
            return Grammar.plnoun(n, "tw\u00f3j");
        }
        return Grammar.plnoun(n, "twoj\u0105");
    }

    /*
     * WARNING - void declaration
     */
    public static String singular(int n, String string) {
        if (string == null) {
            return null;
        }
        String string2 = "";
        int n2 = string.indexOf(43);
        if (n2 != -1) {
            string2 = string.substring(n2 - 1);
            string = string.substring(0, n2 - 1);
        }
        if (string.startsWith("para ")) {
            void var6_13;
            if (string.matches("^para spodnie(\\b.*)?")) {
                string = string.replaceFirst("^para spodnie", "para spodni");
            } else if (string.matches("^para r\u0119kawice(\\b.*)?")) {
                string = string.replaceFirst("^para r\u0119kawice", "para r\u0119kawic");
            } else if (string.matches("^para buty(\\b.*)?")) {
                string = string.replaceFirst("^para buty", "para but\u00f3w");
            }
            String[] stringArray = string.split(of);
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : stringArray) {
                if (string3.endsWith("e")) {
                    string3 = string3.endsWith("ce") ? string3.substring(0, string3.length() - 2) + "czych" : (string3.endsWith("ne") ? string3.substring(0, string3.length() - 2) + "nych" : (string3.endsWith("owe") ? string3.substring(0, string3.length() - 3) + "owych" : (string3.endsWith("ane") ? string3.substring(0, string3.length() - 3) + "anych" : (string3.endsWith("kie") ? string3.substring(0, string3.length() - 3) + "kich" : (string3.endsWith("ze") ? string3.substring(0, string3.length() - 2) + "zych" : string3.substring(0, string3.length() - 1) + "ych")))));
                }
                stringBuilder.append(string3).append(of);
            }
            string = stringBuilder.toString().trim();
            int n3 = n % 10;
            int n4 = n % 100;
            if (n3 >= 2 && n3 <= 4 && (n4 < 12 || n4 > 14)) {
                String string4 = "pary ";
            } else if (n > 1) {
                String string4 = "par ";
            } else {
                String string5 = "para ";
            }
            string = string.replaceFirst("^para ", "").trim();
            return (String)var6_13 + string + string2;
        }
        if (string.startsWith("kawa\u0142ek ")) {
            if (string.matches("^kawa\u0142ek szynka(\\b.*)?")) {
                string = string.replaceFirst("^kawa\u0142ek szynka", "kawa\u0142ek szynki");
            } else if (string.matches("^kawa\u0142ek mi\u0119so(\\b.*)?")) {
                string = string.replaceFirst("^kawa\u0142ek mi\u0119so", "kawa\u0142ek mi\u0119sa");
            }
            if (n > 1) {
                void var6_16;
                int n5 = n % 10;
                int n6 = n % 100;
                if (n5 >= 2 && n5 <= 4 && (n6 < 12 || n6 > 14)) {
                    String string6 = "kawa\u0142ki ";
                } else {
                    String string7 = "kawa\u0142k\u00f3w ";
                }
                string = string.replaceFirst("^kawa\u0142ek ", "").trim();
                return (String)var6_16 + string + string2;
            }
            return string + string2;
        }
        if (string.equals("money")) {
            return Grammar.polishQuantity(string, n) + string2;
        }
        String[] stringArray = string.split(of);
        if (stringArray.length == 2) {
            if (n > 4) {
                if (stringArray[0].startsWith("zatruta")) {
                    stringArray[0] = stringArray[0].substring(0, stringArray[0].length() - 1) + "ych";
                }
                if (stringArray[1].startsWith("strza\u0142a")) {
                    stringArray[1] = stringArray[1].substring(0, stringArray[1].length() - 1);
                }
            }
            return stringArray[0] + of + stringArray[1];
        }
        if (string.indexOf(of) > -1) {
            return Grammar.singular(string.substring(0, string.indexOf(of))) + string.substring(string.indexOf(of)) + string2;
        }
        if (string.equals("b\u0119dzie")) {
            if (n > 1) {
                string = "b\u0119d\u0105";
                return "b\u0119d\u0105";
            }
            return string;
        }
        if (string.equals("p\u0142aszcz")) {
            if (n <= 4) {
                return string + "e" + string2;
            }
            return string + "y" + string2;
        }
        if (string.equals("lazurowy")) {
            if (n <= 4) {
                return string.substring(0, string.length() - 1) + "e" + string2;
            }
            return string + "ch" + string2;
        }
        if (string.equals("borowik")) {
            if (n <= 4) {
                return string + "i" + string2;
            }
            return string + "\u00f3w" + string2;
        }
        if (string.equals("lody") || string.equals("sk\u0142adniki")) {
            if (n > 4 || n == 0) {
                return string.substring(0, string.length() - 1) + "\u00f3w" + string2;
            }
            return string + string2;
        }
        if (string.equals("mnich")) {
            if (n > 1 || n == 0) {
                return string + "\u00f3w" + string2;
            }
            return "mnicha" + string2;
        }
        if (string.equals("strza\u0142a") || string.equals("trucizna")) {
            if (n > 4) {
                return string.substring(0, string.length() - 1) + string2;
            }
            return Grammar.plural(string);
        }
        if (string.endsWith("ty") || string.endsWith("ry") || string.endsWith("wy")) {
            if (n > 1) {
                return string.substring(0, string.length() - 1) + "e" + string2;
            }
            return string;
        }
        if (string.endsWith("\u00f3j")) {
            if (n > 1) {
                return string.substring(0, string.length() - 2) + "oje" + string2;
            }
            return string;
        }
        if (string.endsWith("oj\u0105")) {
            if (n > 1) {
                return string.substring(0, string.length() - 2) + "je" + string2;
            }
            return string;
        }
        if (string.endsWith("t\u0119")) {
            if (n >= 5) {
                return string.substring(0, string.length() - 1) + string2;
            }
            if (n <= 4) {
                return string.substring(0, string.length() - 1) + "y" + string2;
            }
            return string;
        }
        if (string.endsWith("\u0142o")) {
            if (n >= 5) {
                return string + string2;
            }
            if (n <= 4) {
                return string.substring(0, string.length() - 1) + "y" + string2;
            }
            return string;
        }
        if (string.endsWith("czy")) {
            if (n <= 4) {
                return string.substring(0, string.length() - 1) + "e" + string2;
            }
            return string;
        }
        return Grammar.plural(string);
    }

    public static String alternativeSingular(int n, String string) {
        if (string == null) {
            return null;
        }
        String string2 = "";
        int n2 = string.indexOf(43);
        if (n2 != -1) {
            string2 = string.substring(n2 - 1);
            string = string.substring(0, n2 - 1);
        }
        if (string.indexOf(of) > -1) {
            return Grammar.singular(string.substring(0, string.indexOf(of))) + string.substring(string.indexOf(of)) + string2;
        }
        if (string.equals("p\u0105czek")) {
            if (n > 1) {
                return string.substring(0, string.length() - 2) + "kami" + string2;
            }
            return string.substring(0, string.length() - 2) + "kiem" + string2;
        }
        if (string.equals("lina")) {
            if (n == 1) {
                return string.substring(0, string.length() - 1) + "\u0105" + string2;
            }
            return Grammar.singular(n, string);
        }
        if (string.equals("chleb") || string.equals("ametyst")) {
            if (n > 1) {
                return string + "ami" + string2;
            }
            return string + "em" + string2;
        }
        return Grammar.singular(n, string);
    }

    public static String plnoun(int n, String string) {
        String string2 = Grammar.fullForm(string);
        if (n == 1) {
            return Grammar.singular(string2);
        }
        return Grammar.singular(n, string2);
    }

    public static String plnounCreature(int n, String string) {
        if (string.equals("chicken")) {
            if (n == 1) {
                return "chicken";
            }
            return "chickens";
        }
        return Grammar.plnoun(n, string);
    }

    public static String quantityplnoun(int n, String string) {
        String string2 = Grammar.plnoun(n, string);
        if (n == 1) {
            return string2;
        }
        return Integer.toString(n) + of + string2;
    }

    public static String quantityplnounCreature(int n, String string) {
        if (string.equals("chicken")) {
            String string2 = Grammar.plnounCreature(n, string);
            return Integer.toString(n) + of + string2;
        }
        return Grammar.quantityplnoun(n, string);
    }

    public static String quantityplnounWithHash(int n, String string) {
        return Grammar.quantityplnounWithMarker(n, string, '#');
    }

    public static String quantityplnounWithMarker(int n, String string, char c) {
        String string2 = Grammar.plnoun(n, string);
        String string3 = "";
        if (n > 0) {
            string3 = Integer.toString(n) + of;
        }
        StringBuilder stringBuilder = new StringBuilder(string3);
        if (string2.indexOf(32) == -1) {
            stringBuilder.append(c);
            stringBuilder.append(string2);
        } else {
            stringBuilder.append(c);
            stringBuilder.append("'" + string2 + "'");
        }
        return stringBuilder.toString();
    }

    public static String quantityNumberStrNoun(int n, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (n) {
            case 0: {
                stringBuilder.append("0 ");
                break;
            }
            case 1: {
                break;
            }
            default: {
                stringBuilder.append(Grammar.numberString(n)).append(' ');
            }
        }
        stringBuilder.append(Grammar.plnoun(n, string));
        return stringBuilder.toString();
    }

    protected static boolean isVowel(char c) {
        char c2 = Character.toLowerCase(c);
        return c2 == 'a' || c2 == 'e' || c2 == 'i' || c2 == 'o' || c2 == 'u';
    }

    protected static boolean isConsonant(char c) {
        return !Grammar.isVowel(c);
    }

    public static String ordered(int n) {
        switch (n) {
            case 1: {
                return "pierwszy";
            }
            case 2: {
                return "drugi";
            }
            case 3: {
                return "trzeci";
            }
            case 4: {
                return "czwarty";
            }
            case 5: {
                return "pi\u0105ty";
            }
            case 6: {
                return "sz\u00f3sty";
            }
            case 7: {
                return "si\u00f3dmy";
            }
            case 8: {
                return "\u00f3smy";
            }
            case 9: {
                return "dziewi\u0105ty";
            }
            case 10: {
                return "dziesi\u0105ty";
            }
        }
        if (n > 0) {
            return n + Grammar.ordinalSuffix(n);
        }
        logger.error((Object)("Grammar.ordered not implemented for: " + n));
        return Integer.toString(n);
    }

    private static String ordinalSuffix(int n) {
        int n2 = n % 100 / 10;
        if (n2 == 1) {
            return "th";
        }
        int n3 = n % 10;
        if (n3 == 1) {
            return "st";
        }
        if (n3 == 2) {
            return "nd";
        }
        if (n3 == 3) {
            return "rd";
        }
        return "th";
    }

    public static String enumerateCollection(Collection<String> collection) {
        return Grammar.enumerateCollection(collection, "oraz");
    }

    public static String enumerateCollection(Collection<String> collection, String string) {
        String string2;
        if (collection == null) {
            return "";
        }
        String[] stringArray = collection.toArray(new String[collection.size()]);
        if (stringArray.length == 0) {
            string2 = "";
        } else if (stringArray.length == 1) {
            string2 = Grammar.quoteHash(stringArray[0]);
        } else if (stringArray.length == 2) {
            string2 = Grammar.quoteHash(stringArray[0]) + of + string + of + Grammar.quoteHash(stringArray[1]);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuilder.append(Grammar.quoteHash(stringArray[i]) + ", ");
            }
            stringBuilder.append(string + of + Grammar.quoteHash(stringArray[stringArray.length - 1]));
            string2 = stringBuilder.toString();
        }
        return Grammar.replaceInternalByDisplayNames(string2);
    }

    public static String enumerateCollectionWithHash(Collection<String> collection) {
        if (collection == null) {
            return "";
        }
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (String string : collection) {
            arrayList.add("#" + string);
        }
        return Grammar.enumerateCollection(arrayList);
    }

    public static String quoteHash(String string) {
        int n;
        if (string != null && (n = string.indexOf(35)) != -1 && string.indexOf(32, n) != -1 && string.charAt(n + 1) != '\'') {
            return string.substring(0, n) + "#'" + string.substring(n + 1) + '\'';
        }
        return string;
    }

    public static String clockNumberString(int n) {
        switch (n) {
            case 0: {
                return "zerowa";
            }
            case 1: {
                return "pierwsza";
            }
            case 2: {
                return "druga";
            }
            case 3: {
                return "trzecia";
            }
            case 4: {
                return "czwarta";
            }
            case 5: {
                return "pi\u0105ta";
            }
            case 6: {
                return "sz\u00f3sta";
            }
            case 7: {
                return "si\u00f3dma";
            }
            case 8: {
                return "\u00f3sma";
            }
            case 9: {
                return "dziewi\u0105ta";
            }
            case 10: {
                return "dziesi\u0105ta";
            }
            case 11: {
                return "jedenasta";
            }
            case 12: {
                return "dwunasta";
            }
        }
        return Integer.toString(n);
    }

    public static String numberString(int n) {
        switch (n) {
            case 0: {
                return "zero";
            }
            case 1: {
                return "jeden";
            }
            case 2: {
                return "dwa";
            }
            case 3: {
                return "trzy";
            }
            case 4: {
                return "cztery";
            }
            case 5: {
                return "pi\u0119\u0107";
            }
            case 6: {
                return "sze\u015b\u0107";
            }
            case 7: {
                return "siedem";
            }
            case 8: {
                return "osiem";
            }
            case 9: {
                return "dziewi\u0119\u0107";
            }
            case 10: {
                return "dziesi\u0119\u0107";
            }
            case 11: {
                return "jedena\u015bcie";
            }
            case 12: {
                return "dwana\u015bcie";
            }
        }
        return Integer.toString(n);
    }

    public static Integer number(String string) {
        if (string.equals("no") || string.equals("zero")) {
            return 0;
        }
        if (string.equals("one") || string.equals("jeden")) {
            return 1;
        }
        if (string.equals("two") || string.equals("dwa")) {
            return 2;
        }
        if (string.equals("three") || string.equals("trzy")) {
            return 3;
        }
        if (string.equals("four") || string.equals("cztery")) {
            return 4;
        }
        if (string.equals("five") || string.equals("pi\u0119\u0107")) {
            return 5;
        }
        if (string.equals("six") || string.equals("sze\u015b\u0107")) {
            return 6;
        }
        if (string.equals("seven") || string.equals("siedem")) {
            return 7;
        }
        if (string.equals("eight") || string.equals("osiem")) {
            return 8;
        }
        if (string.equals("nine") || string.equals("dziewi\u0119\u0107")) {
            return 9;
        }
        if (string.equals("ten") || string.equals("dziesi\u0119\u0107")) {
            return 10;
        }
        if (string.equals("eleven") || string.equals("jedena\u015bcie")) {
            return 11;
        }
        if (string.equals("twelve") || string.equals("dwana\u015bcie")) {
            return 12;
        }
        return null;
    }

    public static String enumerateCollectionPlural(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (String string : collection) {
            arrayList.add(string);
        }
        return Grammar.enumerateCollection(arrayList);
    }

    public static String genderVerb(String string, String string2) {
        if (string.equals("F")) {
            if (string2.equals("m\u00f3g\u0142")) {
                return "mog\u0142a";
            }
            if (string2.equals("m\u00f3g\u0142bym")) {
                return "mog\u0142abym";
            }
            if (string2.equals("powiniene\u015b")) {
                return "powinna\u015b";
            }
            if (string2.equals("powinienem")) {
                return "powinnam";
            }
            if (string2.equals("go")) {
                return "jej";
            }
            if (string2.equals("narzeczonego")) {
                return "narzeczonej";
            }
            if (string2.equals("ch\u0142op")) {
                return "ch\u0142opka";
            }
            if (string2.equals("kmie\u0107")) {
                return "kmiotka";
            }
            if (string2.equals("mieszczanin")) {
                return "miszczanka";
            }
            if (string2.equals("szlachcic")) {
                return "szlachcianka";
            }
            if (string2.equals("rycerz") || string2.equals("baronet")) {
                return string2;
            }
            if (string2.equals("baron")) {
                return "baronessa";
            }
            if (string2.equals("wicehrabia")) {
                return "wicehrabina";
            }
            if (string2.equals("hrabia")) {
                return "hrabina";
            }
            if (string2.equals("magnat")) {
                return "magnatka";
            }
            if (string2.equals("ksi\u0105\u017ce")) {
                return "ksi\u0119\u017cniczka";
            }
            if (string2.equals("kr\u00f3l")) {
                return "kr\u00f3lowa";
            }
            if (string2.endsWith("\u0105\u0142e\u015b")) {
                return string2.substring(0, string2.length() - 4) + "\u0119\u0142a\u015b";
            }
            if (string2.endsWith("e\u015b")) {
                return string2.substring(0, string2.length() - 2) + "a\u015b";
            }
            if (string2.endsWith("\u00f3s\u0142")) {
                return string2.substring(0, string2.length() - 3) + "os\u0142a";
            }
            if (string2.endsWith("\u00f3d\u0142")) {
                return string2.substring(0, string2.length() - 3) + "od\u0142a";
            }
            if (string2.endsWith("ego")) {
                return string2.substring(0, string2.length() - 3) + "\u0105";
            }
            if (string2.endsWith("y")) {
                return string2.substring(0, string2.length() - 1) + "a";
            }
            if (string2.endsWith("\u0142by\u015b")) {
                return string2.substring(0, string2.length() - 4) + "\u0142aby\u015b";
            }
            if (string2.endsWith("\u0105\u0142")) {
                return string2.substring(0, string2.length() - 2) + "\u0119\u0142a";
            }
            if (string2.endsWith("\u0142em")) {
                return string2.substring(0, string2.length() - 2) + "am";
            }
            return string2 + "a";
        }
        return string2;
    }

    public static String genderNouns(String string, String string2) {
        if (string.endsWith("zwiadowca") || string.endsWith("kawalerzysta") || string.endsWith("morderca") || string.equals("mefisto") || string.startsWith("szkielet") || string.startsWith("zgni\u0142y")) {
            return string2;
        }
        if (string.endsWith("a") || string.startsWith("sztabka") || string.startsWith("bry\u0142ka") || string.startsWith("z\u0142ota") || string.startsWith("z\u0142ote") || string.startsWith("czarna") || string.startsWith("chmara") || string.startsWith("panna") || string.startsWith("mysz") || string.startsWith("kr\u00f3lowa") || string.startsWith("gigantyczna")) {
            if (string2.endsWith("\u00f3j")) {
                return string2.substring(0, string2.length() - 2) + "oja";
            }
            if (string2.endsWith("y")) {
                return string2.substring(0, string2.length() - 1) + "a";
            }
            return string2 + "a";
        }
        if (string.endsWith("e")) {
            if (string2.endsWith("\u00f3j")) {
                return string2.substring(0, string2.length() - 2) + "oje";
            }
            if (string2.endsWith("y")) {
                return string2.substring(0, string2.length() - 1) + "e";
            }
            return string2 + "y";
        }
        if (string.endsWith("o") || string.equals("oczko") || string.equals("oko starsze") || string.equals("co\u015b")) {
            if (string2.endsWith("\u00f3j")) {
                return string2.substring(0, string2.length() - 2) + "oje";
            }
            if (string2.endsWith("y")) {
                return string2.substring(0, string2.length() - 1) + "e";
            }
            return string2 + "o";
        }
        return string2;
    }

    public static String capitalize(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String variation(String string) {
        if (string.equals("stokrotki")) {
            return string.substring(0, string.length() - 2) + "ek";
        }
        if (string.equals("bratek")) {
            return string.substring(0, string.length() - 2) + "\u00f3w";
        }
        if (string.equals("lilia")) {
            return string.substring(0, string.length() - 1) + "i";
        }
        if (string.equals("bielikrasa")) {
            return string.substring(0, string.length() - 1) + "y";
        }
        return string;
    }

    public static String polishQuantity(String string, int n) {
        int n2 = n % 100;
        int n3 = n % 10;
        boolean bl = n3 >= 2 && n3 <= 4 && (n2 < 12 || n2 > 14);
        switch (string.toLowerCase()) {
            case "dukat": {
                if (n == 1) {
                    return "dukat";
                }
                if (bl) {
                    return "dukaty";
                }
                return "dukat\u00f3w";
            }
            case "talar": {
                if (n == 1) {
                    return "talar";
                }
                if (bl) {
                    return "talary";
                }
                return "talar\u00f3w";
            }
            case "miedziak": {
                if (n == 1) {
                    return "miedziak";
                }
                if (bl) {
                    return "miedziaki";
                }
                return "miedziak\u00f3w";
            }
            case "money": {
                if (n == 1) {
                    return "moneta";
                }
                if (bl) {
                    return "monety";
                }
                return "monet";
            }
            case "punkt": {
                if (n == 1) {
                    return "punkt";
                }
                if (bl) {
                    return "punkty";
                }
                return "punkt\u00f3w";
            }
        }
        return string;
    }

    public static String worthForm(String string, int n) {
        if (n > 1) {
            return "warte";
        }
        return "warty";
    }
}

