/*
 * Decompiled with CFR 0.152.
 */
package marauroa.client.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import marauroa.client.net.HTTPConnectSocket;
import marauroa.client.net.INetworkClientManagerInterface;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.Utility;
import marauroa.common.i18n.I18N;
import marauroa.common.net.Decoder;
import marauroa.common.net.Encoder;
import marauroa.common.net.InvalidVersionException;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageC2SLogout;

public final class TCPNetworkClientManager
implements INetworkClientManagerInterface {
    private static final Logger logger = Log4J.getLogger(TCPNetworkClientManager.class);
    int clientid = -1;
    Socket socket;
    private final InetSocketAddress address;
    boolean keepRunning;
    boolean isfinished;
    private final NetworkClientManagerRead readManager;
    private final NetworkClientManagerWrite writeManager;
    final BlockingQueue<Message> processedMessages;
    final Encoder encoder;
    final Decoder decoder;
    boolean connected = false;
    protected static boolean registered = false;
    boolean shouldThrowException;
    InvalidVersionException storedException;

    public TCPNetworkClientManager(String string, int n) throws IOException {
        this(Proxy.NO_PROXY, new InetSocketAddress(string, n));
    }

    public TCPNetworkClientManager(Proxy proxy, InetSocketAddress inetSocketAddress) throws IOException {
        this.address = inetSocketAddress;
        if (this.address.getAddress() == null) {
            throw new IOException(I18N.translate("Unknown Host", new Object[0]));
        }
        this.socket = proxy.type() == Proxy.Type.HTTP ? new HTTPConnectSocket(proxy.address()) : new Socket(proxy);
        this.socket.connect(this.address, 10000);
        this.socket.setTcpNoDelay(true);
        this.socket.setReceiveBufferSize(131072);
        this.keepRunning = true;
        this.isfinished = false;
        this.connected = true;
        this.encoder = Encoder.get();
        this.decoder = Decoder.get();
        this.processedMessages = new LinkedBlockingQueue<Message>();
        this.readManager = new NetworkClientManagerRead();
        this.readManager.start();
        this.writeManager = new NetworkClientManagerWrite();
    }

    @Override
    public void finish() {
        logger.debug("shutting down NetworkClientManager");
        this.keepRunning = false;
        this.connected = false;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.readManager.interrupt();
        while (!this.isfinished) {
            Thread.yield();
        }
        logger.debug("NetworkClientManager is down");
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public synchronized Message getMessage(int n) throws InvalidVersionException {
        if (this.shouldThrowException) {
            this.shouldThrowException = false;
            throw this.storedException;
        }
        try {
            return this.processedMessages.poll(n, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public synchronized void retrieveMessages(Collection<? super Message> collection) {
        this.processedMessages.drainTo(collection);
    }

    @Deprecated
    public synchronized Collection<Message> getMessages() {
        LinkedList<Message> linkedList = new LinkedList<Message>();
        this.processedMessages.drainTo(linkedList);
        return linkedList;
    }

    @Override
    public void addMessage(Message message) {
        this.connected = this.writeManager.write(message);
        logger.debug(this.connected ? "connected" : "disconnected");
    }

    @Override
    public boolean getConnectionState() {
        return this.connected && !this.socket.isClosed();
    }

    class NetworkClientManagerWrite {
        private final Logger logger = Log4J.getLogger(NetworkClientManagerWrite.class);
        private OutputStream os = null;
        boolean loggedOut = false;

        public NetworkClientManagerWrite() {
            try {
                this.os = TCPNetworkClientManager.this.socket.getOutputStream();
                if (!registered) {
                    registered = true;
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            if (!NetworkClientManagerWrite.this.loggedOut) {
                                MessageC2SLogout messageC2SLogout = new MessageC2SLogout(1);
                                NetworkClientManagerWrite.this.write(messageC2SLogout);
                            }
                        }
                    });
                }
            }
            catch (IOException iOException) {
                this.logger.error(iOException, iOException);
            }
        }

        public synchronized boolean write(Message message) {
            if (message instanceof MessageC2SLogout) {
                this.loggedOut = true;
            }
            try {
                if (TCPNetworkClientManager.this.keepRunning) {
                    message.setChannel(null);
                    message.setClientID(TCPNetworkClientManager.this.clientid);
                    if (message.getType() == Message.MessageType.C2S_OUTOFSYNC) {
                        TCPNetworkClientManager.this.processedMessages.clear();
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("build message(type=" + (Object)((Object)message.getType()) + ") from " + message.getClientID() + " full [" + message + "]");
                    }
                    this.os.write(TCPNetworkClientManager.this.encoder.encode(message));
                    return true;
                }
                this.logger.warn("Write requested not to keeprunning");
                TCPNetworkClientManager.this.connected = false;
                return false;
            }
            catch (IOException iOException) {
                this.logger.error("error while sending a packet (msg=(" + message + "))", iOException);
                TCPNetworkClientManager.this.connected = false;
                return false;
            }
        }
    }

    class NetworkClientManagerRead
    extends Thread {
        private final Logger logger;
        private InputStream is;

        public NetworkClientManagerRead() {
            super("NetworkClientManagerRead");
            this.logger = Log4J.getLogger(NetworkClientManagerRead.class);
            this.is = null;
            try {
                this.is = TCPNetworkClientManager.this.socket.getInputStream();
            }
            catch (IOException iOException) {
                this.logger.error(iOException, iOException);
            }
        }

        private synchronized void storeMessage(byte[] byArray) throws IOException {
            try {
                List<Message> list = TCPNetworkClientManager.this.decoder.decode(null, byArray);
                if (list != null) {
                    for (Message message : list) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("build message(type=" + (Object)((Object)message.getType()) + ") from " + message.getClientID() + " full [" + message + "]");
                        }
                        if (message.getType() == Message.MessageType.S2C_LOGIN_SENDNONCE) {
                            TCPNetworkClientManager.this.clientid = message.getClientID();
                        }
                        TCPNetworkClientManager.this.processedMessages.add(message);
                    }
                }
            }
            catch (InvalidVersionException invalidVersionException) {
                TCPNetworkClientManager.this.shouldThrowException = true;
                TCPNetworkClientManager.this.storedException = invalidVersionException;
                this.logger.error("Exception when processing pending packets", invalidVersionException);
            }
        }

        private byte[] readByteStream() throws IOException {
            byte[] byArray = new byte[4];
            byte[] byArray2 = null;
            int n = -1;
            int n2 = -1;
            try {
                while (this.is.available() < 4) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.error(interruptedException, interruptedException);
                    }
                }
                if (this.is.read(byArray) < 0) {
                    TCPNetworkClientManager.this.isfinished = true;
                    return null;
                }
                n = (byArray[0] & 0xFF) + ((byArray[1] & 0xFF) << 8) + ((byArray[2] & 0xFF) << 16) + ((byArray[3] & 0xFF) << 24);
                byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, 4);
                long l = System.currentTimeMillis();
                n2 = 4;
                int n3 = 0;
                long l2 = 10L;
                do {
                    if ((n3 = this.is.read(byArray2, n2 += n3, n - n2)) < 0) {
                        TCPNetworkClientManager.this.isfinished = true;
                        return null;
                    }
                    if (System.currentTimeMillis() - 2000L > l) {
                        this.logger.warn("Waiting for more data");
                        l2 = 1000L;
                    }
                    try {
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.error(interruptedException, interruptedException);
                    }
                } while (n2 + n3 < n);
                this.logger.debug("Received Marauroa Packet");
                return byArray2;
            }
            catch (IOException iOException) {
                this.logger.warn("size buffer: " + Utility.dumpByteArray(byArray));
                this.logger.warn("size: " + n + " start: " + n2);
                this.logger.warn("buffer: " + Utility.dumpByteArray(byArray2));
                throw iOException;
            }
        }

        @Override
        public void run() {
            this.logger.debug("run()");
            while (TCPNetworkClientManager.this.keepRunning) {
                try {
                    byte[] byArray = this.readByteStream();
                    if (byArray == null) {
                        return;
                    }
                    this.storeMessage(byArray);
                }
                catch (IOException iOException) {
                    this.logger.warn("Connection broken.", iOException);
                    TCPNetworkClientManager.this.connected = false;
                    TCPNetworkClientManager.this.keepRunning = false;
                }
            }
            TCPNetworkClientManager.this.isfinished = true;
            this.logger.warn("run() finished");
        }
    }
}

